/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ReadmeTarget
extends Target
implements ActionListener {
    static final int WIDTH = 40;
    static final int HEIGHT = 50;
    static final Color defaultbg = Config.getItemColour("colour.class.bg.default");
    static final Color colBorder = Config.getItemColour("colour.target.border");
    static final Color textfg = Config.getItemColour("colour.text.fg");
    static String openStr = Config.getString("pkgmgr.packagemenu.open");
    static String removeStr = Config.getString("pkgmgr.packagemenu.remove");
    static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    public static final String README_ID = "@README";
    protected Editor editor;
    private Rectangle editorBounds;

    public ReadmeTarget(Package pkg) {
        super(pkg, README_ID);
        this.setPos(10, 10);
        this.setSize(40, 50);
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        if (props.getProperty(prefix + ".editor.x") != null) {
            this.editorBounds = new Rectangle(Integer.parseInt(props.getProperty(prefix + ".editor.x")), Integer.parseInt(props.getProperty(prefix + ".editor.y")), Integer.parseInt(props.getProperty(prefix + ".editor.width")), Integer.parseInt(props.getProperty(prefix + ".editor.height")));
        }
    }

    public void save(Properties props, String prefix) {
        if (this.editor != null) {
            this.editorBounds = this.editor.getBounds();
        }
        if (this.editorBounds != null) {
            props.put(prefix + ".editor.x", String.valueOf((int)this.editorBounds.getX()));
            props.put(prefix + ".editor.y", String.valueOf((int)this.editorBounds.getY()));
            props.put(prefix + ".editor.width", String.valueOf((int)this.editorBounds.getWidth()));
            props.put(prefix + ".editor.height", String.valueOf((int)this.editorBounds.getHeight()));
        }
    }

    public File getSourceFile() {
        return new File(this.getPackage().getPath(), "README.TXT");
    }

    public boolean copyFiles(String directory) {
        return true;
    }

    public boolean isResizable() {
        return false;
    }

    public boolean isHandle() {
        return false;
    }

    public boolean isMoveable() {
        return false;
    }

    public boolean isSaveable() {
        return false;
    }

    Color getBackgroundColour() {
        return defaultbg;
    }

    Color getBorderColour() {
        return colBorder;
    }

    Color getTextColour() {
        return textfg;
    }

    Font getFont() {
        return PrefMgr.getStandardFont();
    }

    public Editor getEditor() {
        if (this.editor == null) {
            this.editor = EditorManager.getEditorManager().openText(this.getSourceFile().getPath(), "README.TXT", this.editorBounds);
        }
        return this.editor;
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void openEditor() {
        if (this.getEditor() == null) {
            try {
                this.getSourceFile().createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (this.getEditor() != null) {
            this.getEditor().setVisible(true);
        }
    }

    public void doubleClick(MouseEvent evt) {
        this.openEditor();
    }

    public void popupMenu(int x, int y) {
        JPopupMenu menu = this.createMenu(null);
        if (menu != null) {
            PackageEditor editor = this.getPackage().getEditor();
            editor.add(menu);
            menu.show(editor, x, y);
        }
    }

    private JPopupMenu createMenu(Class cl) {
        JPopupMenu menu = new JPopupMenu();
        OpenAction openAction = new OpenAction(openStr);
        JMenuItem item = menu.add(openAction);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(envOpColour);
        return menu;
    }

    public void remove() {
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction(String menu) {
            super(menu);
        }

        public void actionPerformed(ActionEvent e) {
            ReadmeTarget.this.openEditor();
        }
    }
}

