/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.dependency;

import bluej.Config;
import bluej.graph.Edge;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.target.DependentTarget;
import bluej.utility.Debug;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public abstract class Dependency
extends Edge {
    Package pkg;
    private static final String removeStr = Config.getString("pkgmgr.classmenu.remove");
    protected boolean selected = false;
    static final int SELECT_DIST = 4;

    public Dependency(Package pkg, DependentTarget from, DependentTarget to) {
        super(from, to);
        this.pkg = pkg;
    }

    public Dependency(Package pkg) {
        this(pkg, null, null);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Dependency)) {
            return false;
        }
        Dependency d = (Dependency)other;
        return d != null && d.from == this.from && d.to == this.to;
    }

    public int hashCode() {
        return this.to.hashCode() - this.from.hashCode();
    }

    public void repaint() {
        if (this.pkg.getEditor() != null) {
            this.pkg.getEditor().repaint();
        }
    }

    public DependentTarget getFrom() {
        return (DependentTarget)this.from;
    }

    public DependentTarget getTo() {
        return (DependentTarget)this.to;
    }

    public void load(Properties props, String prefix) {
        String fromName = props.getProperty(prefix + ".from");
        this.from = this.pkg.getTarget(fromName);
        if (this.from == null) {
            Debug.reportError("Failed to find 'from' target " + fromName);
        }
        String toName = props.getProperty(prefix + ".to");
        this.to = this.pkg.getTarget(toName);
        if (this.to == null) {
            Debug.reportError("Failed to find 'to' target " + toName);
        }
    }

    public void save(Properties props, String prefix) {
        props.put(prefix + ".from", ((DependentTarget)this.from).getIdentifierName());
        props.put(prefix + ".to", ((DependentTarget)this.to).getIdentifierName());
    }

    public void popupMenu(int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new RemoveAction());
        PackageEditor editor = this.pkg.getEditor();
        editor.add(menu);
        menu.show(editor, x, y);
    }

    public String toString() {
        return this.getFrom().getIdentifierName() + " --> " + this.getTo().getIdentifierName();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isHandle(int x, int y) {
        return false;
    }

    public boolean contains(int x, int y) {
        Line line = this.computeLine();
        Rectangle bounds = this.getBoxFromLine(line);
        if (!bounds.contains(x, y)) {
            return false;
        }
        double theta = Math.atan2(-(line.from.y - y), line.from.x - x);
        double norm = Dependency.normDist(line.from.x, line.from.y, x, y, Math.sin(line.angle - theta));
        return norm < 16.0;
    }

    static final double normDist(int ax, int ay, int bx, int by, double scale) {
        return (double)((ax - bx) * (ax - bx) + (ay - by) * (ay - by)) * scale * scale;
    }

    protected Rectangle getBoxFromLine(Line line) {
        int x = Math.min(line.from.x, line.to.x) - 4;
        int y = Math.min(line.from.y, line.to.y) - 4;
        int width = Math.max(line.from.x, line.to.x) - x + 8;
        int height = Math.max(line.from.y, line.to.y) - y + 8;
        return new Rectangle(x, y, width, height);
    }

    public Line computeLine() {
        Point pFrom = new Point(this.from.getX() + this.from.getWidth() / 2, this.from.getY() + this.from.getHeight() / 2);
        Point pTo = new Point(this.to.getX() + this.to.getWidth() / 2, this.to.getY() + this.to.getHeight() / 2);
        double angle = Math.atan2(-(pFrom.y - pTo.y), pFrom.x - pTo.x);
        pFrom = ((DependentTarget)this.from).getAttachment(angle + Math.PI);
        pTo = ((DependentTarget)this.to).getAttachment(angle);
        return new Line(pFrom, pTo, angle);
    }

    public class Line {
        public Point from;
        public Point to;
        double angle;

        Line(Point from, Point to, double angle) {
            this.from = from;
            this.to = to;
            this.angle = angle;
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", removeStr);
        }

        public void actionPerformed(ActionEvent e) {
            Dependency.this.remove();
        }
    }
}

