/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.ExportDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

final class ExportManager {
    private static final String specifyJar = Config.getString("pkgmgr.export.specifyJar");
    private static final String createJarText = Config.getString("pkgmgr.export.createJarText");
    private static final String sourceSuffix = ".java";
    private static final String contextSuffix = ".ctxt";
    private static final String packageFilePrefix = "bluej.pk";
    private static final String packageFileBackup = "bluej.pkh";
    private PkgMgrFrame frame;
    private static final String[] skipDirs = new String[]{"CVS"};

    public ExportManager(PkgMgrFrame frame) {
        this.frame = frame;
    }

    public void export() {
        ExportDialog dialog = new ExportDialog(this.frame);
        boolean okay = dialog.display();
        if (!okay) {
            return;
        }
        String fileName = FileUtility.getFileName(this.frame, specifyJar, createJarText, false, null, false);
        if (fileName == null) {
            return;
        }
        String sourceDir = this.frame.getProject().getProjectDir().getPath();
        this.createJar(fileName, sourceDir, dialog.getMainClass(), dialog.getSelectedLibs(), dialog.includeSource(), dialog.includePkgFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(String fileName, String sourceDir, String mainClass, List userLibs, boolean includeSource, boolean includePkgFiles) {
        String classpath = "";
        ArrayList plusLibs = this.frame.getProject().getPlusLibsContent();
        ArrayList<File> plusLibAsFiles = new ArrayList<File>();
        Iterator it = plusLibs.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            try {
                File file = new File(new URI(url.toString()));
                plusLibAsFiles.add(file);
                classpath = classpath + " " + file.getName();
            }
            catch (URISyntaxException urie) {}
        }
        it = userLibs.iterator();
        while (it.hasNext()) {
            classpath = classpath + " " + ((File)it.next()).getName();
        }
        File jarFile = null;
        File parent = null;
        if (classpath.length() == 0) {
            if (!fileName.endsWith(".jar")) {
                fileName = fileName + ".jar";
            }
            if ((jarFile = new File(fileName)).exists() && DialogManager.askQuestion(this.frame, "error-jar-exists") != 0) {
                return;
            }
        } else {
            if (fileName.endsWith(".jar")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            if ((parent = new File(fileName)).exists() && DialogManager.askQuestion(this.frame, "error-jar-exists") != 0) {
                return;
            }
            parent.mkdir();
            jarFile = new File(parent, parent.getName() + ".jar");
        }
        FileOutputStream oStream = null;
        ZipOutputStream jStream = null;
        try {
            Manifest manifest = new Manifest();
            Attributes attr = manifest.getMainAttributes();
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attr.put(Attributes.Name.MAIN_CLASS, mainClass);
            attr.put(Attributes.Name.CLASS_PATH, classpath);
            oStream = new FileOutputStream(jarFile);
            jStream = new JarOutputStream((OutputStream)oStream, manifest);
            this.writeDirToJar(new File(sourceDir), "", (JarOutputStream)jStream, includeSource, includePkgFiles, jarFile.getCanonicalFile());
            if (parent != null) {
                this.copyLibsToJar(plusLibAsFiles, parent);
                this.copyLibsToJar(userLibs, parent);
            }
            this.frame.setStatus(Config.getString("pkgmgr.exported.jar"));
        }
        catch (IOException exc) {
            DialogManager.showError(this.frame, "error-writing-jar");
            Debug.reportError("problen writing jar file: " + exc);
        }
        finally {
            try {
                if (jStream != null) {
                    jStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void writeDirToJar(File sourceDir, String pathPrefix, JarOutputStream jStream, boolean includeSource, boolean includePkg, File outputFile) throws IOException {
        File[] dir = sourceDir.listFiles();
        for (int i = 0; i < dir.length; ++i) {
            if (dir[i].isDirectory()) {
                if (this.skipDir(dir[i], includePkg)) continue;
                this.writeDirToJar(dir[i], pathPrefix + dir[i].getName() + "/", jStream, includeSource, includePkg, outputFile);
                continue;
            }
            if (this.skipFile(dir[i].getName(), !includeSource, !includePkg) || outputFile.equals(dir[i].getCanonicalFile())) continue;
            this.writeJarEntry(dir[i], jStream, pathPrefix + dir[i].getName());
        }
    }

    private void copyLibsToJar(List userLibs, File destDir) {
        Iterator it = userLibs.iterator();
        while (it.hasNext()) {
            File lib = (File)it.next();
            FileUtility.copyFile(lib, new File(destDir, lib.getName()));
        }
    }

    private boolean skipDir(File dir, boolean includePkg) {
        if (dir.getName().equals("+libs")) {
            return !includePkg;
        }
        for (int i = 0; i < skipDirs.length; ++i) {
            if (!dir.getName().equals(skipDirs[i])) continue;
            return true;
        }
        return false;
    }

    private boolean skipFile(String fileName, boolean skipSource, boolean skipPkg) {
        if (fileName.equals(packageFileBackup)) {
            return true;
        }
        if (fileName.endsWith(sourceSuffix)) {
            return skipSource;
        }
        if (fileName.startsWith(packageFilePrefix) || fileName.endsWith(contextSuffix)) {
            return skipPkg;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarEntry(File file, JarOutputStream jStream, String entryName) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            jStream.putNextEntry(new ZipEntry(entryName));
            FileUtility.copyStream(in, jStream);
        }
        catch (ZipException exc) {
            Debug.message("warning: " + exc);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }
}

