/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.Selection;
import bluej.utility.SortedProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ClassInfo {
    private static final String[] appletClasses = new String[]{"Applet", "JApplet"};
    private static final String[] unitTestClasses = new String[]{"TestCase", "junit.framework.TestCase"};
    private boolean foundClass = false;
    private boolean foundPublicClass = false;
    private String name;
    private String superclass;
    private List implemented = new ArrayList();
    private List imported = new ArrayList();
    private List used = new ArrayList();
    private List comments = new LinkedList();
    private List typeParameterTexts;
    private Selection typeParametersSelection;
    private boolean isInterface = false;
    private boolean isAbstract = false;
    private boolean isApplet = false;
    private boolean isUnitTest = false;
    private boolean isEnum = false;
    private Selection extendsInsertSelection;
    private Selection implementsInsertSelection;
    private Selection extendsReplaceSelection;
    private Selection superReplaceSelection;
    private List interfaceSelections;
    private boolean packageStatementExists = false;
    private Selection packageStatementSelection = new Selection(1, 1);
    private Selection packageNameSelection = new Selection(1, 1);
    private Selection packageSemiSelection = new Selection(1, 1);
    private String packageName = "";

    public boolean foundClass() {
        return this.foundClass;
    }

    public boolean foundPublicClass() {
        return this.foundPublicClass;
    }

    public void setName(String name, boolean pub) {
        this.name = name;
        this.foundClass = true;
        if (pub) {
            this.foundPublicClass = true;
        }
    }

    public void setSuperclass(String name) {
        int i;
        if (name.equals(this.name)) {
            return;
        }
        this.superclass = name;
        if (this.used.contains(name)) {
            this.used.remove(name);
        }
        for (i = 0; i < appletClasses.length; ++i) {
            if (!name.equals(appletClasses[i])) continue;
            this.isApplet = true;
        }
        for (i = 0; i < unitTestClasses.length; ++i) {
            if (!name.equals(unitTestClasses[i])) continue;
            this.isUnitTest = true;
        }
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void addImplements(String name) {
        if (name.equals(this.name)) {
            return;
        }
        if (!this.implemented.contains(name)) {
            this.implemented.add(name);
        }
    }

    public void addImported(String name) {
        if (name.equals(this.name)) {
            return;
        }
        if (!this.imported.contains(name)) {
            this.imported.add(name);
        }
    }

    public void addUsed(String name) {
        if (name.equals(this.name)) {
            return;
        }
        if (name.equals(this.superclass)) {
            return;
        }
        if (!this.used.contains(name)) {
            this.used.add(name);
        }
    }

    public void addComment(String target, String comment) {
        this.addComment(target, comment, null);
    }

    public void addComment(String target, String comment, String paramnames) {
        if (comment != null && comment.length() > 4) {
            comment = comment.substring(2, comment.length() - 2);
            StringBuffer finalComment = new StringBuffer(comment.length());
            StringTokenizer tokenizer = new StringTokenizer(comment, "\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                int ch;
                StringBuffer line = new StringBuffer(tokenizer.nextToken());
                int n = ch = line.length() > 0 ? (int)line.charAt(0) : 120;
                while (ch == 32 || ch == 9 || ch == 42) {
                    line.deleteCharAt(0);
                    ch = line.length() > 0 ? (int)line.charAt(0) : 120;
                }
                finalComment.append(line.toString());
                finalComment.append('\n');
            }
            comment = finalComment.toString();
        }
        this.comments.add(new SavedComment(target, comment, paramnames));
    }

    public void setInterface(boolean b) {
        this.isInterface = b;
    }

    public void setAbstract(boolean b) {
        this.isAbstract = b;
    }

    public void setExtendsInsertSelection(Selection s) {
        this.extendsInsertSelection = s;
    }

    public Selection getExtendsInsertSelection() {
        return this.extendsInsertSelection;
    }

    public void setImplementsInsertSelection(Selection s) {
        this.implementsInsertSelection = s;
    }

    public Selection getImplementsInsertSelection() {
        return this.implementsInsertSelection;
    }

    public void setExtendsReplaceSelection(Selection s) {
        this.extendsReplaceSelection = s;
    }

    public Selection getExtendsReplaceSelection() {
        return this.extendsReplaceSelection;
    }

    public void setSuperReplaceSelection(Selection s) {
        this.superReplaceSelection = s;
    }

    public Selection getSuperReplaceSelection() {
        return this.superReplaceSelection;
    }

    public void setInterfaceSelections(List selections) {
        this.interfaceSelections = selections;
    }

    public void setTypeParameterTexts(List newTexts) {
        this.typeParameterTexts = newTexts;
    }

    public List getTypeParameterTexts() {
        return this.typeParameterTexts;
    }

    public List getInterfaceSelections() {
        return this.interfaceSelections;
    }

    public boolean hasInterfaceSelections() {
        return this.interfaceSelections != null && this.interfaceSelections.size() > 0;
    }

    public void setPackageSelections(Selection pkgStatement, Selection pkgName, String pkgNameText, Selection pkgSemi) {
        this.packageStatementSelection = pkgStatement;
        this.packageNameSelection = pkgName;
        this.packageName = pkgNameText;
        this.packageSemiSelection = pkgSemi;
        this.packageStatementExists = true;
    }

    public boolean hasPackageStatement() {
        return this.packageStatementExists;
    }

    public Selection getPackageStatementSelection() {
        return this.packageStatementSelection;
    }

    public Selection getPackageNameSelection() {
        return this.packageNameSelection;
    }

    public Selection getPackageSemiSelection() {
        return this.packageSemiSelection;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public String getName() {
        return this.name;
    }

    public List getImplements() {
        return this.implemented;
    }

    public void setTypeParametersSelection(Selection s) {
        this.typeParametersSelection = s;
    }

    public boolean hasTypeParameter() {
        return this.typeParametersSelection != null;
    }

    public Selection getTypeParametersSelection() {
        return this.typeParametersSelection;
    }

    public List getUsed() {
        return this.used;
    }

    public Properties getComments() {
        SortedProperties props = new SortedProperties();
        props.setProperty("numComments", String.valueOf(this.comments.size()));
        Iterator it = this.comments.iterator();
        int i = 0;
        while (it.hasNext()) {
            SavedComment c = (SavedComment)it.next();
            c.save(props, "comment" + i);
            ++i;
        }
        return props;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void print() {
        System.out.println();
        System.out.println("superclass: " + this.superclass);
        System.out.println();
        System.out.println("implements:");
        Iterator it = this.implemented.iterator();
        while (it.hasNext()) {
            System.out.println("   " + (String)it.next());
        }
        System.out.println();
        System.out.println("uses:");
        it = this.used.iterator();
        while (it.hasNext()) {
            System.out.println("   " + (String)it.next());
        }
        System.out.println();
        System.out.println("imports:");
        it = this.imported.iterator();
        while (it.hasNext()) {
            System.out.println("   " + (String)it.next());
        }
    }

    private class SavedComment {
        public String target;
        public String comment;
        public String paramnames;

        public SavedComment(String target, String comment, String paramnames) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
            this.comment = comment;
            this.paramnames = paramnames;
        }

        public void save(Properties p, String prefix) {
            p.put(prefix + ".target", this.target);
            if (this.comment != null) {
                p.setProperty(prefix + ".text", this.comment);
            }
            if (this.paramnames != null) {
                p.setProperty(prefix + ".params", this.paramnames);
            }
        }
    }
}

