/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.Config;
import bluej.parser.ClassEntity;
import bluej.parser.JavaEntity;
import bluej.parser.PackageOrClass;
import bluej.parser.SemanticException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ImportsCollection {
    private Map normalImports = new HashMap();
    private List wildcardImports = new ArrayList();
    private List staticWildcardImports = new ArrayList();
    private Map staticImports = new HashMap();

    public void clear() {
        this.normalImports.clear();
        this.wildcardImports.clear();
    }

    public void addNormalImport(String name, JavaEntity importEntity) {
        this.normalImports.put(name, importEntity);
    }

    public void addWildcardImport(PackageOrClass importEntity) {
        this.wildcardImports.add(importEntity);
    }

    public void addStaticImport(String name, ClassEntity importEntity) {
        ArrayList<ClassEntity> l = (ArrayList<ClassEntity>)this.staticImports.get(name);
        if (l == null) {
            l = new ArrayList<ClassEntity>();
            this.staticImports.put(name, l);
        }
        l.add(importEntity);
    }

    public void addStaticWildcardImport(ClassEntity importEntity) {
        this.staticWildcardImports.add(importEntity);
    }

    public ClassEntity getTypeImport(String name) {
        ClassEntity r = (ClassEntity)this.normalImports.get(name);
        if (r != null) {
            return r;
        }
        List l = (List)this.staticImports.get(name);
        if (l != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                r = (ClassEntity)i.next();
                try {
                    r = (ClassEntity)r.getPackageOrClassMember(name);
                    return r;
                }
                catch (SemanticException se) {
                }
            }
        }
        return null;
    }

    public List getStaticImports(String name) {
        List l = (List)this.staticImports.get(name);
        if (l == null) {
            l = Collections.EMPTY_LIST;
        }
        return l;
    }

    public List getStaticWildcardImports() {
        return this.staticWildcardImports;
    }

    public ClassEntity getTypeImportWC(String name) {
        PackageOrClass member;
        PackageOrClass importEntity;
        Iterator i = this.wildcardImports.iterator();
        while (i.hasNext()) {
            importEntity = (PackageOrClass)i.next();
            try {
                member = importEntity.getPackageOrClassMember(name);
                if (!member.isClass()) continue;
                return (ClassEntity)member;
            }
            catch (SemanticException se) {
            }
        }
        i = this.staticWildcardImports.iterator();
        while (i.hasNext()) {
            importEntity = (ClassEntity)i.next();
            try {
                member = ((ClassEntity)importEntity).getStaticMemberClass(name);
                return member;
            }
            catch (SemanticException se) {
            }
        }
        return null;
    }

    public String toString() {
        JavaEntity importEntity;
        String rr = "";
        Iterator<Object> i = this.normalImports.values().iterator();
        while (i.hasNext()) {
            importEntity = (JavaEntity)i.next();
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ";" + Config.nl;
        }
        i = this.wildcardImports.iterator();
        while (i.hasNext()) {
            importEntity = (PackageOrClass)i.next();
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ".*;" + Config.nl;
        }
        i = this.staticImports.keySet().iterator();
        while (i.hasNext()) {
            String importName = (String)i.next();
            List l = (List)this.staticImports.get(importName);
            Iterator j = l.iterator();
            while (j.hasNext()) {
                ClassEntity importEntity2 = (ClassEntity)j.next();
                rr = rr + "import static " + importEntity2.getName();
                rr = rr + "." + importName + ";" + Config.nl;
            }
        }
        i = this.staticWildcardImports.iterator();
        while (i.hasNext()) {
            importEntity = (ClassEntity)i.next();
            rr = rr + "import static " + importEntity.getName();
            rr = rr + ".*;" + Config.nl;
        }
        return rr;
    }
}

