/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.Config;
import bluej.graph.Graph;
import bluej.graph.GraphEditor;
import bluej.graph.GraphElement;
import bluej.graph.Marquee;
import bluej.graph.RubberBand;
import bluej.graph.SelectableGraphElement;
import bluej.graph.SelectionSet;
import bluej.graph.TraverseStragegy;
import bluej.graph.TraverseStragegyImpl;
import bluej.graph.Vertex;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.List;

public class SelectionController
implements MouseListener,
MouseMotionListener,
KeyListener {
    private GraphEditor graphEditor;
    private Graph graph;
    private Marquee marquee;
    private SelectionSet selection;
    private RubberBand rubberBand;
    private boolean moving = false;
    private boolean resizing = false;
    private int dragStartX;
    private int dragStartY;
    private int keyDeltaX;
    private int keyDeltaY;
    private int currentDependencyIndex;
    private TraverseStragegy traverseStragegiImpl = new TraverseStragegyImpl();

    public SelectionController(GraphEditor graphEditor) {
        this.graphEditor = graphEditor;
        this.graph = graphEditor.getGraph();
        this.marquee = new Marquee(this.graph);
        this.selection = new SelectionSet();
    }

    public void mousePressed(MouseEvent evt) {
        this.graphEditor.requestFocus();
        int clickX = evt.getX();
        int clickY = evt.getY();
        SelectableGraphElement clickedElement = this.graph.findGraphElement(clickX, clickY);
        this.notifyPackage(clickedElement);
        if (clickedElement == null) {
            if (!this.isMultiselectionKeyDown(evt)) {
                this.selection.clear();
            }
            if (this.isButtonOne(evt)) {
                this.marquee.start(clickX, clickY);
            }
        } else if (this.isButtonOne(evt)) {
            if (this.isMultiselectionKeyDown(evt)) {
                if (clickedElement.isSelected()) {
                    this.selection.remove(clickedElement);
                } else {
                    this.selection.add(clickedElement);
                }
            } else if (!clickedElement.isSelected()) {
                this.selection.selectOnly(clickedElement);
            }
            if (this.isDrawingDependency()) {
                if (clickedElement instanceof Target) {
                    this.rubberBand = new RubberBand(clickX, clickY, clickX, clickY);
                }
            } else {
                this.dragStartX = clickX;
                this.dragStartY = clickY;
                if (clickedElement.isHandle(clickX, clickY)) {
                    this.resizing = true;
                } else {
                    this.moving = true;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.isDrawingDependency()) {
            SelectableGraphElement selectedElement = this.graph.findGraphElement(evt.getX(), evt.getY());
            this.notifyPackage(selectedElement);
            this.graphEditor.repaint();
        }
        this.rubberBand = null;
        SelectionSet newSelection = this.marquee.stop();
        if (newSelection != null) {
            this.selection.addAll(newSelection);
            this.graphEditor.repaint();
        }
        if (this.moving || this.resizing) {
            this.endMove();
            this.graphEditor.revalidate();
            this.graphEditor.repaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.isButtonOne(evt) && evt.getClickCount() > 1) {
            this.selection.doubleClick(evt);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.isButtonOne(evt)) {
            if (this.marquee.isActive()) {
                Rectangle oldRect = this.marquee.getRectangle();
                this.marquee.move(evt.getX(), evt.getY());
                Rectangle newRect = (Rectangle)this.marquee.getRectangle().clone();
                if (oldRect != null) {
                    newRect.add(oldRect);
                }
                ++newRect.width;
                ++newRect.height;
                this.graphEditor.repaint(newRect);
            } else if (this.rubberBand != null) {
                this.rubberBand.setEnd(evt.getX(), evt.getY());
                this.graphEditor.repaint();
            } else {
                if (!this.selection.isEmpty()) {
                    int deltaX = this.snapToGrid(evt.getX() - this.dragStartX);
                    int deltaY = this.snapToGrid(evt.getY() - this.dragStartY);
                    if (this.resizing) {
                        this.selection.resize(deltaX, deltaY);
                    } else {
                        this.selection.move(deltaX, deltaY);
                    }
                }
                this.graphEditor.repaint();
            }
        }
    }

    public void keyPressed(KeyEvent evt) {
        boolean handled = true;
        if (SelectionController.isArrowKey(evt)) {
            if (evt.isControlDown()) {
                if (!this.resizing) {
                    this.startKeyboardResize();
                }
                this.setKeyDelta(evt);
                this.selection.resize(this.keyDeltaX, this.keyDeltaY);
            } else if (evt.isShiftDown()) {
                if (!this.moving) {
                    this.startKeyboardMove();
                }
                this.setKeyDelta(evt);
                this.selection.move(this.keyDeltaX, this.keyDeltaY);
            } else {
                this.navigate(evt);
            }
        } else if (this.isPlusOrMinusKey(evt)) {
            this.resizeWithFixedRatio(evt);
        } else if (evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.selectDependency(evt);
        } else if (evt.getKeyCode() == 32 || evt.getKeyCode() == 10) {
            this.postMenu();
        } else if (evt.getKeyCode() == 65) {
            this.selectAll();
        } else if (evt.getKeyCode() == 27) {
            if (this.moving || this.resizing) {
                this.endMove();
            }
            this.clearSelection();
        } else {
            handled = false;
        }
        if (handled) {
            evt.consume();
        }
        this.graphEditor.repaint();
    }

    public void keyReleased(KeyEvent evt) {
        if (this.moving && !evt.isShiftDown()) {
            this.selection.moveStopped();
            this.moving = false;
        } else if (this.resizing && !evt.isControlDown()) {
            this.selection.moveStopped();
            this.resizing = false;
        }
        this.graphEditor.repaint();
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void notifyPackage(GraphElement element) {
        if (element instanceof ClassTarget) {
            ((Package)this.graph).targetSelected((Target)element);
        } else {
            ((Package)this.graph).targetSelected(null);
        }
    }

    public boolean isDrawingDependency() {
        return ((Package)this.graph).getState() == 2 || ((Package)this.graph).getState() == 4;
    }

    private static boolean isArrowKey(KeyEvent evt) {
        return evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 37 || evt.getKeyCode() == 39;
    }

    private void navigate(KeyEvent evt) {
        Vertex currentTarget = this.findSingleVertex();
        currentTarget = this.traverseStragegiImpl.findNextVertex(this.graph, currentTarget, evt.getKeyCode());
        this.selection.selectOnly(currentTarget);
    }

    private void startKeyboardMove() {
        this.keyDeltaX = 0;
        this.keyDeltaY = 0;
        this.moving = true;
    }

    private void endMove() {
        this.selection.moveStopped();
        this.moving = false;
        this.resizing = false;
    }

    private void startKeyboardResize() {
        this.keyDeltaX = 0;
        this.keyDeltaY = 0;
        this.resizing = true;
    }

    private void setKeyDelta(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 38: {
                this.keyDeltaY -= 10;
                break;
            }
            case 40: {
                this.keyDeltaY += 10;
                break;
            }
            case 37: {
                this.keyDeltaX -= 10;
                break;
            }
            case 39: {
                this.keyDeltaX += 10;
            }
        }
    }

    private boolean isPlusOrMinusKey(KeyEvent evt) {
        return evt.getKeyChar() == '+' || evt.getKeyChar() == '-';
    }

    private void resizeWithFixedRatio(KeyEvent evt) {
        int delta = evt.getKeyChar() == '+' ? 10 : -10;
        this.selection.resize(delta, delta);
        this.selection.moveStopped();
    }

    private void selectDependency(KeyEvent evt) {
        Vertex vertex = this.selection.getAnyVertex();
        if (vertex != null) {
            this.selection.selectOnly(vertex);
            List dependencies = ((DependentTarget)vertex).dependentsAsList();
            Dependency currentDependency = (Dependency)dependencies.get(this.currentDependencyIndex);
            if (currentDependency != null) {
                this.selection.remove(currentDependency);
            }
            this.currentDependencyIndex += evt.getKeyCode() == 33 ? 1 : -1;
            this.currentDependencyIndex %= dependencies.size();
            if (this.currentDependencyIndex < 0) {
                this.currentDependencyIndex = dependencies.size() - 1;
            }
            if ((currentDependency = (Dependency)dependencies.get(this.currentDependencyIndex)) != null) {
                this.selection.add(currentDependency);
            }
        }
    }

    public void handlePopupTrigger(MouseEvent evt) {
        int clickY;
        int clickX = evt.getX();
        SelectableGraphElement clickedElement = this.graph.findGraphElement(clickX, clickY = evt.getY());
        if (clickedElement != null) {
            this.selection.selectOnly(clickedElement);
            this.postMenu(clickedElement, clickX, clickY);
        } else {
            this.postMenu(clickX, clickY);
        }
    }

    private void postMenu(int x, int y) {
        this.graphEditor.popupMenu(x, y);
    }

    private void postMenu() {
        Dependency dependency = (Dependency)this.selection.getAnyEdge();
        if (dependency != null) {
            Point p = ((GraphPainterStdImpl)GraphPainterStdImpl.getInstance()).getDependencyPainter(dependency).getPopupMenuPosition(dependency);
            this.postMenu(dependency, p.x, p.y);
        } else {
            Vertex vertex = this.selection.getAnyVertex();
            if (vertex != null) {
                this.selection.selectOnly(vertex);
                int x = vertex.getX() + vertex.getWidth() - 20;
                int y = vertex.getY() + 20;
                this.postMenu(vertex, x, y);
            }
        }
    }

    private void postMenu(SelectableGraphElement element, int x, int y) {
        element.popupMenu(x, y);
    }

    public Marquee getMarquee() {
        return this.marquee;
    }

    private Vertex findSingleVertex() {
        Vertex vertex = this.selection.getAnyVertex();
        if (vertex == null) {
            vertex = (Vertex)this.graph.getVertices().next();
        }
        return vertex;
    }

    public void clearSelection() {
        this.selection.clear();
    }

    private void selectAll() {
        Iterator i = this.graph.getVertices();
        while (i.hasNext()) {
            this.selection.add((SelectableGraphElement)i.next());
        }
    }

    public void removeFromSelection(SelectableGraphElement element) {
        this.selection.remove(element);
    }

    private boolean isButtonOne(MouseEvent evt) {
        return !evt.isPopupTrigger() && (evt.getModifiers() & 0x10) != 0;
    }

    private boolean isMultiselectionKeyDown(MouseEvent evt) {
        if (Config.isMacOS()) {
            return evt.isShiftDown() || evt.isMetaDown();
        }
        return evt.isShiftDown() || evt.isControlDown();
    }

    private int snapToGrid(int x) {
        int steps = x / 10;
        int new_x = steps * 10;
        return new_x;
    }

    public RubberBand getRubberBand() {
        return this.rubberBand;
    }
}

