/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class ClassInspector
extends Inspector {
    protected static final String CLASS_INSPECT_TITLE = Config.getString("debugger.inspector.class.title");
    protected static final String CLASS_NAME_LABEL = Config.getString("debugger.inspector.class.nameLabel");
    protected static final String ENUM_INSPECT_TITLE = Config.getString("debugger.inspector.enum.title");
    protected static final String ENUM_NAME_LABEL = Config.getString("debugger.inspector.enum.nameLabel");
    protected static final String INTERFACE_INSPECT_TITLE = Config.getString("debugger.inspector.interface.title");
    protected static final String INTERFACE_NAME_LABEL = Config.getString("debugger.inspector.interface.nameLabel");
    protected DebuggerClass myClass;

    public ClassInspector(DebuggerClass clss, InspectorManager inspectorManager, Package pkg, InvokerRecord ir, final JFrame parent) {
        super(inspectorManager, pkg, ir);
        this.myClass = clss;
        final ClassInspector insp = this;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ClassInspector.this.makeFrame();
                ClassInspector.this.pack();
                if (parent instanceof Inspector) {
                    DialogManager.tileWindow(insp, parent);
                } else {
                    DialogManager.centreWindow(insp, parent);
                }
            }
        });
    }

    protected void makeFrame() {
        String className = JavaNames.stripPrefix(this.myClass.getName());
        String headerString = null;
        if (this.myClass.isEnum()) {
            this.setTitle(ENUM_INSPECT_TITLE);
            headerString = ENUM_NAME_LABEL + " " + className;
        } else if (this.myClass.isInterface()) {
            this.setTitle(INTERFACE_INSPECT_TITLE);
            headerString = INTERFACE_NAME_LABEL + " " + className;
        } else {
            this.setTitle(CLASS_INSPECT_TITLE);
            headerString = CLASS_NAME_LABEL + " " + className;
        }
        this.setBorder(BorderFactory.createCompoundBorder(BlueJTheme.shadowBorder, BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JLabel headerLabel = new JLabel(headerString);
        headerLabel.setAlignmentX(0.5f);
        header.add(headerLabel);
        header.add(Box.createVerticalStrut(5));
        header.add(new JSeparator());
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setOpaque(false);
        JScrollPane scrollPane = this.createFieldListScrollPane();
        mainPanel.add((Component)scrollPane, "Center");
        JPanel inspectAndGetButtons = this.createInspectAndGetButtons();
        mainPanel.add((Component)inspectAndGetButtons, "East");
        Insets insets = BlueJTheme.generalBorderWithStatusBar.getBorderInsets(mainPanel);
        mainPanel.setBorder(new EmptyBorder(insets));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        JButton button = this.createCloseButton();
        buttonPanel.add((Component)button, "East");
        bottomPanel.add(buttonPanel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)header, "North");
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.getRootPane().setDefaultButton(button);
    }

    protected boolean showingResult() {
        return false;
    }

    protected Object[] getListData() {
        return this.myClass.getStaticFields(true).toArray(new Object[0]);
    }

    protected void listElementSelected(int slot) {
        if (this.myClass.staticFieldIsObject(slot)) {
            this.setCurrentObj(this.myClass.getStaticFieldObject(slot), this.myClass.getStaticFieldName(slot));
            if (this.myClass.staticFieldIsPublic(slot)) {
                this.setButtonsEnabled(true, true);
            } else {
                this.setButtonsEnabled(true, false);
            }
        } else {
            this.setCurrentObj(null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
    }

    protected void prepareInspection() {
    }

    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.myClass);
        }
    }

    protected void initInspectors(JTabbedPane inspTabs) {
    }

    protected int getPreferredRows() {
        return 8;
    }
}

