/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.debugger.gentype.GenTypeClass;
import bluej.views.CallableView;
import bluej.views.Comment;
import bluej.views.MethodView;

public class ExpressionInformation {
    private Comment comment;
    private String signature;
    private String expression;
    private String dynamicType;
    private MethodView methodView;
    private String invokedOn;
    private String[] args;
    private GenTypeClass instanceType;
    private static final Comment emptyComment = new Comment();

    public ExpressionInformation(MethodView methodView, String instanceName) {
        this.methodView = methodView;
        this.comment = methodView.getComment();
        this.signature = methodView.getLongDesc();
        this.invokedOn = methodView.isStatic() ? methodView.getClassName() : instanceName;
    }

    public ExpressionInformation(MethodView methodView, String instanceName, GenTypeClass instanceType) {
        this.methodView = methodView;
        this.comment = methodView.getComment();
        this.signature = methodView.getLongDesc(instanceType.getMap());
        if (methodView.isStatic()) {
            this.invokedOn = methodView.getClassName();
        } else {
            this.invokedOn = instanceName;
            this.instanceType = instanceType;
        }
    }

    public ExpressionInformation(String expression) {
        this.expression = expression;
    }

    public void setArgumentValues(String[] args) {
        this.args = args;
    }

    public Comment getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        return emptyComment;
    }

    public String getExpression() {
        this.expression = this.invokedOn + "." + this.methodView.getName();
        this.expression = this.expression + "(";
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                String string = this.args[i];
                this.expression = this.expression + string;
                if (i + 1 >= this.args.length) continue;
                this.expression = this.expression + ", ";
            }
        }
        this.expression = this.expression + ")";
        return this.expression;
    }

    public String getSignature() {
        return this.signature;
    }

    public GenTypeClass getInstanceType() {
        return this.instanceType;
    }

    public CallableView getMethodView() {
        return this.methodView;
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        s.append(newline);
        s.append(this.getComment());
        s.append(newline);
        s.append(this.getSignature());
        s.append(newline);
        s.append(this.getExpression());
        return s.toString();
    }
}

