/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.utility.JavaNames;
import java.util.Map;

public abstract class GenTypeParameterizable
extends JavaType {
    private static NameTransform stripPrefixNt = new NameTransform(){

        public String transform(String x) {
            return JavaNames.stripPrefix(x);
        }
    };
    private static NameTransform nullTransform = new NameTransform(){

        public String transform(String x) {
            return x;
        }
    };

    public abstract JavaType mapTparsToTypes(Map var1);

    public abstract boolean equals(GenTypeParameterizable var1);

    public boolean equals(Object other) {
        if (other instanceof GenTypeParameterizable) {
            return this.equals((GenTypeParameterizable)other);
        }
        return false;
    }

    public abstract void getParamsFromTemplate(Map var1, GenTypeParameterizable var2);

    public GenTypeParameterizable precisify(GenTypeParameterizable other) {
        GenTypeSolid upperBound = this.getUpperBound();
        GenTypeSolid lowerBound = this.getLowerBound();
        GenTypeSolid newUpper = null;
        GenTypeSolid otherUpper = IntersectionType.getIntersection(other.getUpperBounds());
        newUpper = otherUpper == null ? upperBound : (upperBound == null ? otherUpper : IntersectionType.getIntersection(new GenTypeSolid[]{otherUpper, upperBound}));
        GenTypeSolid newLower = null;
        GenTypeSolid otherLower = other.getLowerBound();
        newLower = otherLower == null ? lowerBound : (lowerBound == null ? otherLower : GenTypeSolid.lub(new GenTypeSolid[]{otherLower, lowerBound}));
        if (newUpper != null && newUpper.equals(newLower)) {
            return newUpper;
        }
        return new GenTypeWildcard(newUpper, newLower);
    }

    public abstract GenTypeSolid[] getUpperBounds();

    public abstract GenTypeSolid getUpperBound();

    public abstract GenTypeSolid getLowerBound();

    public abstract boolean contains(GenTypeParameterizable var1);

    public String toString(boolean stripPrefix) {
        if (stripPrefix) {
            return this.toString(stripPrefixNt);
        }
        return this.toString(nullTransform);
    }

    public String toTypeArgString(boolean stripPrefix) {
        if (stripPrefix) {
            return this.toString(stripPrefixNt);
        }
        return this.toString(nullTransform);
    }

    public abstract String toTypeArgString(NameTransform var1);
}

