/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.BadInheritanceChainException;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GenTypeClass
extends GenTypeSolid {
    protected List params = null;
    protected Reflective reflective = null;
    protected GenTypeClass outer = null;

    public GenTypeClass(Reflective r) {
        this.reflective = r;
    }

    public GenTypeClass(Reflective r, List params) {
        this.reflective = r;
        if (params != null && !params.isEmpty()) {
            this.params = params;
        }
    }

    public GenTypeClass(Reflective r, List params, GenTypeClass outer) {
        this.reflective = r;
        if (params != null && !params.isEmpty()) {
            this.params = params;
        }
        this.outer = outer;
    }

    public GenTypeClass(Reflective r, Map mparams) {
        this.reflective = r;
        if (mparams == null) {
            return;
        }
        this.params = new ArrayList();
        Iterator declParmsI = r.getTypeParams().iterator();
        while (declParmsI.hasNext()) {
            GenTypeDeclTpar next = (GenTypeDeclTpar)declParmsI.next();
            String nextName = next.getTparName();
            if (mparams.get(nextName) == null) {
                this.params.add(new GenTypeExtends(next.getBound()));
                continue;
            }
            this.params.add(mparams.get(nextName));
            mparams.remove(nextName);
        }
        if (this.params.isEmpty()) {
            this.params = null;
        }
        if (!mparams.isEmpty()) {
            String rName = r.getName();
            int p = rName.lastIndexOf(36);
            if (p == -1) {
                return;
            }
            String outerName = rName.substring(0, p);
            Reflective outerReflective = r.getRelativeClass(outerName);
            if (outerReflective != null) {
                this.outer = new GenTypeClass(outerReflective, mparams);
            }
        }
    }

    public GenTypeClass asClass() {
        return this;
    }

    public JavaType getErasedType() {
        return new GenTypeClass(this.reflective);
    }

    public String rawName() {
        return this.reflective.getName();
    }

    public String arrayComponentName() {
        return "L" + this.rawName() + ";";
    }

    public List getTypeParamList() {
        if (this.params == null) {
            return Collections.EMPTY_LIST;
        }
        return this.params;
    }

    public GenTypeClass getOuterType() {
        return this.outer;
    }

    public boolean isInnerType() {
        return this.reflective.getName().indexOf(36) != -1;
    }

    public boolean isGeneric() {
        if (this.outer != null) {
            return true;
        }
        return this.params != null;
    }

    public boolean isRaw() {
        if (this.outer != null) {
            return false;
        }
        List formalParams = this.reflective.getTypeParams();
        return this.params == null && !formalParams.isEmpty();
    }

    public boolean isInterface() {
        return this.reflective.isInterface();
    }

    public String toString(NameTransform nt) {
        int i;
        String baseClass = this.rawName();
        if (this.outer != null) {
            i = baseClass.lastIndexOf(36);
            baseClass = this.outer.toString(nt) + '.' + baseClass.substring(i + 1);
        } else {
            baseClass = nt.transform(baseClass);
            i = baseClass.lastIndexOf(36);
            while (i != -1) {
                baseClass = baseClass.substring(0, i) + '.' + baseClass.substring(i + 1);
                i = baseClass.lastIndexOf(36);
            }
        }
        if (this.params == null) {
            return baseClass;
        }
        String r = baseClass + '<';
        Iterator i2 = this.params.iterator();
        while (i2.hasNext()) {
            r = r + ((GenTypeParameterizable)i2.next()).toTypeArgString(nt);
            if (!i2.hasNext()) continue;
            r = r + ',';
        }
        r = r + '>';
        return r;
    }

    public String toTypeArgString(NameTransform nt) {
        return this.toString(nt);
    }

    public boolean equals(GenTypeParameterizable other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != GenTypeClass.class) {
            return false;
        }
        GenTypeClass oClass = (GenTypeClass)other;
        if (!this.rawName().equals(oClass.rawName())) {
            return false;
        }
        if (this.outer == null && oClass.outer != null) {
            return false;
        }
        if (this.outer != null && !this.outer.equals(oClass.outer)) {
            return false;
        }
        if (this.params == null && oClass.params == null) {
            return true;
        }
        if (this.params == null && oClass.params != null) {
            return false;
        }
        if (this.params != null && oClass.params == null) {
            return false;
        }
        Iterator i = this.params.iterator();
        Iterator j = oClass.params.iterator();
        while (i.hasNext()) {
            GenTypeParameterizable jNext;
            if (!j.hasNext()) {
                return false;
            }
            GenTypeParameterizable iNext = (GenTypeParameterizable)i.next();
            if (iNext.equals(jNext = (GenTypeParameterizable)j.next())) continue;
            return false;
        }
        return !j.hasNext();
    }

    public Reflective getReflective() {
        return this.reflective;
    }

    public boolean isAssignableFrom(JavaType t) {
        if (t.isNull()) {
            return true;
        }
        if (!(t instanceof GenTypeSolid)) {
            return false;
        }
        GenTypeClass tc = t.asClass();
        if (tc != null) {
            GenTypeClass tclass;
            if (this.isRaw()) {
                return this.reflective.isAssignableFrom(tc.reflective);
            }
            GenTypeClass cclass = this;
            try {
                tclass = tc.mapToSuper(this.reflective.getName());
            }
            catch (BadInheritanceChainException bice) {
                return false;
            }
            if (tclass.isRaw()) {
                return false;
            }
            while (cclass != null) {
                if (cclass.params != null) {
                    Iterator i = cclass.params.iterator();
                    Iterator j = tclass.params.iterator();
                    while (i.hasNext()) {
                        GenTypeParameterizable tpar;
                        GenTypeParameterizable cpar = (GenTypeParameterizable)i.next();
                        if (cpar.contains(tpar = (GenTypeParameterizable)j.next())) continue;
                        return false;
                    }
                }
                cclass = cclass.outer;
                tclass = tclass.outer;
            }
            return true;
        }
        GenTypeClass[] stypes = ((GenTypeSolid)t).getReferenceSupertypes();
        for (int i = 0; i < stypes.length; ++i) {
            if (!this.isAssignableFrom(stypes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean contains(GenTypeParameterizable other) {
        return this.equals(other);
    }

    public boolean isAssignableFrom(GenTypeClass c) {
        Reflective r = c.reflective;
        if (GenTypeClass.getInheritanceChain(r, this.reflective.getName()) != null) {
            GenTypeClass other = c.mapToSuper(this.reflective.getName());
            if (this.isRaw() || other.isRaw()) {
                return true;
            }
            if (this.outer != null && !this.outer.isAssignableFrom(other.outer)) {
                return false;
            }
            if (this.params != null) {
                Iterator i = this.params.iterator();
                Iterator j = other.params.iterator();
                while (i.hasNext()) {
                    GenTypeParameterizable oParam;
                    GenTypeParameterizable myParam = (GenTypeParameterizable)i.next();
                    if (myParam.contains(oParam = (GenTypeParameterizable)j.next())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isAssignableFromRaw(JavaType t) {
        if (!(t instanceof GenTypeClass)) {
            return false;
        }
        GenTypeClass c = (GenTypeClass)t;
        Reflective r = c.reflective;
        return GenTypeClass.getInheritanceChain(r, this.reflective.getName()) != null;
    }

    public GenTypeClass mapToSuper(String basename) {
        String bname;
        if (this.rawName().equals(basename)) {
            return this;
        }
        Stack inheritanceStack = GenTypeClass.getInheritanceChain(this.reflective, basename);
        if (inheritanceStack == null) {
            throw new BadInheritanceChainException();
        }
        Iterator i = inheritanceStack.iterator();
        i.next();
        Reflective subType = this.reflective;
        GenTypeClass ccc = this;
        do {
            Reflective baseType = (Reflective)i.next();
            bname = baseType.getName();
            Map tparams = ccc.getMap();
            ccc = GenTypeClass.mapGenericParamsToDirectBase(tparams, subType, baseType);
            subType = baseType;
        } while (!bname.equals(basename));
        return ccc;
    }

    private static GenTypeClass mapGenericParamsToDirectBase(Map tparams, Reflective subType, Reflective baseType) {
        GenTypeClass baseClass = subType.superTypeByName(baseType.getName());
        if (tparams == null) {
            return new GenTypeClass(baseClass.reflective);
        }
        baseClass = (GenTypeClass)baseClass.mapTparsToTypes(tparams);
        return baseClass;
    }

    public JavaType mapTparsToTypes(Map tparams) {
        if (this.params == null && this.outer == null) {
            return this;
        }
        ArrayList<JavaType> retlist = new ArrayList<JavaType>();
        if (this.params != null) {
            Iterator i = this.params.iterator();
            while (i.hasNext()) {
                retlist.add(((GenTypeParameterizable)i.next()).mapTparsToTypes(tparams));
            }
        }
        GenTypeClass newOuter = null;
        if (this.outer != null) {
            newOuter = (GenTypeClass)this.outer.mapTparsToTypes(tparams);
        }
        return new GenTypeClass(this.reflective, retlist, newOuter);
    }

    public GenTypeClass mapToDerived(Reflective derivedType) {
        if (!this.isGeneric()) {
            return new GenTypeClass(derivedType);
        }
        if (derivedType.getName().equals(this.rawName())) {
            return this;
        }
        Stack classes = GenTypeClass.getInheritanceChain(derivedType, this.rawName());
        if (classes == null) {
            return null;
        }
        GenTypeClass curBaseC = this;
        classes.pop();
        while (!classes.empty()) {
            Reflective curSubtype = (Reflective)classes.pop();
            HashMap newMap = new HashMap();
            GenTypeClass baseDecl = curSubtype.superTypeByName(curBaseC.rawName());
            if (baseDecl.isRaw()) {
                return new GenTypeClass(derivedType);
            }
            baseDecl.getParamsFromTemplate(newMap, curBaseC);
            curBaseC = new GenTypeClass(curSubtype, newMap);
        }
        return curBaseC;
    }

    public Map getMap() {
        if (this.isRaw()) {
            return null;
        }
        HashMap r = new HashMap();
        this.mergeMap(r);
        return r;
    }

    public void mergeMap(Map m) {
        if (this.outer != null) {
            this.outer.mergeMap(m);
        }
        List formalParams = this.reflective.getTypeParams();
        if (this.params == null) {
            return;
        }
        Iterator paramIterator = this.params.iterator();
        Iterator formalIterator = formalParams.iterator();
        while (paramIterator.hasNext()) {
            JavaType paramType = (JavaType)paramIterator.next();
            GenTypeDeclTpar formalType = (GenTypeDeclTpar)formalIterator.next();
            String paramName = formalType.getTparName();
            m.put(paramName, paramType);
        }
    }

    private static Stack getInheritanceChain(Reflective top, String bottom) {
        Stack<Reflective> r = new Stack<Reflective>();
        r.push(top);
        if (top.getName().equals(bottom)) {
            return r;
        }
        List l = top.getSuperTypesR();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Reflective next = (Reflective)i.next();
            Stack r2 = GenTypeClass.getInheritanceChain(next, bottom);
            if (r2 == null) continue;
            r.addAll(r2);
            return r;
        }
        return null;
    }

    public void getParamsFromTemplate(Map r, GenTypeParameterizable template) {
        GenTypeClass classTemplate;
        if (template instanceof GenTypeClass && (classTemplate = (GenTypeClass)template).rawName().equals(this.rawName())) {
            if (this.params == null || classTemplate.params == null) {
                return;
            }
            Iterator i = this.params.iterator();
            Iterator j = classTemplate.params.iterator();
            if (this.outer != null) {
                this.outer.getParamsFromTemplate(r, classTemplate.outer);
            }
            while (i.hasNext() && j.hasNext()) {
                GenTypeSolid ip = (GenTypeSolid)i.next();
                GenTypeParameterizable jp = (GenTypeParameterizable)j.next();
                ip.getParamsFromTemplate(r, jp);
            }
        }
    }

    public void erasedSuperTypes(Set s) {
        Stack<Reflective> refs = new Stack<Reflective>();
        refs.push(this.reflective);
        while (!refs.empty()) {
            Reflective r = (Reflective)refs.pop();
            if (s.contains(r)) continue;
            s.add(r);
            refs.addAll(r.getSuperTypesR());
        }
    }

    public GenTypeClass[] getReferenceSupertypes() {
        return new GenTypeClass[]{this};
    }
}

