/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GenTypeArray
extends GenTypeClass {
    JavaType baseType;

    public GenTypeArray(JavaType baseType, Reflective r) {
        super(r);
        this.baseType = baseType;
    }

    public String toString(boolean stripPrefix) {
        return this.baseType.toString(stripPrefix) + "[]";
    }

    public String toString(NameTransform nt) {
        if (this.baseType instanceof GenTypeParameterizable) {
            return ((GenTypeParameterizable)this.baseType).toString(nt) + "[]";
        }
        return this.baseType.toString() + "[]";
    }

    public String arrayComponentName() {
        return "[" + this.baseType.arrayComponentName();
    }

    public JavaType getArrayComponent() {
        return this.baseType;
    }

    public JavaType mapTparsToTypes(Map tparams) {
        JavaType newBase = this.baseType.mapTparsToTypes(tparams);
        if (newBase == this.baseType) {
            return this;
        }
        return new GenTypeArray(newBase, this.reflective);
    }

    public GenTypeSolid getLowerBound() {
        if (this.baseType.isPrimitive()) {
            return this;
        }
        GenTypeSolid Lbounds = ((GenTypeParameterizable)this.baseType).getLowerBound();
        Reflective newR = Lbounds.getErasedType().asClass().reflective.getArrayOf();
        return new GenTypeArray(Lbounds, newR);
    }

    public JavaType getErasedType() {
        if (this.baseType instanceof GenTypeParameterizable) {
            GenTypeParameterizable pbtype = (GenTypeParameterizable)this.baseType;
            GenTypeClass pbErased = (GenTypeClass)pbtype.getErasedType();
            return new GenTypeArray(pbErased, pbErased.reflective.getArrayOf());
        }
        return this;
    }

    public void erasedSuperTypes(Set s) {
        Stack<Reflective> refs = new Stack<Reflective>();
        if (this.baseType instanceof GenTypeSolid) {
            GenTypeSolid sbaseType = (GenTypeSolid)this.baseType;
            HashSet baseEST = new HashSet();
            sbaseType.erasedSuperTypes(baseEST);
            Iterator i = baseEST.iterator();
            while (i.hasNext()) {
                refs.push(((Reflective)i.next()).getArrayOf());
            }
        } else {
            refs.push(this.reflective);
        }
        while (!refs.empty()) {
            Reflective r = (Reflective)refs.pop();
            if (s.contains(r)) continue;
            s.add(r);
            refs.addAll(r.getSuperTypesR());
        }
    }
}

