/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import [Ljava.lang.String;;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.JavacErrorStream;
import bluej.utility.Debug;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;

class JavacCompilerInternal
extends Compiler {
    public JavacCompilerInternal() {
        this.setDebug(true);
        this.setDeprecation(true);
    }

    public boolean compile(File[] sources, CompileObserver watcher, boolean internal) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCompileOptions());
        for (int i = 0; i < sources.length; ++i) {
            args.add(sources[i].getPath());
        }
        int length = args.size();
        String[] params = new String[length];
        args.toArray(params);
        Class<?> compiler = null;
        Method compileMethod = null;
        try {
            compiler = Class.forName("com.sun.tools.javac.Main");
            if (compiler == null) {
                return false;
            }
            Class[] p = new Class[]{String;.class};
            compileMethod = compiler.getMethod("compile", p);
        }
        catch (ClassNotFoundException e) {
            Debug.message("com.sun.tools.javac.Main compiler is not available");
            return false;
        }
        catch (NoSuchMethodException e) {
            Debug.message("com.sun.tools.javac.Main compile method could not be found");
            return false;
        }
        if (compileMethod == null) {
            return false;
        }
        PrintStream systemErr = System.err;
        JavacErrorStream output = new JavacErrorStream(internal);
        System.setErr(output);
        int result = 1;
        try {
            Object[] arguments = new Object[]{params};
            Object objResult = compileMethod.invoke(compiler.newInstance(), arguments);
            result = (Integer)objResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (output.hasError()) {
            watcher.errorMessage(output.getFilename(), output.getLineNo(), output.getMessage());
        }
        if (output.hasWarnings()) {
            watcher.warningMessage(output.getFilename(), output.getLineNo(), output.getWarning());
        }
        System.setErr(systemErr);
        return result == 0;
    }
}

