/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJPropStringSource;
import bluej.BlueJTheme;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class Config {
    public static final String nl = System.getProperty("line.separator");
    private static Properties system_props;
    private static Properties user_props;
    private static Properties command_props;
    public static Properties moe_system_props;
    public static Properties moe_user_props;
    private static Properties lang_props;
    private static BlueJPropStringSource propSource;
    private static File bluejLibDir;
    private static File userPrefDir;
    public static String compilertype;
    public static String language;
    public static Rectangle screenBounds;
    private static boolean usingMacOSScreenMenubar;
    public static final String osname;
    public static final String DEFAULT_LANGUAGE = "english";
    public static final String BLUEJ_OPENPACKAGE = "bluej.openPackage";
    public static final String bluejDebugLogName = "bluej-debuglog.txt";
    public static final String greenfootDebugLogName = "greenfoot-debuglog.txt";
    public static String debugLogName;
    private static boolean initialised;
    protected static final int SHORTCUT_MASK;
    public static final Border focusBorder;
    public static final Border normalBorder;
    private static Color selectionColour;
    private static List debugVMArgs;

    public static void initialise(File bluejLibDir, Properties tempCommandLineProps) {
        if (initialised) {
            return;
        }
        initialised = true;
        screenBounds = Config.calculateScreenBounds();
        Config.bluejLibDir = bluejLibDir;
        system_props = Config.loadDefs("bluej.defs");
        user_props = new Properties(system_props);
        command_props = new Properties(user_props);
        command_props.putAll((Map<?, ?>)tempCommandLineProps);
        String homeDir = command_props.getProperty("bluej.userHome", null);
        File userHome = homeDir == null ? new File(System.getProperty("user.home")) : new File(homeDir);
        userPrefDir = new File(userHome, Config.getBlueJPrefDirName());
        if (!userPrefDir.isDirectory()) {
            userPrefDir.mkdirs();
        }
        Config.loadProperties("bluej", user_props);
        if (Config.isGreenfoot()) {
            debugLogName = greenfootDebugLogName;
        }
        Config.checkDebug(userPrefDir);
        language = command_props.getProperty("bluej.language", DEFAULT_LANGUAGE);
        lang_props = Config.loadLanguageLabels(language);
        moe_system_props = Config.loadDefs("moe.defs");
        moe_user_props = new Properties(moe_system_props);
        Config.loadProperties("moe", moe_user_props);
        compilertype = Config.getPropString("bluej.compiler.type");
        if (compilertype.equals("internal")) {
            compilertype = "javac";
        }
        String macOSscreenMenuBar = Config.getPropString("bluej.macos.screenmenubar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", macOSscreenMenuBar);
        usingMacOSScreenMenubar = Config.isMacOS() && macOSscreenMenuBar.equals("true");
        boolean themed = Boolean.valueOf(Config.getPropString("bluej.useTheme", "false"));
        if (themed) {
            MetalLookAndFeel.setCurrentTheme(new BlueJTheme());
        }
        String laf = Config.getPropString("bluej.lookAndFeel", "default");
        Config.setLookAndFeel(laf);
        Config.initDebugVMArgs();
        Config.setVMLocale();
        command_props.setProperty("bluej.version", "2.1.2");
    }

    public static void initializeVMside(File bluejLibDir, BlueJPropStringSource propSource) {
        if (initialised) {
            return;
        }
        initialised = true;
        Config.bluejLibDir = bluejLibDir;
        Config.propSource = propSource;
        screenBounds = Config.calculateScreenBounds();
        system_props = new Properties(){

            public String getProperty(String key) {
                return propSource.getBlueJPropertyString(key, null);
            }

            public String getProperty(String key, String def) {
                return propSource.getBlueJPropertyString(key, def);
            }
        };
        user_props = new Properties(system_props){

            public Object setProperty(String key, String val) {
                String rval = this.getProperty(key);
                propSource.setUserProperty(key, val);
                return rval;
            }
        };
        command_props = new Properties(user_props);
        lang_props = new Properties(){

            public String getProperty(String key) {
                return propSource.getLabel(key);
            }

            public String getProperty(String key, String def) {
                return propSource.getLabel(key);
            }
        };
        String homeDir = command_props.getProperty("bluej.userHome", null);
        File userHome = homeDir == null ? new File(System.getProperty("user.home")) : new File(homeDir);
        userPrefDir = new File(userHome, Config.getBlueJPrefDirName());
        if (!userPrefDir.isDirectory()) {
            userPrefDir.mkdirs();
        }
        if ((compilertype = Config.getPropString("bluej.compiler.type")).equals("internal")) {
            compilertype = "javac";
        }
    }

    public static boolean isInitialised() {
        return initialised;
    }

    public static boolean isMacOS() {
        return osname.startsWith("Mac");
    }

    public static boolean isWinOS() {
        return osname.startsWith("Windows");
    }

    public static boolean isLinux() {
        return osname.startsWith("Linux");
    }

    public static boolean isSolaris() {
        return osname.startsWith("Solaris");
    }

    public static boolean isJava15() {
        return System.getProperty("java.specification.version").compareTo("1.5") >= 0;
    }

    public static boolean usingJava15() {
        return Config.isJava15();
    }

    private static String getBlueJPrefDirName() {
        String programName = "bluej";
        if (Config.isGreenfoot()) {
            programName = "greenfoot";
        }
        if (Config.isMacOS()) {
            return "Library/Preferences/org." + programName;
        }
        if (Config.isWinOS()) {
            return programName;
        }
        return "." + programName;
    }

    public static boolean usingMacScreenMenubar() {
        return usingMacOSScreenMenubar;
    }

    private static Rectangle calculateScreenBounds() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(d);
    }

    private static void checkDebug(File userdir) {
        if (!"true".equals(command_props.getProperty("bluej.debug"))) {
            File debugLogFile = new File(userdir, debugLogName);
            try {
                PrintStream outStream = new PrintStream(new FileOutputStream(debugLogFile));
                System.setOut(outStream);
                System.setErr(outStream);
                Debug.message("BlueJ run started: " + new Date());
                Debug.message("BlueJ version 2.1.2    Java version " + System.getProperty("java.version"));
                Debug.message("Virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
                Debug.message("Running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
                Debug.message("Java Home: " + System.getProperty("java.home"));
                Debug.message("----");
            }
            catch (IOException e) {
                Debug.reportError("Warning: Unable to create debug log file.");
            }
        }
    }

    public static void handleExit() {
        Config.saveProperties("bluej", "properties.heading.bluej", user_props);
        Config.saveProperties("moe", "properties.heading.moe", moe_user_props);
    }

    private static Properties loadDefs(String filename) {
        File propsFile = new File(bluejLibDir, filename);
        Properties defs = new Properties();
        try {
            defs.load(new FileInputStream(propsFile));
        }
        catch (Exception e) {
            Debug.reportError("Unable to load definitions file: " + propsFile);
        }
        return defs;
    }

    private static Properties loadLanguageLabels(String language) {
        Properties labels = Config.loadDefs(DEFAULT_LANGUAGE + File.separator + "labels");
        if (!DEFAULT_LANGUAGE.equals(language)) {
            String languageFileName = language + File.separator + "labels";
            File languageFile = new File(bluejLibDir, languageFileName);
            try {
                labels.load(new FileInputStream(languageFile));
            }
            catch (Exception e) {
                Debug.reportError("Unable to load definitions file: " + languageFile);
            }
        }
        return labels;
    }

    private static void loadProperties(String filename, Properties props) {
        File propsFile = new File(userPrefDir, filename + ".properties");
        try {
            props.load(new FileInputStream(propsFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void saveProperties(String filename, String comment, Properties props) {
        File propsFile = new File(userPrefDir, filename + ".properties");
        try {
            props.store(new FileOutputStream(propsFile), Config.getString(comment));
        }
        catch (IOException e) {
            Debug.reportError("could not save properties file " + propsFile);
        }
    }

    public static Properties getMoeHelp() {
        return Config.loadDefs(language + File.separator + "moe.help");
    }

    public static boolean systemContainsKey(String key) {
        return system_props.containsKey(key);
    }

    public static boolean userContainsKey(String key) {
        return user_props.containsKey(key);
    }

    public static boolean commandContainsKey(String key) {
        return command_props.containsKey(key);
    }

    public static String getString(String strname) {
        return Config.getString(strname, strname);
    }

    public static String getString(String strname, String def) {
        int index;
        String str = lang_props.getProperty(strname, def);
        while ((index = str.indexOf(95)) != -1) {
            str = str.substring(0, index) + str.substring(index + 1);
        }
        index = str.indexOf(64);
        if (index != -1) {
            str = str.substring(0, index);
        }
        return str;
    }

    public static int getMnemonicKey(String strname) {
        int mnemonic = 0;
        String str = lang_props.getProperty(strname, strname);
        int index = str.indexOf(95);
        char ch = str.charAt(index + 1);
        String s = ch + "";
        mnemonic = index == -1 ? 0 : KeyStroke.getKeyStroke(s.toUpperCase()).getKeyCode();
        return mnemonic;
    }

    public static boolean hasAcceleratorKey(String strname) {
        return lang_props.getProperty(strname, strname).indexOf(64) != -1;
    }

    public static KeyStroke getAcceleratorKey(String strname) {
        String keyString;
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String str = lang_props.getProperty(strname, strname);
        int index = str.indexOf(64);
        if (str.charAt(++index) == '^') {
            ++index;
            modifiers |= 1;
        }
        if ((keyString = str.substring(index).toUpperCase()).length() == 1) {
            return KeyStroke.getKeyStroke((int)keyString.charAt(0), modifiers);
        }
        KeyStroke k1 = KeyStroke.getKeyStroke(keyString);
        return KeyStroke.getKeyStroke(k1.getKeyCode(), modifiers);
    }

    public static String getPropString(String strname) {
        return Config.getPropString(strname, strname);
    }

    public static String getSystemPropString(String propName) {
        String sysID = osname != null && osname.startsWith("Windows 9") ? "win9x" : (osname != null && osname.equals("Windows Me") ? "win9x" : (osname != null && osname.startsWith("Windows") ? "win" : (osname != null && osname.startsWith("Linux") ? "linux" : (osname != null && osname.startsWith("SunOS") ? "solaris" : (osname != null && osname.startsWith("Mac") ? "macos" : "")))));
        String value = command_props.getProperty(sysID + propName);
        if (value == null) {
            value = command_props.getProperty(propName);
        }
        return value;
    }

    public static String getPropString(String strname, String def) {
        return command_props.getProperty(strname, def);
    }

    public static String getDefaultPropString(String strname, String def) {
        try {
            return system_props.getProperty(strname, def);
        }
        catch (Exception e) {
            Debug.reportError("Could not get string for " + strname);
            return def;
        }
    }

    public static int getPropInteger(String intname, int def) {
        int value;
        try {
            value = Integer.parseInt(command_props.getProperty(intname, String.valueOf(def)));
        }
        catch (NumberFormatException nfe) {
            return def;
        }
        return value;
    }

    public static int getDefaultPropInteger(String intname, int def) {
        int value;
        try {
            value = Integer.parseInt(system_props.getProperty(intname, String.valueOf(def)));
        }
        catch (NumberFormatException nfe) {
            return def;
        }
        return value;
    }

    public static String removeProperty(String propertyName) {
        return (String)user_props.remove(propertyName);
    }

    private static File getImageFile(String propname) {
        String filename = command_props.getProperty(propname);
        if (filename != null) {
            return new File(bluejLibDir, "images" + File.separator + filename);
        }
        return null;
    }

    public static ImageIcon getImageAsIcon(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return new ImageIcon(u);
        }
        catch (MalformedURLException mue) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static String getJDKExecutablePath(String propName, String executableName) {
        String p;
        if (executableName == null) {
            throw new IllegalArgumentException("must provide an executable name");
        }
        String string = p = propName == null ? null : Config.getSystemPropString(propName);
        if (p == null) {
            String jdkPathName = System.getProperty("java.home");
            if (jdkPathName != null) {
                File jdkPath = new File(jdkPathName);
                File binPath = new File(jdkPath, "bin");
                File potentialExe = new File(binPath, executableName);
                if (potentialExe.exists()) {
                    return potentialExe.getAbsolutePath();
                }
                potentialExe = new File(binPath, executableName + ".exe");
                if (potentialExe.exists()) {
                    return potentialExe.getAbsolutePath();
                }
                if ((jdkPath = jdkPath.getParentFile()) != null) {
                    binPath = new File(jdkPath, "bin");
                    potentialExe = new File(binPath, executableName);
                    if (potentialExe.exists()) {
                        return potentialExe.getAbsolutePath();
                    }
                    potentialExe = new File(binPath, executableName + ".exe");
                    if (potentialExe.exists()) {
                        return potentialExe.getAbsolutePath();
                    }
                }
            }
            return executableName;
        }
        return p;
    }

    public static File getTemplateDir() {
        return Config.getLanguageFile("templates");
    }

    public static File getTemplateFile(String base) {
        return new File(Config.getTemplateDir(), base + ".tmpl");
    }

    public static File getClassTemplateDir() {
        String path = command_props.getProperty("bluej.templatePath", "");
        if (path.length() == 0) {
            return Config.getLanguageFile("templates/newclass");
        }
        return new File(path);
    }

    public static File getClassTemplateFile(String base) {
        return new File(Config.getClassTemplateDir(), base + ".tmpl");
    }

    public static File getLanguageFile(String base) {
        return new File(bluejLibDir, language + File.separator + base);
    }

    public static File getDefaultLanguageFile(String base) {
        return new File(bluejLibDir, DEFAULT_LANGUAGE + File.separator + base);
    }

    public static File getUserConfigFile(String base) {
        return new File(userPrefDir, base);
    }

    public static File getUserConfigDir() {
        return userPrefDir;
    }

    public static Color getItemColour(String itemname) {
        try {
            String rgbStr = command_props.getProperty(itemname, "255,0,255");
            String[] rgbVal = Utility.split(rgbStr, ",");
            if (rgbVal.length >= 3) {
                int r = Integer.parseInt(rgbVal[0].trim());
                int g = Integer.parseInt(rgbVal[1].trim());
                int b = Integer.parseInt(rgbVal[2].trim());
                return new Color(r, g, b);
            }
            Debug.reportError("Error reading colour [" + itemname + "]");
        }
        catch (Exception e) {
            Debug.reportError("Could not get colour for " + itemname);
        }
        return null;
    }

    public static Color getSelectionColour() {
        if (selectionColour == null) {
            selectionColour = Config.getItemColour("colour.selection");
        }
        return selectionColour;
    }

    public static void putLocation(String itemPrefix, Point p) {
        Config.putPropInteger(itemPrefix + ".x", p.x);
        Config.putPropInteger(itemPrefix + ".y", p.y);
    }

    public static Point getLocation(String itemPrefix) {
        try {
            int x = Config.getPropInteger(itemPrefix + ".x", 16);
            int y = Config.getPropInteger(itemPrefix + ".y", 16);
            if (x > Config.screenBounds.width - 16) {
                x = Config.screenBounds.width - 16;
            }
            if (y > Config.screenBounds.height - 16) {
                y = Config.screenBounds.height - 16;
            }
            return new Point(x, y);
        }
        catch (Exception e) {
            Debug.reportError("Could not get screen location for " + itemPrefix);
            return new Point(16, 16);
        }
    }

    public static void putPropInteger(String intname, int value) {
        user_props.setProperty(intname, Integer.toString(value));
    }

    public static void putPropString(String strname, String value) {
        user_props.setProperty(strname, value);
    }

    public static File getSystemInspectorDir() {
        return new File(bluejLibDir, "inspector");
    }

    public static File getBlueJLibDir() {
        return bluejLibDir;
    }

    public static String getBlueJIconPath() {
        return bluejLibDir.getPath() + "/images";
    }

    private static void setVMLocale() {
        String lang = Config.getPropString("vm.language", null);
        String region = Config.getPropString("vm.country", null);
        if ((lang == null || "".equals(lang)) && (region == null || "".equals(region))) {
            return;
        }
        if (lang == null || lang.equals("")) {
            lang = System.getProperty("user.language");
        }
        if (region == null || region.equals("")) {
            region = System.getProperty("user.country");
        }
        debugVMArgs.add("-Duser.language=" + lang);
        debugVMArgs.add("-Duser.country=" + region);
        Locale loc = new Locale(lang, region);
        Locale.setDefault(loc);
    }

    private static void setLookAndFeel(String laf) {
        try {
            if (laf.equals("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (laf.equals("crossplatform")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else if (Config.isWinOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (Config.isLinux() || Config.isSolaris()) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    private static void initDebugVMArgs() {
        String args = Config.getPropString("bluej.vm.args");
        if (args != null && !args.equals("bluej.vm.args")) {
            List splitArgs = Config.splitVMArgs(args);
            debugVMArgs.addAll(splitArgs);
        }
    }

    private static List splitVMArgs(String str) {
        boolean inQuote = false;
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(str, " ", true);
        while (t.hasMoreTokens()) {
            String arg = t.nextToken();
            if (arg.indexOf("\"") != -1) {
                inQuote = true;
                while (t.hasMoreTokens() && inQuote) {
                    String next = t.nextToken();
                    arg = arg + next;
                    if (next.indexOf("\"") == -1) continue;
                    inQuote = false;
                }
                strings.add(arg);
                continue;
            }
            if (arg.equals(" ")) continue;
            strings.add(arg);
        }
        return strings;
    }

    public static List getDebugVMArgs() {
        return debugVMArgs;
    }

    public static boolean isGreenfoot() {
        return Config.getPropString("greenfoot", "false").equalsIgnoreCase("true");
    }

    static {
        osname = System.getProperty("os.name", "");
        debugLogName = bluejDebugLogName;
        initialised = false;
        SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        focusBorder = new CompoundBorder(new LineBorder(Color.BLACK), new BevelBorder(1, new Color(195, 195, 195), new Color(240, 240, 240), new Color(195, 195, 195), new Color(124, 124, 124)));
        normalBorder = new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new BevelBorder(1, new Color(195, 195, 195), new Color(240, 240, 240), new Color(124, 124, 124), new Color(195, 195, 195)));
        debugVMArgs = new ArrayList();
    }
}

