/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.utility.JavaUtils;
import bluej.views.CallableView;
import bluej.views.Comment;
import bluej.views.FormattedPrintWriter;
import bluej.views.View;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class MethodView
extends CallableView
implements Comparable {
    protected Method method;
    protected View returnType;
    static /* synthetic */ Class class$0;

    public MethodView(View view, Method method) {
        super(view);
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.method.toString();
    }

    public int getModifiers() {
        return this.method.getModifiers();
    }

    public boolean hasParameters() {
        return this.method.getParameterTypes().length > 0;
    }

    public boolean isConstructor() {
        return false;
    }

    public String getSignature() {
        return JavaUtils.getJavaUtils().getSignature(this.method);
    }

    public String getCallSignature() {
        StringBuffer name = new StringBuffer();
        name.append(this.method.getName());
        name.append('(');
        Class<?>[] params = this.method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            name.append(params[i].getName());
            if (i != params.length - 1) {
                name.append(',');
            }
            ++i;
        }
        name.append(')');
        return name.toString();
    }

    public String getShortDesc() {
        return JavaUtils.getJavaUtils().getShortDesc(this.method, this.getParamNames());
    }

    public String getShortDesc(Map genericParams) {
        return JavaUtils.getJavaUtils().getShortDesc(this.method, this.getParamNames(), genericParams);
    }

    public String getLongDesc() {
        return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames());
    }

    public String getLongDesc(Map genericParams) {
        if (genericParams == null && this.isStatic()) {
            return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames());
        }
        return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames(), genericParams);
    }

    public Class[] getParameters() {
        return this.method.getParameterTypes();
    }

    public JavaType[] getParamTypes(boolean raw) {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        JavaType[] ptypes = jutils.getParamGenTypes(this.method, raw);
        return ptypes;
    }

    public GenTypeDeclTpar[] getTypeParams() {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        List tparams = jutils.getTypeParams(this.method);
        return tparams.toArray(new GenTypeDeclTpar[0]);
    }

    public String[] getParamTypeStrings() {
        return JavaUtils.getJavaUtils().getParameterTypes(this.method);
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean isVoid() {
        String resultName = this.getReturnType().getQualifiedName();
        return "void".equals(resultName);
    }

    public boolean isMain() {
        if (!this.isVoid()) {
            return false;
        }
        if ("main".equals(this.getName())) {
            Class[] c = this.getParameters();
            if (c.length != 1) {
                return false;
            }
            if (c[0].isArray()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(c[0].getComponentType()) && Modifier.isStatic(this.getModifiers()) && Modifier.isPublic(this.getModifiers())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isVarArgs() {
        return JavaUtils.getJavaUtils().isVarArgs(this.method);
    }

    public boolean isGeneric() {
        return !JavaUtils.getJavaUtils().getTypeParams(this.method).isEmpty();
    }

    public View getReturnType() {
        if (this.returnType == null) {
            this.returnType = View.getView(this.method.getReturnType());
        }
        return this.returnType;
    }

    public void print(FormattedPrintWriter out, Map typeParams, int indents) {
        Comment comment = this.getComment();
        if (comment != null) {
            comment.print(out, indents);
        }
        out.setItalic(false);
        out.setBold(true);
        int i = 0;
        while (i < indents) {
            out.indentLine();
            ++i;
        }
        out.println(this.getLongDesc(typeParams));
    }

    public int compareTo(Object other) {
        MethodView otherView = (MethodView)other;
        return this.method.getName().compareTo(otherView.method.getName());
    }
}

