/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.utility.Utility;
import bluej.views.FormattedPrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Comment {
    private String target;
    private String text;
    private String[] paramnames;

    public void load(Properties p, String prefix) {
        this.target = p.getProperty(String.valueOf(prefix) + ".target", "<no target>");
        this.text = p.getProperty(String.valueOf(prefix) + ".text");
        String paramnamestring = p.getProperty(String.valueOf(prefix) + ".params");
        if (paramnamestring != null) {
            StringTokenizer st = new StringTokenizer(paramnamestring, " ");
            this.paramnames = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.paramnames[i] = st.nextToken();
                ++i;
            }
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String getText() {
        return this.text;
    }

    public String getParamName(int i) {
        if (this.paramnames != null && i >= 0 && i < this.paramnames.length) {
            return this.paramnames[i];
        }
        return null;
    }

    public int getParamCount() {
        if (this.paramnames != null) {
            return this.paramnames.length;
        }
        return 0;
    }

    public String[] getParamNames() {
        if (this.paramnames == null) {
            return null;
        }
        return (String[])this.paramnames.clone();
    }

    public void print(FormattedPrintWriter out) {
        this.print(out, 0);
    }

    public void print(FormattedPrintWriter out, int indents) {
        out.setBold(false);
        out.setItalic(true);
        if (this.text != null) {
            String[] lines = Utility.splitLines(this.text);
            int i = 0;
            while (i < lines.length) {
                lines[i] = lines[i].trim();
                ++i;
            }
            int first = 0;
            while (first < lines.length && lines[first].length() == 0) {
                ++first;
            }
            int last = lines.length - 1;
            while (last >= 0 && lines[last].length() == 0) {
                --last;
            }
            int i2 = first;
            while (i2 <= last) {
                int j = 0;
                while (j < indents) {
                    out.indentLine();
                    ++j;
                }
                out.println("// " + lines[i2]);
                ++i2;
            }
        }
    }

    public String toString() {
        return this.text;
    }
}

