/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.Debug;
import com.apple.eio.FileManager;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Utility {
    private static Set occurredEvents = new HashSet();
    static /* synthetic */ Class class$0;

    public static void drawThickRect(Graphics g, int x, int y, int width, int height, int thickness) {
        int i = 0;
        while (i < thickness) {
            g.drawRect(x + i, y + i, width - 2 * i, height - 2 * i);
            ++i;
        }
    }

    public static void stripeRect(Graphics g, int x, int y, int width, int height, int separation, int thickness) {
        int offset = 0;
        while (offset < width + height) {
            int i = 0;
            while (i < thickness) {
                int y2;
                int x2;
                int y1;
                int x1;
                if (offset < height) {
                    x1 = x;
                    y1 = y + offset;
                } else {
                    x1 = x + offset - height;
                    y1 = y + height;
                }
                if (offset < width) {
                    x2 = x + offset;
                    y2 = y;
                } else {
                    x2 = x + width;
                    y2 = y + offset - width;
                }
                g.drawLine(x1, y1, x2, y2);
                ++i;
                ++offset;
            }
            offset += separation;
        }
    }

    public static void drawCentredText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        int xOffset = (width - fm.stringWidth(str)) / 2;
        if (xOffset < 0) {
            xOffset = 0;
        }
        int yOffset = (height + fm.getAscent()) / 2;
        g.drawString(str, x + xOffset, y + yOffset);
        g.setClip(oldClip);
    }

    public static void drawRightText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        g.drawString(str, x + width - fm.stringWidth(str), y + (height + fm.getAscent()) / 2);
        g.setClip(oldClip);
    }

    public static String[] split(String str, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        int len = str.length();
        int dlen = delimiter.length();
        int offset = str.lastIndexOf(delimiter);
        if (dlen < 1) {
            return null;
        }
        if (offset < 0) {
            String[] result = new String[]{str};
            return result;
        }
        if (len > offset + dlen) {
            str = String.valueOf(str) + delimiter;
            len += dlen;
        }
        do {
            offset = str.indexOf(delimiter, start);
            strings.add(str.substring(start, offset));
        } while ((start = offset + dlen) < len && offset != -1);
        String[] result = new String[strings.size()];
        strings.toArray(result);
        return result;
    }

    public static String[] splitLines(String str) {
        return str == null ? null : Utility.split(str, "\n");
    }

    public static String quoteString(String src) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            char c = src.charAt(i);
            if (c == '\n') {
                buf.append("\\n");
            } else if (c == '\r') {
                buf.append("\\r");
            } else if (c == '\t') {
                buf.append("\\g");
            } else if (c < ' ' || c > '\u0080') {
                String n = Integer.toHexString(c);
                n = String.valueOf("0000".substring(n.length())) + n;
                buf.append("\\u");
                buf.append(n);
            } else {
                if (c == '\\' || c == '\"' || c == '\'') {
                    buf.append('\\');
                }
                buf.append(src.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static void showClassDocumentation(String classname, String suffix) {
        int lastSlash;
        classname = classname.replace('.', '/');
        String docURL = Config.getPropString("bluej.url.javaStdLib");
        if (docURL.endsWith(".html") && (lastSlash = docURL.lastIndexOf(47)) != -1) {
            docURL = docURL.substring(0, lastSlash + 1);
        }
        Utility.openWebBrowser(String.valueOf(docURL) + classname + ".html" + suffix);
    }

    public static boolean openWebBrowser(String url) {
        if (Config.osname.startsWith("Windows")) {
            String cmd = Config.osname.startsWith("Windows 9") || Config.osname.equals("Windows Me") ? "command.com" : "cmd.exe";
            try {
                if (Config.osname.startsWith("Windows 98") || Config.osname.equals("Windows Me")) {
                    Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", String.valueOf('\"') + url + '\"'});
                }
                Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", "\"\"", String.valueOf('\"') + url + '\"'});
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        } else {
            try {
                return Utility.openWebBrowser(new URL(url));
            }
            catch (MalformedURLException mfue) {
                return Utility.openWebBrowser(new File(url));
            }
        }
        return true;
    }

    public static boolean openWebBrowser(URL url) {
        if (Config.isMacOS()) {
            try {
                FileManager.openURL((String)url.toString());
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        }
        if (Config.osname.startsWith("Windows")) {
            return Utility.openWebBrowser(url.toString());
        }
        String cmd = Utility.mergeStrings(Config.getPropString("browserCmd1"), url.toString());
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            int exitCode = p.waitFor();
            cmd = Config.getPropString("browserCmd2");
            if (exitCode != 0 && cmd != null && cmd.length() > 0) {
                cmd = Utility.mergeStrings(cmd, url.toString());
                p = Runtime.getRuntime().exec(cmd);
            }
        }
        catch (InterruptedException e) {
            Debug.reportError("cannot start web browser: " + cmd);
            Debug.reportError("caught exc " + e);
            return false;
        }
        catch (IOException e) {
            Debug.reportError("could not start web browser.  exc: " + e);
            return false;
        }
        return true;
    }

    public static boolean openWebBrowser(File file) {
        if (Config.osname.startsWith("Windows")) {
            return Utility.openWebBrowser(file.toString());
        }
        try {
            return Utility.openWebBrowser(file.toURI().toURL());
        }
        catch (MalformedURLException mfue) {
            return false;
        }
    }

    public static void bringToFront() {
        if (Config.isMacOS()) {
            try {
                Class<?> nsapp = null;
                try {
                    nsapp = Class.forName("com.apple.cocoa.application.NSApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (nsapp == null) {
                    nsapp = Class.forName("com.apple.cocoa.application.NSApplication", true, new URLClassLoader(new URL[]{new File("/System/Library/Java/").toURI().toURL()}));
                }
                Method sharedApp = nsapp.getMethod("sharedApplication", null);
                Object obj = sharedApp.invoke(null, null);
                Class[] param = new Class[]{Boolean.TYPE};
                Method act = nsapp.getMethod("activateIgnoringOtherApps", param);
                Object[] args = new Object[]{Boolean.TRUE};
                act.invoke(obj, args);
            }
            catch (Exception exc) {
                Debug.reportError("Bringing process to front failed (MacOS).");
            }
        }
    }

    public static String mergeStrings(String s1, String s2) {
        int pos = s1.indexOf(36);
        if (pos == -1) {
            return s1;
        }
        return String.valueOf(s1.substring(0, pos)) + s2 + s1.substring(pos + 1);
    }

    public static String mergeStrings(String s1, String[] s2) {
        int current = 0;
        while (current < s2.length) {
            s1 = Utility.mergeStrings(s1, s2[current]);
            ++current;
        }
        return s1;
    }

    public static String convertTabsToSpaces(String originalString, int tabSize) {
        if (originalString.indexOf(9) != -1) {
            StringBuffer buffer = new StringBuffer(originalString);
            int i = 0;
            while (i < buffer.length()) {
                if (buffer.charAt(i) == '\t') {
                    buffer.deleteCharAt(i);
                    int numberOfSpaces = tabSize - i % tabSize;
                    int j = 0;
                    while (j < numberOfSpaces) {
                        buffer.insert(i, ' ');
                        ++j;
                    }
                }
                ++i;
            }
            return buffer.toString();
        }
        return originalString;
    }

    public static boolean firstTimeThisRun(String context) {
        if (occurredEvents.contains(context)) {
            return false;
        }
        occurredEvents.add(context);
        return true;
    }

    public static boolean firstTimeEver(String context) {
        String eventIndicator = Config.getPropString(context, "false");
        if (eventIndicator.equals("true")) {
            return false;
        }
        Config.putPropString(context, "true");
        return true;
    }
}

