/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class SortedProperties
extends Properties {
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private String saveConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x++);
            switch (aChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    break;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    break;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    break;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    break;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    break;
                }
                default: {
                    if (aChar < '\u0014' || aChar > '\u007f') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(SortedProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 0 & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            awriter.write("#" + header);
            awriter.newLine();
        }
        TreeMap<Object, Object> tm = new TreeMap<Object, Object>(this);
        Iterator<Map.Entry<Object, Object>> it = tm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> mapEntry = it.next();
            String key = this.saveConvert((String)mapEntry.getKey());
            String val = this.saveConvert((String)mapEntry.getValue());
            awriter.write(String.valueOf(key) + "=" + val);
            awriter.newLine();
        }
        awriter.flush();
    }
}

