/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiLineLabel
extends JPanel {
    protected int fontAttributes = 0;
    protected float alignment;
    protected Color col = null;
    protected int spacing = 0;

    public MultiLineLabel(String text, float alignment) {
        this.alignment = alignment;
        this.setLayout(new BoxLayout(this, 1));
        if (text != null) {
            this.setText(text);
        }
    }

    public MultiLineLabel(String text) {
        this(text, 0.0f);
    }

    public MultiLineLabel(float alignment) {
        this(null, alignment);
    }

    public MultiLineLabel(float alignment, int spacing) {
        this(null, alignment);
        this.spacing = spacing;
    }

    public MultiLineLabel() {
        this(null, 0.0f);
    }

    public void setText(String text) {
        this.removeAll();
        this.addText(text);
    }

    public void addText(String text) {
        this.addText(text, 12);
    }

    public void addText(String text, int size) {
        if (this.spacing > 0) {
            this.add(Box.createVerticalStrut(this.spacing));
        }
        String[] strs = Utility.splitLines(text);
        Font font = new Font("SansSerif", this.fontAttributes, size);
        int i = 0;
        while (strs != null && i < strs.length) {
            JLabel l = new JLabel(strs[i]);
            l.setFont(font);
            l.setAlignmentX(this.alignment);
            if (this.col != null) {
                l.setForeground(this.col);
            }
            this.add(l);
            ++i;
        }
    }

    public void addText(String text, boolean bold, boolean italic) {
        int oldAttributes = this.fontAttributes;
        this.setBold(bold);
        this.setItalic(italic);
        this.addText(text);
        this.fontAttributes = oldAttributes;
    }

    public void setForeground(Color col) {
        this.col = col;
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            component.setForeground(col);
            ++i;
        }
    }

    public void setItalic(boolean italic) {
        this.fontAttributes = italic ? (this.fontAttributes |= 2) : (this.fontAttributes &= 0xFFFFFFFD);
    }

    public void setBold(boolean bold) {
        this.fontAttributes = bold ? (this.fontAttributes |= 1) : (this.fontAttributes &= 0xFFFFFFFE);
    }
}

