/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.utility.BlueJFileChooser;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.PackageChooser;
import bluej.utility.PackageChooserStrict;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileUtility {
    private static final String sourceSuffix = ".java";
    private static JFileChooser pkgChooser = null;
    private static JFileChooser pkgChooserNonBlueJ = null;
    private static JFileChooser fileChooser = null;
    private static JFileChooser multiFileChooser = null;
    public static final int NO_ERROR = 0;
    public static final int DEST_EXISTS = 1;
    public static final int SRC_NOT_DIRECTORY = 2;
    public static final int COPY_ERROR = 3;

    public static File getPackageName(Component parent) {
        JFileChooser chooser = FileUtility.getPackageChooser();
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        PrefMgr.setProjectDirectory(chooser.getSelectedFile().getParentFile().getPath());
        return chooser.getSelectedFile();
    }

    public static File getNonBlueJDirectoryName(Component parent) {
        JFileChooser chooser = FileUtility.getNonBlueJPackageChooser();
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public static File[] getMultipleFiles(Component parent, String title, String buttonLabel, FileFilter filter) {
        JFileChooser newMultiChooser = FileUtility.getMultipleFileChooser();
        newMultiChooser.setDialogTitle(title);
        if (filter == null) {
            filter = newMultiChooser.getAcceptAllFileFilter();
        }
        newMultiChooser.setFileFilter(filter);
        int result = newMultiChooser.showDialog(parent, buttonLabel);
        if (result == 0) {
            return newMultiChooser.getSelectedFiles();
        }
        if (result == 1) {
            return null;
        }
        DialogManager.showError(parent, "error-no-name");
        return null;
    }

    public static String getFileName(Component parent, String title, String buttonLabel, boolean directoryOnly, FileFilter filter, boolean rememberDir) {
        JFileChooser newChooser = FileUtility.getFileChooser();
        newChooser.setDialogTitle(title);
        if (directoryOnly) {
            newChooser.setFileSelectionMode(1);
        } else {
            newChooser.setFileSelectionMode(2);
        }
        if (filter == null) {
            filter = newChooser.getAcceptAllFileFilter();
        }
        newChooser.setFileFilter(filter);
        int result = newChooser.showDialog(parent, buttonLabel);
        if (result == 0) {
            if (rememberDir) {
                PrefMgr.setProjectDirectory(newChooser.getSelectedFile().getParentFile().getPath());
            }
            return newChooser.getSelectedFile().getPath();
        }
        if (result == 1) {
            return null;
        }
        DialogManager.showError(parent, "error-no-name");
        return null;
    }

    public static FileFilter getJavaSourceFilter() {
        return new JavaSourceFilter();
    }

    private static JFileChooser getPackageChooser() {
        if (pkgChooser == null) {
            pkgChooser = new PackageChooserStrict(new File(PrefMgr.getProjectDirectory()));
        }
        pkgChooser.setDialogTitle(Config.getString("pkgmgr.openPkg.title"));
        pkgChooser.setApproveButtonText(Config.getString("pkgmgr.openPkg.buttonLabel"));
        return pkgChooser;
    }

    private static JFileChooser getNonBlueJPackageChooser() {
        if (pkgChooserNonBlueJ == null) {
            pkgChooserNonBlueJ = new PackageChooser(new File(PrefMgr.getProjectDirectory()), true);
        }
        pkgChooserNonBlueJ.setDialogTitle(Config.getString("pkgmgr.openNonBlueJPkg.title"));
        pkgChooserNonBlueJ.setApproveButtonText(Config.getString("pkgmgr.openNonBlueJPkg.buttonLabel"));
        return pkgChooserNonBlueJ;
    }

    private static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new BlueJFileChooser(PrefMgr.getProjectDirectory());
        }
        return fileChooser;
    }

    private static JFileChooser getMultipleFileChooser() {
        if (multiFileChooser == null) {
            multiFileChooser = new BlueJFileChooser(PrefMgr.getProjectDirectory());
            multiFileChooser.setMultiSelectionEnabled(true);
        }
        return multiFileChooser;
    }

    public static boolean copyFile(String source, String dest) {
        File srcFile = new File(source);
        File destFile = new File(dest);
        return FileUtility.copyFile(srcFile, destFile);
    }

    public static boolean copyFile(File srcFile, File destFile) {
        if (srcFile.equals(destFile)) {
            return true;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(srcFile));
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            FileUtility.copyStream(in, out);
            return true;
        }
        catch (IOException e) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        {
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
    }

    public static int copyDirectory(String source, String dest) {
        File srcFile = new File(source);
        File destFile = new File(dest);
        if (!srcFile.isDirectory()) {
            return 2;
        }
        if (destFile.exists()) {
            return 1;
        }
        if (!destFile.mkdir()) {
            return 3;
        }
        String[] dir = srcFile.list();
        int i = 0;
        while (i < dir.length) {
            File file2;
            String srcName = String.valueOf(source) + File.separator + dir[i];
            File file = new File(srcName);
            if (file.isDirectory() ? FileUtility.copyDirectory(srcName, String.valueOf(dest) + File.separator + dir[i]) != 0 : !FileUtility.copyFile(file, file2 = new File(dest, dir[i]))) {
                return 3;
            }
            ++i;
        }
        return 0;
    }

    public static File[] recursiveCopyFile(File srcDir, File destDir) {
        if (srcDir == null || destDir == null) {
            throw new IllegalArgumentException();
        }
        File parentDir = destDir.getParentFile();
        while (parentDir != null) {
            if (parentDir.equals(srcDir)) {
                return new File[]{srcDir};
            }
            parentDir = parentDir.getParentFile();
        }
        return FileUtility.actualRecursiveCopyFile(srcDir, destDir);
    }

    private static File[] actualRecursiveCopyFile(File srcDir, File destDir) {
        ArrayList<File> failed = new ArrayList<File>();
        if (srcDir.getAbsolutePath().equals(destDir.getAbsolutePath())) {
            return null;
        }
        if (!srcDir.isDirectory() || !destDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] files = srcDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File newFile;
            if (files[i].isDirectory()) {
                File newDir = new File(destDir, files[i].getName());
                newDir.mkdir();
                if (newDir.isDirectory()) {
                    FileUtility.actualRecursiveCopyFile(files[i], newDir);
                } else {
                    failed.add(files[i]);
                }
            } else if (files[i].isFile() && ((newFile = new File(destDir, files[i].getName())).exists() || !FileUtility.copyFile(files[i], newFile))) {
                failed.add(files[i]);
            }
            ++i;
        }
        if (failed.size() > 0) {
            return failed.toArray(new File[0]);
        }
        return null;
    }

    public static File findFile(File startDir, String suffix) {
        File[] files = startDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && files[i].getName().endsWith(suffix)) {
                return files[i];
            }
            ++i;
        }
        i = 0;
        while (i < files.length) {
            File found;
            if (files[i].isDirectory() && (found = FileUtility.findFile(files[i], suffix)) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public static boolean containsFile(File dir, String suffix) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && files[i].getName().endsWith(suffix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void deleteDir(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null || Array.getLength(fileList) == 0) {
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        } else {
            int i = 0;
            while (i < Array.getLength(fileList)) {
                FileUtility.deleteDir(fileList[i]);
                ++i;
            }
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        }
    }

    private static class JavaSourceFilter
    extends FileFilter {
        JavaSourceFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(FileUtility.sourceSuffix);
        }

        public String getDescription() {
            return "Java Source";
        }
    }
}

