/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.parser.symtab.Selection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;

public class FileEditor
extends PlainDocument {
    private File fileToEdit;

    public FileEditor(File fileToEdit) throws IOException {
        int c;
        this.fileToEdit = fileToEdit;
        BufferedReader in = null;
        StringWriter out = null;
        in = new BufferedReader(new FileReader(fileToEdit));
        out = new StringWriter();
        while ((c = ((Reader)in).read()) != -1) {
            ((Writer)out).write(c);
        }
        try {
            try {
                this.insertString(0, ((Object)out).toString(), null);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                ((Reader)in).close();
            }
        }
    }

    public void replaceSelection(Selection s, String text) {
        try {
            int lineNo = s.getLine() - 1;
            int endLineNo = s.getEndLine() - 1;
            Element root = this.getDefaultRootElement();
            if (endLineNo < root.getElementCount()) {
                Element line = root.getElement(lineNo);
                Element endLine = root.getElement(endLineNo);
                int pos = line.getStartOffset() + s.getColumn() - 1;
                int len = endLine.getStartOffset() + s.getEndColumn() - pos - 1;
                this.remove(pos, len);
                this.insertString(line.getStartOffset() + s.getColumn() - 1, text, null);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void save() throws IOException {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.fileToEdit));
            int c = 0;
            while (c < this.getLength()) {
                out.write(this.getText(c, 1));
                ++c;
            }
            ((Writer)out).close();
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }
}

