/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.BlueJFileReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DialogManager {
    private static final String DLG_FILE_NAME = "dialogues";

    public static void showMessage(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, message, Config.getString("dialogmgr.message"), 1);
        }
    }

    public static void showMessageWithText(Component parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, String.valueOf(message) + "\n" + text);
        }
    }

    public static void showText(Component parent, String text) {
        JOptionPane.showMessageDialog(parent, text);
    }

    public static void showError(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, message, Config.getString("dialogmgr.error"), 0);
        }
    }

    public static void showErrorWithText(Component parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, String.valueOf(message) + "\n" + text, "Error", 0);
        }
    }

    public static int askQuestion(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            message = message.substring(0, button1Index);
            Object[] options = "null".equals(button3) ? new Object[]{button1, button2} : new Object[]{button1, button2, button3};
            return JOptionPane.showOptionDialog(parent, message, Config.getString("dialogmgr.question"), -1, 2, null, options, options[0]);
        }
        return 0;
    }

    public static String askString(Component parent, String msgID) {
        String response = "";
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String defaultText = message.substring(defaultTextIndex + 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            if ("null".equals(defaultText)) {
                defaultText = null;
            }
            response = (String)JOptionPane.showInputDialog(parent, message, title, -1, null, null, defaultText);
        }
        return response;
    }

    public static String askString(Component parent, String msgID, String defaultText) {
        String response = "";
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            response = (String)JOptionPane.showInputDialog(parent, message, title, -1, null, null, defaultText);
        }
        return response;
    }

    public static String getMessage(String msgID) {
        File filename = Config.getLanguageFile(DLG_FILE_NAME);
        String message = BlueJFileReader.readHelpText(filename, msgID, true);
        if (message == null && !Config.language.equals("english")) {
            filename = Config.getDefaultLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            JOptionPane.showMessageDialog(null, "BlueJ configuration problem:\ntext not found for message ID\n" + msgID);
        }
        return message;
    }

    public static void NYI(Component frame) {
        DialogManager.showMessage(frame, "not-yet-implemented");
    }

    public static void centreDialog(JDialog dialog) {
        DialogManager.centreWindow(dialog, (Window)dialog.getParent());
    }

    public static void centreWindow(Window child, Window parent) {
        Point topleft = parent.getLocationOnScreen();
        Dimension parentSize = parent.getSize();
        Dimension childSize = child.getSize();
        child.setLocation(topleft.x + (parentSize.width - childSize.width) / 2, topleft.y + (parentSize.height - childSize.height) / 2);
    }

    public static void tileWindow(Window child, Window parent) {
        if (parent.isShowing()) {
            Point p_topleft = parent.getLocationOnScreen();
            child.setLocation(p_topleft.x + 20, p_topleft.y + 20);
        }
    }
}

