/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.classmgr.ClassMgrPrefPanel;
import bluej.editor.moe.EditorPrefPanel;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionsManager;
import bluej.prefmgr.MiscPrefPanel;
import bluej.prefmgr.PrefPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PrefMgrDialog
extends JFrame {
    private static PrefMgrDialog dialog = null;
    private ArrayList listeners = new ArrayList();
    private ArrayList tabs = new ArrayList();
    private ArrayList titles = new ArrayList();
    private JTabbedPane tabbedPane = null;
    private ClassMgrPrefPanel userConfigLibPanel;

    public static void showDialog() {
        PrefMgrDialog.prepareDialog();
        dialog.setVisible(true);
    }

    public static void showDialog(int paneNumber) {
        PrefMgrDialog.prepareDialog();
        dialog.selectTab(paneNumber);
        dialog.setVisible(true);
    }

    private static void prepareDialog() {
        if (dialog == null) {
            dialog = new PrefMgrDialog();
        }
        dialog.startEditing();
    }

    public static final PrefMgrDialog getInstance() {
        if (dialog == null) {
            dialog = new PrefMgrDialog();
        }
        return dialog;
    }

    private PrefMgrDialog() {
        this.createPrefPanes();
        this.makeDialog();
    }

    private void createPrefPanes() {
        EditorPrefPanel panel = new EditorPrefPanel();
        this.add((JPanel)panel, Config.getString("prefmgr.edit.prefpaneltitle"), (PrefPanelListener)panel);
        MiscPrefPanel panel2 = new MiscPrefPanel();
        this.add(panel2, Config.getString("prefmgr.misc.prefpaneltitle"), panel2);
        this.userConfigLibPanel = new ClassMgrPrefPanel();
        this.add(this.userConfigLibPanel, Config.getString("classmgr.prefpaneltitle"), this.userConfigLibPanel);
        ExtensionPrefManager mgr = ExtensionsManager.getInstance().getPrefManager();
        this.add(mgr.getPanel(), Config.getString("extmgr.extensions"), mgr);
    }

    public ClassMgrPrefPanel getUserConfigLibPanel() {
        return this.userConfigLibPanel;
    }

    public void add(JPanel panel, String title, PrefPanelListener listener) {
        this.tabs.add(panel);
        this.listeners.add(listener);
        this.titles.add(title);
    }

    private void startEditing() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PrefPanelListener ppl = (PrefPanelListener)i.next();
            ppl.beginEditing();
        }
    }

    private void selectTab(int tabNumber) {
        this.tabbedPane.setSelectedIndex(tabNumber);
    }

    private void makeDialog() {
        this.setIconImage(BlueJTheme.getIconImage());
        this.setTitle(Config.getString("prefmgr.title"));
        this.tabbedPane = new JTabbedPane();
        ListIterator i = this.tabs.listIterator();
        while (i.hasNext()) {
            int index = i.nextIndex();
            JPanel p = (JPanel)i.next();
            this.tabbedPane.addTab((String)this.titles.get(index), null, p);
        }
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BlueJTheme.dialogBorder);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Iterator i = PrefMgrDialog.this.listeners.iterator();
                while (i.hasNext()) {
                    PrefPanelListener ppl = (PrefPanelListener)i.next();
                    ppl.commitEditing();
                }
                PrefMgrDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Iterator i = PrefMgrDialog.this.listeners.iterator();
                while (i.hasNext()) {
                    PrefPanelListener ppl = (PrefPanelListener)i.next();
                    ppl.revertEditing();
                }
                PrefMgrDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPanel.add((Component)this.tabbedPane, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.preferences", PrefMgrDialog.this.getLocation());
            }
        });
        this.setLocation(Config.getLocation("bluej.preferences"));
        this.pack();
    }
}

