/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.RunAppletDialog;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public class AppletClassRole
extends ClassRole {
    public static final String APPLET_ROLE_NAME = "AppletTarget";
    private RunAppletDialog dialog;
    private static final Color appletbg = Config.getItemColour("colour.class.bg.applet");
    static final String runAppletStr = Config.getString("pkgmgr.classmenu.runApplet");
    static final String htmlComment = Config.getString("pkgmgr.runApplet.htmlComment");
    static final String APPLETVIEWER_COMMAND = Config.getJDKExecutablePath("appletViewer.command", "appletviewer");
    public static final String HTML_EXTENSION = ".html";
    private static final String URL_PREFIX = "file://localhost/";
    private static final int DEFAULT_APPLET_WIDTH = 500;
    private static final int DEFAULT_APPLET_HEIGHT = 500;
    private String[] appletParams;
    private int appletHeight = 500;
    private int appletWidth = 500;

    public String getRoleName() {
        return APPLET_ROLE_NAME;
    }

    public String getStereotypeLabel() {
        return "applet";
    }

    public Color getBackgroundColour() {
        return appletbg;
    }

    public void save(Properties props, int modifiers, String prefix) {
        super.save(props, modifiers, prefix);
        if (this.dialog != null) {
            this.appletParams = this.dialog.getAppletParameters();
            props.put(String.valueOf(prefix) + ".numberAppletParameters", String.valueOf(this.appletParams.length));
            int i = 0;
            while (i < this.appletParams.length) {
                props.put(String.valueOf(prefix) + ".appletParameter" + (i + 1), this.appletParams[i]);
                ++i;
            }
        } else {
            props.put(String.valueOf(prefix) + ".numberAppletParameters", String.valueOf(0));
        }
        props.put(String.valueOf(prefix) + ".appletHeight", String.valueOf(this.appletHeight));
        props.put(String.valueOf(prefix) + ".appletWidth", String.valueOf(this.appletWidth));
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        String value = props.getProperty(String.valueOf(prefix) + ".numberAppletParameters");
        int numberParameters = 0;
        if (value != null) {
            numberParameters = Integer.parseInt(value);
        }
        if (numberParameters > 0) {
            this.appletParams = new String[numberParameters];
            int i = 0;
            while (i < numberParameters) {
                this.appletParams[i] = props.getProperty(String.valueOf(prefix) + ".appletParameter" + (i + 1));
                ++i;
            }
        }
        if ((value = props.getProperty(String.valueOf(prefix) + ".appletHeight")) != null) {
            this.appletHeight = Integer.parseInt(value);
        }
        if ((value = props.getProperty(String.valueOf(prefix) + ".appletWidth")) != null) {
            this.appletWidth = Integer.parseInt(value);
        }
    }

    public boolean createRoleMenu(JPopupMenu menu, ClassTarget ct, Class cl, int state) {
        this.addMenuItem(menu, new AppletAction(ct.getPackage().getEditor(), ct), state == 0);
        menu.addSeparator();
        return true;
    }

    public void run(PkgMgrFrame parent, ClassTarget ct, String param) {
        String name = ct.getQualifiedName();
        Package pkg = ct.getPackage();
        if (this.dialog == null) {
            this.dialog = new RunAppletDialog(parent, name);
            if (this.appletParams != null) {
                this.dialog.setAppletParameters(this.appletParams);
            }
            this.dialog.setAppletHeight(this.appletHeight);
            this.dialog.setAppletWidth(this.appletWidth);
        }
        if (this.dialog.display()) {
            File[] libs = parent.getProject().getClassLoader().getClassPathAsFiles();
            int execOption = this.dialog.getAppletExecutionOption();
            if (execOption == 2) {
                File generatedFile = this.chooseWebPage(parent);
                if (generatedFile != null) {
                    this.createWebPage(generatedFile, name, pkg.getPath().getPath(), libs);
                }
            } else {
                String fname = String.valueOf(name) + HTML_EXTENSION;
                File destFile = new File(pkg.getProject().getProjectDir(), String.valueOf(name) + HTML_EXTENSION);
                this.createWebPage(destFile, name, ".", libs);
                if (execOption == 0) {
                    try {
                        String[] execCommand = new String[]{APPLETVIEWER_COMMAND, fname};
                        PkgMgrFrame.displayMessage(Config.getString("pkgmgr.appletInViewer"));
                        Runtime.getRuntime().exec(execCommand, null, pkg.getProject().getProjectDir());
                    }
                    catch (Exception e) {
                        pkg.showError("appletviewer-error");
                        Debug.reportError("Exception thrown in execution of appletviewer");
                        e.printStackTrace();
                    }
                } else {
                    PkgMgrFrame.displayMessage(Config.getString("pkgmgr.appletInBrowser"));
                    Utility.openWebBrowser(destFile);
                }
            }
        }
    }

    private File chooseWebPage(JFrame frame) {
        String fullFileName = FileUtility.getFileName(frame, Config.getString("pkgmgr.chooseWebPage.title"), Config.getString("pkgmgr.chooseWebPage.buttonLabel"), false, null, false);
        if (fullFileName == null) {
            DialogManager.showError(frame, "error-no-name");
        }
        if (!fullFileName.endsWith(HTML_EXTENSION)) {
            fullFileName = String.valueOf(fullFileName) + HTML_EXTENSION;
        }
        return new File(fullFileName);
    }

    private void updateAppletProperties() {
        try {
            this.appletHeight = Integer.parseInt(this.dialog.getAppletHeight());
            this.appletWidth = Integer.parseInt(this.dialog.getAppletWidth());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.appletParams = this.dialog.getAppletParameters();
    }

    private void createWebPage(File outputFile, String appletName, String appletCodeBase, File[] libs) {
        this.updateAppletProperties();
        this.generateHTMLSkeleton(outputFile, appletName, appletCodeBase, libs, this.dialog.getAppletWidth(), this.dialog.getAppletHeight(), this.appletParams);
    }

    private void generateHTMLSkeleton(File outputFile, String appletName, String appletCodeBase, File[] libs, String width, String height, String[] parameters) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("TITLE", appletName);
        translations.put("COMMENT", htmlComment);
        translations.put("CLASSFILE", String.valueOf(appletName) + ".class");
        translations.put("CODEBASE", appletCodeBase);
        translations.put("APPLETWIDTH", width);
        translations.put("APPLETHEIGHT", height);
        String archives = "";
        try {
            int i = 0;
            while (i < libs.length) {
                archives = archives.length() == 0 ? libs[i].toURI().toURL().toString() : String.valueOf(archives) + "," + libs[i].toURL();
                ++i;
            }
        }
        catch (MalformedURLException i) {
            // empty catch block
        }
        translations.put("ARCHIVE", archives);
        StringBuffer allParameters = new StringBuffer();
        int index = 0;
        while (index < parameters.length) {
            allParameters.append("\t" + parameters[index] + "\n");
            ++index;
        }
        translations.put("PARAMETERS", allParameters.toString());
        File tmplFile = Config.getTemplateFile("html");
        try {
            BlueJFileReader.translateFile(tmplFile, outputFile, translations);
        }
        catch (IOException e) {
            Debug.reportError("Exception during file translation from " + tmplFile + " to " + outputFile);
            e.printStackTrace();
        }
    }

    public void prepareFilesForRemoval(ClassTarget ct, String sourceFile, String classFile, String contextFile) {
        super.prepareFilesForRemoval(ct, sourceFile, classFile, contextFile);
        File htmlFile = new File(ct.getPackage().getProject().getProjectDir(), String.valueOf(ct.getQualifiedName()) + HTML_EXTENSION);
        if (htmlFile.exists()) {
            htmlFile.delete();
        }
    }

    private class AppletAction
    extends AbstractAction {
        private Target t;
        private PackageEditor ped;

        public AppletAction(PackageEditor ped, Target t) {
            super(runAppletStr);
            this.ped = ped;
            this.t = t;
        }

        public void actionPerformed(ActionEvent e) {
            this.ped.raiseRunTargetEvent(this.t, null);
        }
    }
}

