/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.graph.Moveable;
import bluej.pkgmgr.LayoutComparer;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.Target;
import bluej.utility.MultiIterator;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public abstract class DependentTarget
extends Target {
    private List inUses = new ArrayList();
    private List outUses = new ArrayList();
    private List parents = new ArrayList();
    private List children = new ArrayList();
    protected DependentTarget assoc = null;

    public DependentTarget(Package pkg, String identifierName) {
        super(pkg, identifierName);
    }

    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.recalcDependentPositions();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.recalcDependentPositions();
    }

    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getAssociation() != null) {
            String assocName = this.getAssociation().getIdentifierName();
            props.put(String.valueOf(prefix) + ".association", assocName);
        }
    }

    public void setAssociation(DependentTarget t) {
        this.assoc = t;
        if (this.assoc instanceof Moveable) {
            ((Moveable)((Object)this.assoc)).setIsMoveable(false);
        }
    }

    public DependentTarget getAssociation() {
        return this.assoc;
    }

    public void addDependencyOut(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.outUses.add(d);
            if (recalc) {
                this.recalcOutUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.parents.add(d);
        }
        if (recalc) {
            this.setState(1);
        }
    }

    public void addDependencyIn(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.inUses.add(d);
            if (recalc) {
                this.recalcInUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.children.add(d);
        }
    }

    public void removeDependencyOut(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.outUses.remove(d);
            if (recalc) {
                this.recalcOutUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.parents.remove(d);
        }
        if (recalc) {
            this.setState(1);
        }
    }

    public void removeDependencyIn(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.inUses.remove(d);
            if (recalc) {
                this.recalcInUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.children.remove(d);
        }
    }

    public Iterator dependencies() {
        ArrayList v = new ArrayList(2);
        v.add(this.parents.iterator());
        v.add(this.outUses.iterator());
        return new MultiIterator(v);
    }

    public Iterator dependents() {
        ArrayList v = new ArrayList(2);
        v.add(this.children.iterator());
        v.add(this.inUses.iterator());
        return new MultiIterator(v);
    }

    public List dependentsAsList() {
        LinkedList list = new LinkedList();
        list.addAll(this.inUses);
        list.addAll(this.outUses);
        list.addAll(this.children);
        list.addAll(this.parents);
        return list;
    }

    public Iterator usesDependencies() {
        return Collections.unmodifiableList(this.outUses).iterator();
    }

    protected void removeAllOutDependencies() {
        if (!this.outUses.isEmpty()) {
            Dependency[] outUsesArray = new Dependency[this.outUses.size()];
            this.outUses.toArray(outUsesArray);
            int i = 0;
            while (i < outUsesArray.length) {
                this.getPackage().removeDependency(outUsesArray[i], false);
                ++i;
            }
        }
        this.removeInheritDependencies();
    }

    protected void removeInheritDependencies() {
        if (!this.parents.isEmpty()) {
            Dependency[] parentsArray = new Dependency[this.parents.size()];
            this.parents.toArray(parentsArray);
            int i = 0;
            while (i < parentsArray.length) {
                this.getPackage().removeDependency(parentsArray[i], false);
                ++i;
            }
        }
    }

    protected void removeAllInDependencies() {
        int i;
        if (!this.inUses.isEmpty()) {
            Dependency[] inUsesArray = new Dependency[this.inUses.size()];
            this.inUses.toArray(inUsesArray);
            i = 0;
            while (i < inUsesArray.length) {
                this.getPackage().removeDependency(inUsesArray[i], false);
                ++i;
            }
        }
        if (!this.children.isEmpty()) {
            Dependency[] childrenArray = new Dependency[this.children.size()];
            this.children.toArray(childrenArray);
            i = 0;
            while (i < childrenArray.length) {
                this.getPackage().removeDependency(childrenArray[i], false);
                ++i;
            }
        }
    }

    public void recalcOutUses() {
        Collections.sort(this.outUses, new LayoutComparer(this, false));
        int cy = this.getY() + this.getHeight() / 2;
        int n_top = 0;
        int n_bottom = 0;
        int i = this.outUses.size() - 1;
        while (i >= 0) {
            DependentTarget to = ((Dependency)this.outUses.get(i)).getTo();
            int to_cy = to.getY() + to.getHeight() / 2;
            if (to_cy < cy) {
                ++n_top;
            } else {
                ++n_bottom;
            }
            --i;
        }
        int top_left = this.getX() + (this.getWidth() - (n_top - 1) * 5) / 2;
        int bottom_left = this.getX() + (this.getWidth() - (n_bottom - 1) * 5) / 2;
        int i2 = 0;
        while (i2 < n_top + n_bottom) {
            UsesDependency d = (UsesDependency)this.outUses.get(i2);
            int to_cy = d.getTo().getY() + d.getTo().getHeight() / 2;
            if (to_cy < cy) {
                d.setSourceCoords(top_left, this.getY() - 4, true);
                top_left += 5;
            } else {
                d.setSourceCoords(bottom_left, this.getY() + this.getHeight() + 4, false);
                bottom_left += 5;
            }
            ++i2;
        }
    }

    public void recalcInUses() {
        Collections.sort(this.inUses, new LayoutComparer(this, true));
        int cx = this.getX() + this.getWidth() / 2;
        int n_left = 0;
        int n_right = 0;
        int i = this.inUses.size() - 1;
        while (i >= 0) {
            DependentTarget from = ((Dependency)this.inUses.get(i)).getFrom();
            int from_cx = from.getX() + from.getWidth() / 2;
            if (from_cx < cx) {
                ++n_left;
            } else {
                ++n_right;
            }
            --i;
        }
        int left_top = this.getY() + (this.getHeight() - (n_left - 1) * 10) / 2;
        int right_top = this.getY() + (this.getHeight() - (n_right - 1) * 10) / 2;
        int i2 = 0;
        while (i2 < n_left + n_right) {
            UsesDependency d = (UsesDependency)this.inUses.get(i2);
            int from_cx = d.getFrom().getX() + d.getFrom().getWidth() / 2;
            if (from_cx < cx) {
                d.setDestCoords(this.getX() - 4, left_top, true);
                left_top += 10;
            } else {
                d.setDestCoords(this.getX() + this.getWidth() + 4, right_top, false);
                right_top += 10;
            }
            ++i2;
        }
    }

    protected void unflagAllOutDependencies() {
        int i = 0;
        while (i < this.outUses.size()) {
            ((UsesDependency)this.outUses.get(i)).setFlag(false);
            ++i;
        }
    }

    public Point getAttachment(double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double tan = sin / cos;
        double m = (double)this.getHeight() / (double)this.getWidth();
        double radius = Math.abs(tan) < m ? 0.5 * (double)this.getWidth() / Math.abs(cos) : 0.5 * (double)this.getHeight() / Math.abs(sin);
        Point p = new Point(this.getX() + this.getWidth() / 2 + (int)(radius * cos), this.getY() + this.getHeight() / 2 - (int)(radius * sin));
        if (-m < tan && tan < m && cos > 0.0) {
            p.x += 4;
        }
        if (Math.abs(tan) > m && sin < 0.0 && p.x > this.getX() + 4) {
            p.y += 4;
        }
        return p;
    }

    public void recalcDependentPositions() {
        Dependency d;
        this.recalcInUses();
        this.recalcOutUses();
        Iterator it = this.inUses.iterator();
        while (it.hasNext()) {
            d = (Dependency)it.next();
            d.getFrom().recalcOutUses();
        }
        it = this.outUses.iterator();
        while (it.hasNext()) {
            d = (Dependency)it.next();
            d.getTo().recalcInUses();
        }
        this.updateAssociatePosition();
    }

    protected void updateAssociatePosition() {
        DependentTarget t = this.getAssociation();
        if (t != null) {
            t.setPos(this.getX() + 30, this.getY() - 30);
            t.recalcDependentPositions();
        }
    }

    public String toString() {
        return this.getDisplayName();
    }
}

