/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.graph.RubberBand;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.graphPainter.DependencyPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class UsesDependencyPainter
implements DependencyPainter {
    protected static final float strokeWidthDefault = 1.0f;
    protected static final float strokeWidthSelected = 2.0f;
    static final int ARROW_SIZE = 10;
    static final double ARROW_ANGLE = 0.5235987755982988;
    private static final Color normalColour = Config.getItemColour("colour.arrow.uses");
    private static final float[] dash1 = new float[]{5.0f, 2.0f};
    private static final BasicStroke dashedUnselected = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    private static final BasicStroke dashedSelected = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
    private static final BasicStroke normalSelected = new BasicStroke(2.0f);
    private static final BasicStroke normalUnselected = new BasicStroke(1.0f);

    public void paint(Graphics2D g, Dependency dependency, boolean hasFocus) {
        BasicStroke normalStroke;
        BasicStroke dashedStroke;
        boolean isSelected;
        if (!(dependency instanceof UsesDependency)) {
            throw new IllegalArgumentException("Not a UsesDependency");
        }
        Stroke oldStroke = g.getStroke();
        UsesDependency d = (UsesDependency)dependency;
        boolean bl = isSelected = d.isSelected() && hasFocus;
        if (isSelected) {
            dashedStroke = dashedSelected;
            normalStroke = normalSelected;
        } else {
            dashedStroke = dashedUnselected;
            normalStroke = normalUnselected;
        }
        g.setStroke(normalStroke);
        int src_x = d.getSourceX();
        int src_y = d.getSourceY();
        int dst_x = d.getDestX();
        int dst_y = d.getDestY();
        g.setColor(normalColour);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int delta_x = d.isEndLeft() ? -10 : 10;
        g.drawLine(dst_x, dst_y, dst_x + delta_x, dst_y + 4);
        g.drawLine(dst_x, dst_y, dst_x + delta_x, dst_y - 4);
        g.setStroke(dashedStroke);
        int corner_y = src_y + (d.isStartTop() ? -15 : 15);
        g.drawLine(src_x, corner_y, src_x, src_y);
        src_y = corner_y;
        int corner_x = dst_x + (d.isEndLeft() ? -15 : 15);
        g.drawLine(corner_x, dst_y, dst_x, dst_y);
        dst_x = corner_x;
        if (src_y != dst_y && d.isStartTop() == src_y < dst_y) {
            corner_x = (src_x + dst_x) / 2 + (d.isEndLeft() ? 15 : -15);
            corner_x = d.isEndLeft() ? Math.min(dst_x, corner_x) : Math.max(dst_x, corner_x);
            g.drawLine(src_x, src_y, corner_x, src_y);
            src_x = corner_x;
        }
        if (src_x != dst_x && d.isEndLeft() == src_x > dst_x) {
            corner_y = (src_y + dst_y) / 2 + (d.isStartTop() ? 15 : -15);
            corner_y = d.isStartTop() ? Math.min(src_y, corner_y) : Math.max(src_y, corner_y);
            g.drawLine(dst_x, corner_y, dst_x, dst_y);
            dst_y = corner_y;
        }
        g.drawLine(src_x, src_y, src_x, dst_y);
        g.drawLine(src_x, dst_y, dst_x, dst_y);
        g.setStroke(oldStroke);
    }

    public void paintIntermedateDependency(Graphics2D g, RubberBand rb) {
        BasicStroke dashedStroke = dashedUnselected;
        BasicStroke normalStroke = normalUnselected;
        g.setStroke(normalStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(normalColour);
        Point pFrom = rb.startPt;
        Point pTo = rb.endPt;
        double angle = Math.atan2(-(pFrom.getY() - pTo.getY()), pFrom.getX() - pTo.getX());
        int[] xPoints = new int[]{pTo.x, pTo.x + (int)(10.0 * Math.cos(angle + 0.5235987755982988)), pTo.x + (int)(10.0 * Math.cos(angle - 0.5235987755982988))};
        int[] yPoints = new int[]{pTo.y, pTo.y - (int)(10.0 * Math.sin(angle + 0.5235987755982988)), pTo.y - (int)(10.0 * Math.sin(angle - 0.5235987755982988))};
        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
        g.drawLine(xPoints[0], yPoints[0], xPoints[2], yPoints[2]);
        g.setStroke(dashedStroke);
        g.drawLine(pFrom.x, pFrom.y, xPoints[0], yPoints[0]);
    }

    public Point getPopupMenuPosition(Dependency d) {
        if (!(d instanceof UsesDependency)) {
            throw new IllegalArgumentException("Not a UsesDependency");
        }
        UsesDependency usesDependency = (UsesDependency)d;
        int delta_x = usesDependency.isEndLeft() ? -10 : 10;
        int dst_x = usesDependency.getDestX();
        int dst_y = usesDependency.getDestY();
        int[] xPoints = new int[]{dst_x, dst_x + delta_x, dst_x + delta_x};
        int[] yPoints = new int[]{dst_y, dst_y - 3, dst_y + 3};
        return new Point((xPoints[0] + xPoints[1] + xPoints[2]) / 3, (yPoints[0] + yPoints[1] + yPoints[2]) / 3);
    }
}

