/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.dependency;

import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.DependentTarget;
import java.awt.Point;
import java.util.Properties;

public class UsesDependency
extends Dependency {
    private int sourceX;
    private int sourceY;
    private int destX;
    private int destY;
    private boolean startTop;
    private boolean endLeft;
    private boolean flag = false;

    public UsesDependency(Package pkg, DependentTarget from, DependentTarget to) {
        super(pkg, from, to);
    }

    public UsesDependency(Package pkg) {
        this(pkg, null, null);
    }

    public void setSourceCoords(int src_x, int src_y, boolean start_top) {
        this.sourceX = src_x;
        this.sourceY = src_y;
        this.setStartTop(start_top);
    }

    public void setDestCoords(int dst_x, int dst_y, boolean end_left) {
        this.destX = dst_x;
        this.destY = dst_y;
        this.setEndLeft(end_left);
    }

    static final boolean inRect(int x, int y, int x0, int y0, int x1, int y1) {
        int xmin = Math.min(x0, x1);
        int xmax = Math.max(x0, x1);
        int ymin = Math.min(y0, y1);
        int ymax = Math.max(y0, y1);
        return xmin <= x && ymin <= y && x < xmax && y < ymax;
    }

    public boolean contains(int x, int y) {
        int src_x = this.sourceX;
        int src_y = this.sourceY;
        int dst_x = this.destX;
        int dst_y = this.destY;
        int corner_y = src_y + (this.isStartTop() ? -15 : 15);
        if (UsesDependency.inRect(x, y, src_x - 4, corner_y, src_x + 4, src_y)) {
            return true;
        }
        src_y = corner_y;
        int corner_x = dst_x + (this.isEndLeft() ? -15 : 15);
        if (UsesDependency.inRect(x, y, corner_x, dst_y - 4, dst_x, dst_y + 4)) {
            return true;
        }
        dst_x = corner_x;
        if (src_y != dst_y && this.isStartTop() == src_y < dst_y) {
            corner_x = (src_x + dst_x) / 2 + (this.isEndLeft() ? 15 : -15);
            int n = corner_x = this.isEndLeft() ? Math.min(dst_x, corner_x) : Math.max(dst_x, corner_x);
            if (UsesDependency.inRect(x, y, src_x, src_y - 4, corner_x, src_y + 4)) {
                return true;
            }
            src_x = corner_x;
        }
        if (src_x != dst_x && this.isEndLeft() == src_x > dst_x) {
            corner_y = (src_y + dst_y) / 2 + (this.isStartTop() ? 15 : -15);
            int n = corner_y = this.isStartTop() ? Math.min(src_y, corner_y) : Math.max(src_y, corner_y);
            if (UsesDependency.inRect(x, y, dst_x - 4, corner_y, dst_x + 4, dst_y)) {
                return true;
            }
            dst_y = corner_y;
        }
        return UsesDependency.inRect(x, y, src_x - 4, src_y, src_x + 4, dst_y) || UsesDependency.inRect(x, y, src_x, dst_y - 4, dst_x, dst_y + 4);
    }

    public Dependency.Line computeLine() {
        return new Dependency.Line(new Point(this.sourceX, this.sourceY), new Point(this.destX, this.destY), 0.0);
    }

    public void load(Properties props, String prefix) {
        super.load(props, prefix);
    }

    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(String.valueOf(prefix) + ".type", "UsesDependency");
    }

    public void setFlag(boolean value) {
        this.flag = value;
    }

    public boolean isFlagged() {
        return this.flag;
    }

    public void remove() {
        this.pkg.removeArrow(this);
    }

    public int getSourceX() {
        return this.sourceX;
    }

    public int getSourceY() {
        return this.sourceY;
    }

    public void setSourceY(int sourceY) {
        this.sourceY = sourceY;
    }

    public int getDestX() {
        return this.destX;
    }

    public int getDestY() {
        return this.destY;
    }

    public void setStartTop(boolean startTop) {
        this.startTop = startTop;
    }

    public boolean isStartTop() {
        return this.startTop;
    }

    public void setEndLeft(boolean endLeft) {
        this.endLeft = endLeft;
    }

    public boolean isEndLeft() {
        return this.endLeft;
    }

    public boolean isResizable() {
        return false;
    }
}

