/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.Boot;
import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugmgr.ExecControls;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionBridge;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.DocuGenerator;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.terminal.Terminal;
import bluej.testmgr.record.ClassInspectInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.View;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JFrame;

public class Project
implements DebuggerListener,
InspectorManager {
    private static Map projects = new HashMap();
    public static final int NEW_PACKAGE_DONE = 0;
    public static final int NEW_PACKAGE_EXIST = 1;
    public static final int NEW_PACKAGE_BAD_NAME = 2;
    public static final int NEW_PACKAGE_NO_PARENT = 3;
    public static final String projectLibDirName = "+libs";
    private File projectDir;
    private Map packages;
    private Debugger debugger;
    private ExecControls execControls = null;
    private Terminal terminal = null;
    private DocuGenerator docuGenerator;
    private String initialPackageName = "";
    private Map inspectors;
    private boolean inTestMode = false;
    private BPClassLoader currentClassLoader;
    private BProject singleBProject;

    private Project(File projectDir) {
        if (projectDir == null) {
            throw new NullPointerException();
        }
        this.projectDir = projectDir;
        this.inspectors = new HashMap();
        this.packages = new TreeMap();
        try {
            this.packages.put("", new Package(this));
        }
        catch (IOException exc) {
            Debug.reportError("could not read package file (unnamed package)");
        }
        this.debugger = Debugger.getDebuggerImpl(this.getProjectDir(), this.getTerminal());
        this.debugger.newClassLoader(this.getClassLoader());
        this.debugger.addDebuggerListener(this);
        this.debugger.launch();
        this.docuGenerator = new DocuGenerator(this);
    }

    public static boolean isProject(String projectPath) {
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            return false;
        }
        if (startingDir == null) {
            return false;
        }
        return Package.isBlueJPackage(startingDir);
    }

    public static Project openProject(String projectPath) {
        File projectDir;
        String startingPackageName;
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            Debug.message("could not resolve directory " + projectPath);
            return null;
        }
        if (startingDir == null) {
            return null;
        }
        if (Package.isBlueJPackage(startingDir)) {
            File curDir = startingDir;
            File lastDir = null;
            startingPackageName = "";
            while (curDir != null && Package.isBlueJPackage(curDir)) {
                if (lastDir != null) {
                    String lastdirName = lastDir.getName();
                    if (!JavaNames.isIdentifier(lastdirName)) break;
                    startingPackageName = "." + lastdirName + startingPackageName;
                }
                lastDir = curDir;
                curDir = curDir.getParentFile();
            }
            if (startingPackageName.length() > 0 && startingPackageName.charAt(0) == '.') {
                startingPackageName = startingPackageName.substring(1);
            }
            if ((projectDir = lastDir) == null) {
                projectDir = startingDir;
            }
        } else {
            return null;
        }
        Project proj = (Project)projects.get(projectDir);
        if (proj == null) {
            proj = new Project(projectDir);
            projects.put(projectDir, proj);
        }
        if (startingPackageName.equals("")) {
            Package startingPackage = proj.getPackage("");
            while (startingPackage != null) {
                Package sub = startingPackage.getBoringSubPackage();
                if (sub == null) break;
                startingPackage = sub;
            }
            proj.initialPackageName = startingPackage.getQualifiedName();
        } else {
            proj.initialPackageName = startingPackageName;
        }
        ExtensionsManager.getInstance().projectOpening(proj);
        return proj;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(project);
        if (frames != null) {
            int i = 0;
            while (i < frames.length) {
                frames[i].doClose(true);
                ++i;
            }
        }
    }

    public static void cleanUp(Project project) {
        if (project.hasExecControls()) {
            project.getExecControls().dispose();
        }
        if (project.terminal != null) {
            project.terminal.dispose();
        }
        project.removeAllInspectors();
        project.getDebugger().removeDebuggerListener(project);
        project.getDebugger().close(false);
        PrefMgr.addRecentProject(project.getProjectDir().getAbsolutePath());
        projects.remove(project.getProjectDir());
    }

    public static boolean createNewProject(String projectPath) {
        if (projectPath != null) {
            File dir = new File(projectPath);
            if (dir.exists()) {
                return false;
            }
            if (dir.mkdir()) {
                File newpkgFile = new File(dir, "bluej.pkg");
                File newreadmeFile = new File(dir, "README.TXT");
                try {
                    if (newpkgFile.createNewFile()) {
                        if (FileUtility.copyFile(Config.getTemplateFile("readme"), newreadmeFile)) {
                            return true;
                        }
                        Debug.message("could not copy readme template");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int getOpenProjectCount() {
        return projects.size();
    }

    public static Collection getProjects() {
        return projects.values();
    }

    public static Project getProject(Object projectKey) {
        return (Project)projects.get(projectKey);
    }

    public static Project getProject() {
        Collection projectColl;
        Iterator it;
        if (projects.size() == 1 && (it = (projectColl = projects.values()).iterator()).hasNext()) {
            return (Project)it.next();
        }
        return null;
    }

    public static boolean isBlueJProject(String projectPath) {
        File startingDir = null;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            return false;
        }
        if (startingDir == null) {
            return false;
        }
        return Package.isBlueJPackage(startingDir);
    }

    private static File pathIntoStartingDirectory(String projectPath) throws IOException {
        File startingDir = new File(projectPath).getCanonicalFile();
        if (startingDir.isDirectory()) {
            return startingDir;
        }
        if (startingDir.isFile() && startingDir.getName().equals("bluej.pkg")) {
            return startingDir.getParentFile();
        }
        return null;
    }

    public ObjectInspector getInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, JFrame parent) {
        ObjectInspector inspector = (ObjectInspector)this.inspectors.get(obj);
        if (inspector == null) {
            inspector = new ObjectInspector(obj, this, name, pkg, ir, parent);
            this.inspectors.put(obj, inspector);
        }
        final ObjectInspector insp = inspector;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                insp.update();
                insp.setVisible(true);
                insp.bringToFront();
            }
        });
        return inspector;
    }

    public Inspector getInspector(Object obj) {
        return (Inspector)this.inspectors.get(obj);
    }

    public void removeInspector(DebuggerObject obj) {
        this.inspectors.remove(obj);
    }

    public void removeInspector(DebuggerClass cls) {
        this.inspectors.remove(cls.getName());
    }

    public void removeInspectorInstance(Object obj) {
        Inspector inspect = this.getInspector(obj);
        if (inspect != null) {
            inspect.doClose(false);
        }
    }

    public void removeAllInspectors() {
        Iterator it = this.inspectors.values().iterator();
        while (it.hasNext()) {
            Inspector inspector = (Inspector)it.next();
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.inspectors.clear();
    }

    public ClassInspector getClassInspectorInstance(DebuggerClass clss, Package pkg, JFrame parent) {
        ClassInspector inspector = (ClassInspector)this.inspectors.get(clss.getName());
        if (inspector == null) {
            ClassInspectInvokerRecord ir = new ClassInspectInvokerRecord(clss.getName());
            inspector = new ClassInspector(clss, this, pkg, ir, parent);
            this.inspectors.put(clss.getName(), inspector);
        }
        final ClassInspector insp = inspector;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                insp.update();
                insp.setVisible(true);
                insp.bringToFront();
            }
        });
        return inspector;
    }

    public ResultInspector getResultInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, JFrame parent) {
        ResultInspector inspector = (ResultInspector)pkg.getProject().getInspector(obj);
        if (inspector == null) {
            inspector = new ResultInspector(obj, this, name, pkg, ir, info, parent);
            this.inspectors.put(obj, inspector);
        }
        final ResultInspector insp = inspector;
        insp.update();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                insp.setVisible(true);
                insp.bringToFront();
            }
        });
        return inspector;
    }

    public void updateInspectors() {
        Iterator it = this.inspectors.values().iterator();
        while (it.hasNext()) {
            Inspector inspector = (Inspector)it.next();
            inspector.update();
        }
    }

    public String getProjectName() {
        return this.projectDir.getName();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public boolean isReadOnly() {
        return !this.projectDir.canWrite();
    }

    public String getUniqueId() {
        return String.valueOf(new String("BJID" + this.getProjectDir().getPath()).hashCode());
    }

    public String getInitialPackageName() {
        return this.initialPackageName;
    }

    public Package getPackage(String qualifiedName) {
        Package existing = (Package)this.packages.get(qualifiedName);
        if (existing != null) {
            return existing;
        }
        if (qualifiedName.length() > 0) {
            Package pkg;
            try {
                Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
                if (parent != null) {
                    pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
                    this.packages.put(qualifiedName, pkg);
                } else {
                    pkg = null;
                }
            }
            catch (IOException exc) {
                pkg = null;
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                pkg = null;
            }
            return pkg;
        }
        throw new IllegalStateException("Project.getPackage()");
    }

    public final synchronized BProject getBProject() {
        if (this.singleBProject == null) {
            this.singleBProject = ExtensionBridge.newBProject((Project)this);
        }
        return this.singleBProject;
    }

    public Package getCachedPackage(String qualifiedName) {
        return (Package)this.packages.get(qualifiedName);
    }

    public void createPackageDirectory(String fullName) {
        StringTokenizer st = new StringTokenizer(fullName, ".");
        File newPkgDir = this.getProjectDir();
        while (st.hasMoreTokens()) {
            newPkgDir = new File(newPkgDir, st.nextToken());
        }
        if (newPkgDir.isDirectory() || newPkgDir.mkdirs()) {
            st = new StringTokenizer(fullName, ".");
            newPkgDir = this.getProjectDir();
            File newPkgFile = new File(newPkgDir, "bluej.pkg");
            try {
                newPkgFile.createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            while (st.hasMoreTokens()) {
                newPkgDir = new File(newPkgDir, st.nextToken());
                newPkgFile = new File(newPkgDir, "bluej.pkg");
                try {
                    newPkgFile.createNewFile();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public int newPackage(String qualifiedName) {
        if (qualifiedName == null) {
            return 2;
        }
        Package existing = (Package)this.packages.get(qualifiedName);
        if (existing != null) {
            return 1;
        }
        if (qualifiedName.length() < 1) {
            return 2;
        }
        try {
            Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
            if (parent == null) {
                return 3;
            }
            this.createPackageDirectory(qualifiedName);
            Package pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
            this.packages.put(qualifiedName, pkg);
        }
        catch (IOException exc) {
            return 2;
        }
        return 0;
    }

    public Package getExistingPackage(String packageName) {
        Package r = this.getPackage("");
        while (packageName.length() != 0) {
            String nextName;
            int firstPos = packageName.indexOf(46);
            if (firstPos == -1) {
                nextName = packageName;
                packageName = "";
            } else {
                nextName = packageName.substring(0, firstPos);
                packageName = packageName.substring(firstPos + 1);
            }
            List children = r.getChildren(true);
            Iterator i = children.iterator();
            Package child = null;
            while (i.hasNext()) {
                child = (Package)i.next();
                if (child.getBaseName().equals(nextName)) break;
            }
            if (child == null) {
                return null;
            }
            r = child;
        }
        return r;
    }

    private List getPackageNames(Package rootPackage) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(rootPackage.getQualifiedName());
        List children = rootPackage.getChildren(true);
        if (children != null) {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Package p = (Package)i.next();
                l.addAll(this.getPackageNames(p));
            }
        }
        return l;
    }

    public List getPackageNames() {
        return this.getPackageNames(this.getPackage(""));
    }

    public String generateDocumentation() {
        return this.docuGenerator.generateProjectDocu();
    }

    public String getDocumentationFile(String filename) {
        return this.docuGenerator.getDocuPath(filename);
    }

    public void generateDocumentation(String filename) {
        this.docuGenerator.generateClassDocu(filename);
    }

    public void saveAll() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames == null) {
            return;
        }
        int i = 0;
        while (i < frames.length) {
            frames[i].doSave();
            ++i;
        }
    }

    public void reloadAll() {
        Iterator i = this.packages.values().iterator();
        while (i.hasNext()) {
            Package pkg = (Package)i.next();
            pkg.reload();
        }
    }

    public void saveAs(PkgMgrFrame frame) {
        String newName = FileUtility.getFileName(frame, Config.getString("pkgmgr.saveAs.title"), Config.getString("pkgmgr.saveAs.buttonLabel"), false, null, true);
        if (newName != null) {
            this.saveAll();
            int result = FileUtility.copyDirectory(this.getProjectDir().getPath(), newName);
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    DialogManager.showError(frame, "directory-exists");
                    return;
                }
                case 2: 
                case 3: {
                    DialogManager.showError(frame, "cannot-copy-package");
                    return;
                }
            }
            Project.closeProject(this);
            Project openProj = Project.openProject(newName);
            if (openProj != null) {
                Package pkg = openProj.getPackage(openProj.getInitialPackageName());
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(pkg);
                pmf.show();
            } else {
                Debug.message("could not open package under new name");
            }
        }
    }

    public void restartVM() {
        this.getDebugger().close(true);
        this.vmClosed();
        PkgMgrFrame.displayMessage(this, Config.getString("pkgmgr.creatingVM"));
    }

    private void vmReady() {
        BlueJEvent.raiseEvent(2, null);
        Utility.bringToFront();
    }

    private void vmClosed() {
        Iterator i = this.packages.values().iterator();
        while (i.hasNext()) {
            Package pkg = (Package)i.next();
            pkg.removeBreakpoints();
        }
        this.removeClassLoader();
        this.newRemoteClassLoader();
    }

    public void removeClassLoader() {
        if (this.currentClassLoader == null) {
            return;
        }
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        int i = 0;
        while (i < frames.length) {
            frames[i].getObjectBench().removeAllObjects(this.getUniqueId());
            frames[i].clearTextEval();
            ++i;
        }
        this.removeAllInspectors();
        View.removeAll(this.currentClassLoader);
        new Thread(){

            public void run() {
                Project.this.getDebugger().disposeWindows();
            }
        }.start();
        this.currentClassLoader = null;
    }

    public void newRemoteClassLoader() {
        this.getDebugger().newClassLoader(this.getClassLoader());
    }

    public void newRemoteClassLoaderLeavingBreakpoints() {
        this.getDebugger().newClassLoaderLeavingBreakpoints(this.getClassLoader());
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public boolean hasExecControls() {
        return this.execControls != null;
    }

    public ExecControls getExecControls() {
        if (this.execControls == null) {
            this.execControls = new ExecControls(this, this.getDebugger());
        }
        return this.execControls;
    }

    public boolean hasTerminal() {
        return this.terminal != null;
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            this.terminal = new Terminal(this);
        }
        return this.terminal;
    }

    public Class loadClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (LinkageError le) {
            return null;
        }
    }

    public boolean inTestMode() {
        return this.inTestMode;
    }

    public void setTestMode(boolean mode) {
        this.inTestMode = mode;
    }

    protected ArrayList getPlusLibsContent() {
        ArrayList risul = new ArrayList();
        File libsDirectory = new File(this.projectDir, projectLibDirName);
        if (!libsDirectory.isDirectory() || !libsDirectory.canRead()) {
            return risul;
        }
        File[] libs = libsDirectory.listFiles();
        if (libs == null || libs.length < 1) {
            return risul;
        }
        int index = 0;
        while (index < libs.length) {
            Project.attemptAddLibrary(risul, libs[index]);
            ++index;
        }
        return risul;
    }

    private static final void attemptAddLibrary(ArrayList risul, File aFile) {
        if (aFile == null) {
            return;
        }
        if (!aFile.isFile() || !aFile.canRead()) {
            return;
        }
        String libname = aFile.getName().toLowerCase();
        if (!libname.endsWith(".jar") && !libname.endsWith(".zip")) {
            return;
        }
        try {
            risul.add(aFile.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            Debug.reportError("Project.attemptAddLibrary() malformaed file=" + aFile);
        }
    }

    public static final ArrayList getUserlibContent() {
        ArrayList risul = new ArrayList();
        File userLibDir = new File(Boot.getInstance().getBluejLibDir(), "userlib");
        File[] files = userLibDir.listFiles();
        if (files == null) {
            return risul;
        }
        int index = 0;
        while (index < files.length) {
            Project.attemptAddLibrary(risul, files[index]);
            ++index;
        }
        return risul;
    }

    private void addArrayToList(ArrayList list, URL[] urls) {
        int index = 0;
        while (index < urls.length) {
            list.add(urls[index]);
            ++index;
        }
    }

    public BPClassLoader getClassLoader() {
        if (this.currentClassLoader != null) {
            return this.currentClassLoader;
        }
        ArrayList<URL> pathList = new ArrayList<URL>();
        try {
            this.addArrayToList(pathList, Boot.getInstance().getRuntimeUserClassPath());
            pathList.addAll(PrefMgrDialog.getInstance().getUserConfigLibPanel().getUserConfigContent());
            pathList.addAll(Project.getUserlibContent());
            pathList.addAll(this.getPlusLibsContent());
            pathList.add(this.getProjectDir().toURI().toURL());
            if (Config.isGreenfoot()) {
                this.addArrayToList(pathList, Boot.getInstance().getRuntimeClassPath());
                File extDir = new File(Config.getBlueJLibDir(), "extensions/greenfoot.jar");
                pathList.add(extDir.toURI().toURL());
            }
        }
        catch (Exception exc) {
            Debug.reportError("Project.getClassLoader() exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        URL[] newUrls = pathList.toArray(new URL[pathList.size()]);
        this.currentClassLoader = new BPClassLoader(newUrls, Boot.getInstance().getBootClassLoader());
        return this.currentClassLoader;
    }

    public String convertPathToPackageName(String pathname) {
        return JavaNames.convertFileToQualifiedName(this.getProjectDir(), new File(pathname));
    }

    public void removeStepMarks() {
        Iterator i = this.packages.values().iterator();
        while (i.hasNext()) {
            Package pkg = (Package)i.next();
            pkg.removeStepMarks();
        }
    }

    public void debuggerEvent(final DebuggerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (event.getID() == 1) {
                    PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(Project.this);
                    if (frames == null) {
                        return;
                    }
                    int newState = event.getNewState();
                    int oldState = event.getOldState();
                    int i = 0;
                    while (i < frames.length) {
                        frames[i].setDebuggerState(newState);
                        ++i;
                    }
                    if (oldState == 1 && newState == 2) {
                        Project.this.vmReady();
                    }
                    if (oldState == 2 && newState == 1) {
                        Project.this.vmClosed();
                    }
                    if (newState == 5) {
                        BlueJEvent.raiseEvent(1, null);
                    }
                    return;
                }
                if (event.getID() == 2) {
                    Project.this.removeStepMarks();
                    return;
                }
                DebuggerThread thr = event.getThread();
                String packageName = JavaNames.getPrefix(thr.getClass(0));
                Package pkg = Project.this.getPackage(packageName);
                if (pkg != null) {
                    switch (event.getID()) {
                        case 4: {
                            pkg.hitBreakpoint(thr);
                            break;
                        }
                        case 3: {
                            pkg.hitHalt(thr);
                            break;
                        }
                        case 6: {
                            pkg.showSourcePosition(thr);
                        }
                    }
                }
            }
        });
    }

    public String toString() {
        return "Project:" + this.getProjectName();
    }

    public void removePackage(String packageQualifiedName) {
        Package pkg = (Package)this.packages.get(packageQualifiedName);
        if (pkg != null) {
            List childPackages = pkg.getChildren(false);
            if (childPackages != null) {
                Iterator i = childPackages.iterator();
                while (i.hasNext()) {
                    Package childPkg = (Package)i.next();
                    this.removePackage(childPkg.getQualifiedName());
                }
            }
            this.packages.remove(packageQualifiedName);
        }
    }
}

