/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.parser.ClassParser;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.ImportMismatchDialog;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;

class Import {
    Import() {
    }

    public static boolean convertNonBlueJ(JFrame parentWin, File path) {
        List interestingDirs = Import.findInterestingDirectories(path);
        if (interestingDirs.size() == 0) {
            DialogManager.showError(parentWin, "open-non-bluej-no-java");
            return false;
        }
        List javaFiles = Import.findJavaFiles(interestingDirs);
        ArrayList<File> mismatchFiles = new ArrayList<File>();
        ArrayList<String> mismatchPackagesOriginal = new ArrayList<String>();
        ArrayList<String> mismatchPackagesChanged = new ArrayList<String>();
        Iterator it = javaFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            try {
                ClassInfo info = ClassParser.parse(f);
                String qf = JavaNames.convertFileToQualifiedName(path, f);
                if (JavaNames.getPrefix(qf).equals(info.getPackage())) continue;
                mismatchFiles.add(f);
                mismatchPackagesOriginal.add(info.getPackage());
                mismatchPackagesChanged.add(qf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mismatchFiles.size() > 0) {
            ImportMismatchDialog imd = new ImportMismatchDialog(parentWin, mismatchFiles, mismatchPackagesOriginal, mismatchPackagesChanged);
            imd.show();
            if (!imd.getResult()) {
                return false;
            }
        }
        Import.convertDirectory(interestingDirs);
        return true;
    }

    public static List findInterestingDirectories(File dir) {
        LinkedList<File> interesting = new LinkedList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return interesting;
        }
        boolean imInteresting = false;
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                List subInteresting;
                if (JavaNames.isIdentifier(files[i].getName()) && (subInteresting = Import.findInterestingDirectories(files[i])).size() > 0) {
                    interesting.addAll(subInteresting);
                    imInteresting = true;
                }
            } else if (files[i].getName().endsWith(".java")) {
                imInteresting = true;
            }
            ++i;
        }
        if (imInteresting) {
            interesting.add(dir);
        }
        return interesting;
    }

    public static List findJavaFiles(List dirs) {
        LinkedList<File> interesting = new LinkedList<File>();
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            File[] files = dir.listFiles();
            if (files == null) continue;
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile() && files[i].getName().endsWith(".java")) {
                    interesting.add(files[i]);
                }
                ++i;
            }
        }
        return interesting;
    }

    public static void convertDirectory(List dirs) {
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            File bluejFile = new File(f, "bluej.pkg");
            if (bluejFile.exists()) continue;
            try {
                bluejFile.createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

