/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.parser.SourceLocation;

public class SourceSpan {
    private SourceLocation start;
    private SourceLocation end;

    public SourceSpan(SourceLocation start, SourceLocation end) {
        this.start = start;
        this.end = end;
    }

    public SourceSpan(SourceLocation start, int numChars) {
        this.start = start;
        this.end = new SourceLocation(start.getLine(), start.getColumn() + numChars);
    }

    public boolean isOneLine() {
        return this.start.getLine() == this.end.getLine();
    }

    public SourceLocation getStartLocation() {
        return this.start;
    }

    public int getStartColumn() {
        return this.start.getColumn();
    }

    public int getStartLine() {
        return this.start.getLine();
    }

    public SourceLocation getEndLocation() {
        return this.end;
    }

    public int getEndColumn() {
        return this.end.getColumn();
    }

    public int getEndLine() {
        return this.end.getLine();
    }

    public String toString() {
        return String.valueOf(this.start.toString()) + "-" + this.end.toString();
    }
}

