/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import antlr.CharScanner;
import java.io.IOException;
import java.io.Reader;

public class EscapedUnicodeReader
extends Reader {
    Reader sourceReader;
    CharScanner attachedScanner;
    private boolean charIsBuffered;
    private int bufferedChar;
    private boolean bumpColumn;

    public EscapedUnicodeReader(Reader source) {
        this.sourceReader = source;
    }

    public void setAttachedScanner(CharScanner scanner) {
        this.attachedScanner = scanner;
    }

    public int read(char[] buffer, int off, int len) throws IOException {
        int numRead = 0;
        while (len > 0) {
            try {
                int r = this.getChar();
                if (r == -1) break;
                buffer[off++] = (char)r;
                --len;
                ++numRead;
            }
            catch (IOException ioe) {
                if (numRead != 0) break;
                throw ioe;
            }
        }
        if (numRead == 0 && len != 0) {
            numRead = -1;
        }
        return numRead;
    }

    public void close() throws IOException {
        this.sourceReader.close();
    }

    private int getChar() throws IOException {
        if (this.bumpColumn) {
            this.attachedScanner.setColumn(this.attachedScanner.getColumn() + 5);
            this.bumpColumn = false;
        }
        if (this.charIsBuffered) {
            this.charIsBuffered = false;
            return this.bufferedChar;
        }
        int rchar = this.sourceReader.read();
        if (rchar == 92) {
            int nchar = this.sourceReader.read();
            if (nchar == 117) {
                this.bumpColumn = true;
                return this.readEscapedUnicodeSequence();
            }
            this.putBuffer(nchar);
            return 92;
        }
        return rchar;
    }

    private void putBuffer(int nchar) {
        this.bufferedChar = nchar;
        this.charIsBuffered = true;
    }

    private int readEscapedUnicodeSequence() throws IOException {
        int d1 = this.sourceReader.read();
        int d2 = this.sourceReader.read();
        int d3 = this.sourceReader.read();
        int d4 = this.sourceReader.read();
        int rval = this.hexDigitValue(d1) * 4096;
        rval += this.hexDigitValue(d2) * 256;
        rval += this.hexDigitValue(d3) * 16;
        return rval += this.hexDigitValue(d4);
    }

    private int hexDigitValue(int hexDigit) throws IOException {
        int hval = Character.digit((char)hexDigit, 16);
        if (hval == -1) {
            throw new IOException();
        }
        return hval;
    }
}

