/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Project;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class MenuManager
implements PopupMenuListener {
    private final ExtensionsManager extMgr = ExtensionsManager.getInstance();
    private final JPopupMenu.Separator menuSeparator;
    private final JPopupMenu popupMenu;
    private Object attachedObject;

    public MenuManager(JPopupMenu aPopupMenu) {
        this.popupMenu = aPopupMenu;
        this.popupMenu.addPopupMenuListener(this);
        this.menuSeparator = new JPopupMenu.Separator();
    }

    public void addExtensionMenu(Project onThisProject) {
        LinkedList menuItems = this.extMgr.getMenuItems(this.attachedObject, onThisProject);
        MenuElement[] elements = this.popupMenu.getSubElements();
        int index = 0;
        while (index < elements.length) {
            ExtensionWrapper aWrapper;
            JComponent aComponent = (JComponent)elements[index].getComponent();
            if (aComponent != null && aComponent instanceof JMenuItem && (aWrapper = (ExtensionWrapper)aComponent.getClientProperty("bluej.extmgr.ExtensionWrapper")) != null) {
                this.popupMenu.remove(aComponent);
            }
            ++index;
        }
        this.popupMenu.remove(this.menuSeparator);
        if (menuItems.isEmpty()) {
            return;
        }
        this.popupMenu.add(this.menuSeparator);
        Iterator iter = menuItems.iterator();
        while (iter.hasNext()) {
            this.popupMenu.add((JComponent)iter.next());
        }
    }

    public void setAttachedObject(Object attachedTo) {
        this.attachedObject = attachedTo;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
        int itemsCount = 0;
        JPopupMenu aPopup = (JPopupMenu)event.getSource();
        MenuElement[] elements = aPopup.getSubElements();
        int index = 0;
        while (index < elements.length) {
            ExtensionWrapper aWrapper;
            JComponent aComponent = (JComponent)elements[index].getComponent();
            if (aComponent != null && aComponent instanceof JMenuItem && (aWrapper = (ExtensionWrapper)aComponent.getClientProperty("bluej.extmgr.ExtensionWrapper")) != null) {
                if (!aWrapper.isValid()) {
                    this.popupMenu.remove(aComponent);
                } else {
                    aWrapper.safePostMenuItem(this.attachedObject, (JMenuItem)aComponent);
                    ++itemsCount;
                }
            }
            ++index;
        }
        if (itemsCount <= 0) {
            this.popupMenu.remove(this.menuSeparator);
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
    }

    public void popupMenuCanceled(PopupMenuEvent event) {
    }
}

