/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FieldList
extends JTable {
    static /* synthetic */ Class class$0;

    public FieldList(int maxDescriptionLength) {
        super(new ListTableModel());
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, new ListTableCellRenderer(maxDescriptionLength));
        this.setRowHeight(25);
        this.setAutoResizeMode(4);
        this.getTableHeader().setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        this.removeHeader();
    }

    public void setData(Object[] listData) {
        ((ListTableModel)this.getModel()).setDataVector(listData);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TableCellRenderer ltcr = this.getDefaultRenderer(clazz);
        int column = 0;
        while (column < 2) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            int preferredWidth = tableColumn.getPreferredWidth();
            int row = 0;
            while (row < 4 && row < listData.length) {
                Component n = ltcr.getTableCellRendererComponent(this, this.dataModel.getValueAt(row, column), false, false, row, column);
                int labelWidth = n.getPreferredSize().width;
                if (labelWidth > preferredWidth) {
                    preferredWidth = labelWidth;
                }
                ++row;
            }
            tableColumn.setPreferredWidth(preferredWidth);
            ++column;
        }
        this.revalidate();
    }

    private void removeHeader() {
        this.unconfigureEnclosingScrollPane();
    }

    static class ListTableModel
    extends AbstractTableModel {
        private Object[][] cells;

        public Object getValueAt(int row, int col) {
            return this.cells[row][col];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.cells != null) {
                return this.cells.length;
            }
            return 0;
        }

        public ListTableModel() {
        }

        public ListTableModel(Object[] rows) {
            this.setDataVector(rows);
        }

        public void setDataVector(Object[] rows) {
            this.cells = new Object[rows.length][2];
            int i = 0;
            while (i < rows.length) {
                String valueString;
                String descriptionString;
                String s = (String)rows[i];
                int delimiterIndex = s.indexOf(61);
                if (delimiterIndex >= 0) {
                    descriptionString = s.substring(0, delimiterIndex);
                    valueString = s.substring(delimiterIndex + 1);
                } else {
                    descriptionString = s;
                    valueString = "";
                }
                this.cells[i][0] = descriptionString;
                this.cells[i][1] = valueString;
                ++i;
            }
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    public static class ListTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final ImageIcon objectrefIcon = Config.getImageAsIcon("image.inspector.objectref");
        private static final Border valueBorder = BorderFactory.createLineBorder(Color.gray);
        private int maxDescriptionLength;

        public ListTableCellRenderer(int maxDescriptionLength) {
            this.maxDescriptionLength = maxDescriptionLength;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String valueString = (String)value;
            if (valueString.equals(" <object reference>")) {
                this.setIcon(objectrefIcon);
                this.setText("");
            } else {
                StringBuffer displayString = new StringBuffer(valueString);
                this.replaceAll(displayString, "\n", "\\n");
                this.replaceAll(displayString, "\t", "\\t");
                this.replaceAll(displayString, "\r", "\\r");
                this.setIcon(null);
                this.setText(displayString.toString());
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            Border b = BorderFactory.createLineBorder(this.getBackground(), 3);
            super.setBorder(b);
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            int preferredWidth = tableColumn.getPreferredWidth();
            int labelWidth = this.getPreferredSize().width;
            if (labelWidth > preferredWidth) {
                preferredWidth = labelWidth;
                tableColumn.setPreferredWidth(preferredWidth);
            }
            if (column == 1) {
                this.setBackground(Color.white);
                this.setHorizontalAlignment(0);
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.getBorder(), valueBorder);
                super.setBorder(compoundBorder);
            } else {
                this.setHorizontalAlignment(10);
                if (valueString.length() < this.maxDescriptionLength) {
                    if (preferredWidth > tableColumn.getMinWidth()) {
                        tableColumn.setMinWidth(preferredWidth);
                    }
                } else {
                    String tmp = valueString.substring(0, this.maxDescriptionLength);
                    JLabel dummy = new JLabel(tmp);
                    int minWidth = dummy.getPreferredSize().width;
                    if (tableColumn.getMinWidth() < minWidth) {
                        tableColumn.setMinWidth(minWidth);
                    }
                }
            }
            return this;
        }

        private void replaceAll(StringBuffer sb, String orig, String replacement) {
            int location = sb.toString().indexOf(orig);
            while (location != -1) {
                sb.replace(location, location + orig.length(), replacement);
                location = sb.toString().indexOf(orig);
            }
        }
    }
}

