/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.views.TypeParamView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallHistory {
    private Map objectTypes = null;
    private List objectClasses = null;
    private List objectParams = null;
    private Map typeParams = null;
    private int historyLength;
    static final int DEFAULT_LENGTH = 6;
    static final String INT_NAME = "int";
    static final String BOOLEAN_NAME = "boolean";
    static final String LONG_NAME = "long";
    static final String FLOAT_NAME = "float";
    static final String DOUBLE_NAME = "double";
    static final String SHORT_NAME = "short";
    static final String STRING_NAME = "java.lang.String";

    public CallHistory() {
        this(6);
    }

    public CallHistory(int length) {
        this.historyLength = length;
        this.objectTypes = new HashMap(8);
        this.objectTypes.put(INT_NAME, new ArrayList(length));
        this.objectTypes.put(LONG_NAME, new ArrayList(length));
        this.objectTypes.put(BOOLEAN_NAME, new ArrayList(length));
        this.objectTypes.put(FLOAT_NAME, new ArrayList(length));
        this.objectTypes.put(DOUBLE_NAME, new ArrayList(length));
        this.objectTypes.put(SHORT_NAME, new ArrayList(length));
        this.objectTypes.put(STRING_NAME, new ArrayList(length));
        this.objectClasses = new ArrayList();
        this.objectParams = new ArrayList();
        this.typeParams = new HashMap();
    }

    public List getHistory(Class objectClass) {
        List history = null;
        if (this.objectTypes.containsKey(objectClass.getName())) {
            history = (List)this.objectTypes.get(objectClass.getName());
        } else {
            history = new ArrayList();
            int i = 0;
            while (i < this.objectClasses.size()) {
                if (objectClass.isAssignableFrom((Class)this.objectClasses.get(i))) {
                    history.add(this.objectParams.get(i));
                }
                ++i;
            }
        }
        return history;
    }

    public List getHistory(TypeParamView typeParam) {
        List history = (List)this.typeParams.get(typeParam.toString());
        return history;
    }

    public void addCall(TypeParamView typeParam, String parameter) {
        ArrayList<String> history = (ArrayList<String>)this.typeParams.get(typeParam.toString());
        if (history == null) {
            history = new ArrayList<String>();
            this.typeParams.put(typeParam.toString(), history);
        }
        history.add(parameter);
    }

    public void addCall(Class objectType, String argument) {
        if (argument != null) {
            if (this.objectTypes.containsKey(objectType.getName())) {
                List history = this.getHistory(objectType);
                int index = history.indexOf(argument);
                if (index != 0) {
                    if (index > 0) {
                        history.remove(index);
                    }
                    history.add(0, argument);
                }
                if (history.size() > this.historyLength) {
                    history.remove(this.historyLength);
                }
            } else {
                int index = this.objectParams.indexOf(argument);
                if (index != 0) {
                    if (index > 0) {
                        this.objectParams.remove(index);
                        this.objectClasses.remove(index);
                    }
                    this.objectClasses.add(0, objectType);
                    this.objectParams.add(0, argument);
                }
            }
        }
    }
}

