/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Boot;
import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiDebugger;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.VMEventHandler;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class VMReference {
    static final String SERVER_CLASSNAME = "bluej.runtime.ExecServer";
    static final String SERVER_STARTED_METHOD_NAME = "vmStarted";
    static final String SERVER_SUSPEND_METHOD_NAME = "vmSuspend";
    private static Map vmToReferenceMap = new HashMap();
    private JdiDebugger owner = null;
    private VirtualMachine machine = null;
    private Process remoteVMprocess = null;
    private VMEventHandler eventHandler = null;
    private ClassType serverClass = null;
    private ThreadReference serverThread = null;
    private boolean serverThreadStarted = false;
    private ThreadReference workerThread = null;
    private boolean workerThreadReady = false;
    private IOHandlerThread inputStreamRedirector = null;
    private IOHandlerThread outputStreamRedirector = null;
    private IOHandlerThread errorStreamRedirector = null;
    private ClassLoaderReference currentLoader = null;
    private int exitStatus;
    private ExceptionDescription lastException;
    private static int shmCount = 0;

    public VirtualMachine localhostSocketLaunch(File initDir, DebuggerTerminal term, VirtualMachineManager mgr) {
        int CONNECT_TRIES = 10;
        int CONNECT_WAIT = 500;
        Boot boot = Boot.getInstance();
        File[] filesPath = BPClassLoader.toFiles(boot.getRuntimeUserClassPath());
        String allClassPath = BPClassLoader.toClasspathString(filesPath);
        ArrayList<String> paramList = new ArrayList<String>(10);
        paramList.add(Config.getJDKExecutablePath(null, "java"));
        List configArgs = Config.getDebugVMArgs();
        if (!configArgs.isEmpty()) {
            paramList.addAll(configArgs);
        }
        paramList.add("-classpath");
        paramList.add(allClassPath);
        paramList.add("-Xdebug");
        paramList.add("-Xnoagent");
        if (!PrefMgr.getFlag("bluej.vm.optimize")) {
            paramList.add("-Xint");
        }
        if (Config.isMacOS()) {
            if (Config.isGreenfoot()) {
                paramList.add("-Xdock:icon=" + Config.getBlueJIconPath() + "/greenfootvm.icns");
                paramList.add("-Xdock:name=Greenfoot");
            } else {
                paramList.add("-Xdock:icon=" + Config.getBlueJIconPath() + "/vm.icns");
                paramList.add("-Xdock:name=BlueJ Virtual Machine");
            }
        }
        paramList.add("-Xrunjdwp:transport=dt_socket,server=y");
        paramList.add(SERVER_CLASSNAME);
        String[] launchParams = paramList.toArray(new String[0]);
        String transport = Config.getPropString("bluej.vm.transport");
        AttachingConnector tcpipConnector = null;
        AttachingConnector shmemConnector = null;
        Throwable tcpipFailureReason = null;
        Throwable shmemFailureReason = null;
        List<AttachingConnector> connectors = mgr.attachingConnectors();
        AttachingConnector connector = null;
        Iterator<AttachingConnector> it = connectors.iterator();
        while (it.hasNext()) {
            AttachingConnector c = it.next();
            if (c.transport().name().equals("dt_socket")) {
                tcpipConnector = c;
                continue;
            }
            if (!c.transport().name().equals("dt_shmem")) continue;
            shmemConnector = c;
        }
        connector = tcpipConnector;
        if (transport.equals("dt_shmem") && shmemConnector != null) {
            connector = null;
        }
        int i = 0;
        while (i < 10) {
            block25: {
                if (connector != null) {
                    try {
                        final StringBuffer listenMessage = new StringBuffer();
                        this.remoteVMprocess = this.launchVM(initDir, launchParams, listenMessage, term);
                        int portNumber = this.extractPortNumber(listenMessage.toString());
                        if (portNumber == -1) {
                            this.closeIO();
                            this.remoteVMprocess.destroy();
                            this.remoteVMprocess = null;
                            throw new Exception(){

                                public void printStackTrace() {
                                    Debug.message("Could not find port number to connect to debugger");
                                    Debug.message("Line received from debugger was: " + listenMessage);
                                }
                            };
                        }
                        Map<String, Connector.Argument> arguments = connector.defaultArguments();
                        Connector.Argument hostnameArg = arguments.get("hostname");
                        Connector.Argument portArg = arguments.get("port");
                        if (hostnameArg == null || portArg == null) {
                            throw new Exception(){

                                public void printStackTrace() {
                                    Debug.message("incompatible JPDA socket launch connector");
                                }
                            };
                        }
                        hostnameArg.setValue("127.0.0.1");
                        portArg.setValue(Integer.toString(portNumber));
                        try {
                            VirtualMachine m = connector.attach(arguments);
                            Debug.log("Connected to debug VM via dt_socket transport.");
                            this.machine = m;
                            this.setupEventHandling();
                            this.waitForStartup();
                            return m;
                        }
                        catch (Throwable t) {
                            this.closeIO();
                            this.remoteVMprocess.destroy();
                            this.remoteVMprocess = null;
                            throw t;
                        }
                    }
                    catch (Throwable t) {
                        tcpipFailureReason = t;
                    }
                }
                if ((connector = shmemConnector) != null) {
                    try {
                        Map<String, Connector.Argument> arguments = connector.defaultArguments();
                        Connector.Argument addressArg = arguments.get("name");
                        if (addressArg == null) {
                            throw new Exception(){

                                public void printStackTrace() {
                                    Debug.message("Shared memory connector is incompatible - no 'name' argument");
                                }
                            };
                        }
                        String shmName = "bluej" + shmCount++;
                        addressArg.setValue(shmName);
                        launchParams[launchParams.length - 2] = "-Xrunjdwp:transport=dt_shmem,address=" + shmName + ",server=y,suspend=y";
                        StringBuffer listenMessage = new StringBuffer();
                        this.remoteVMprocess = this.launchVM(initDir, launchParams, listenMessage, term);
                        VirtualMachine m = connector.attach(arguments);
                        Debug.log("Connected to debug VM via dt_shmem transport.");
                        this.machine = m;
                        this.waitForStartup();
                        this.setupEventHandling();
                        return m;
                    }
                    catch (Throwable t) {
                        shmemFailureReason = t;
                    }
                }
                try {
                    if (i == 9) break block25;
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            connector = tcpipConnector;
            ++i;
        }
        Debug.message("Failed to connect to debug VM. Reasons follow:");
        if (tcpipConnector != null && tcpipFailureReason != null) {
            Debug.message("dt_socket transport:");
            tcpipFailureReason.printStackTrace();
        }
        if (shmemConnector != null && shmemFailureReason != null) {
            Debug.message("dt_shmem transport:");
            tcpipFailureReason.printStackTrace();
        }
        if (shmemConnector == null && tcpipConnector == null) {
            Debug.message(" No suitable transports available.");
        }
        return null;
    }

    private void setupEventHandling() {
        EventRequestManager erm = this.machine.eventRequestManager();
        erm.createExceptionRequest(null, false, true).enable();
        erm.createClassPrepareRequest().enable();
        erm.createThreadStartRequest().enable();
        erm.createThreadDeathRequest().enable();
        this.eventHandler = new VMEventHandler(this, this.machine);
    }

    private Process launchVM(File initDir, String[] params, StringBuffer line, DebuggerTerminal term) throws IOException {
        Process vmProcess = Runtime.getRuntime().exec(params, null, initDir);
        BufferedReader br = new BufferedReader(new InputStreamReader(vmProcess.getInputStream()));
        String listenMessage = br.readLine();
        line.append(listenMessage);
        try {
            br = new BufferedReader(new InputStreamReader(vmProcess.getErrorStream()));
            StringBuffer extra = new StringBuffer();
            char[] buf = new char[1024];
            int i = 0;
            while (i < 5) {
                int len;
                Thread.sleep(200L);
                if (!br.ready() || (len = br.read(buf)) == -1) break;
                extra.append(buf, 0, len);
                ++i;
            }
            if (extra.length() != 0) {
                Debug.message("Extra output from debug VM on launch:" + extra);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.errorStreamRedirector = this.redirectIOStream(new InputStreamReader(vmProcess.getErrorStream(), "UTF8"), term.getErrorWriter(), false);
        this.outputStreamRedirector = this.redirectIOStream(new InputStreamReader(vmProcess.getInputStream(), "UTF8"), term.getWriter(), false);
        this.inputStreamRedirector = this.redirectIOStream(term.getReader(), new OutputStreamWriter(vmProcess.getOutputStream(), "UTF8"), false);
        return vmProcess;
    }

    private int extractPortNumber(String msg) {
        int colonIndex = msg.indexOf(":");
        int val = -1;
        try {
            if (colonIndex > -1) {
                val = Integer.parseInt(msg.substring(colonIndex + 1).trim());
            }
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return val;
    }

    public VMReference(JdiDebugger owner, DebuggerTerminal term, File initialDirectory) throws JdiVmCreationException {
        this.owner = owner;
        this.machine = this.localhostSocketLaunch(initialDirectory, term, Bootstrap.virtualMachineManager());
        if (this.machine == null) {
            throw new JdiVmCreationException();
        }
        vmToReferenceMap.put(this.machine, this);
    }

    public synchronized boolean waitForStartup() {
        this.serverThreadStartWait();
        return this.setupServerConnection(this.machine);
    }

    public synchronized void close() {
        if (this.machine != null) {
            this.closeIO();
            try {
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(4));
                this.machine.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void closeIO() {
        if (this.inputStreamRedirector != null) {
            this.inputStreamRedirector.close();
            this.inputStreamRedirector.interrupt();
        }
        if (this.errorStreamRedirector != null) {
            this.errorStreamRedirector.close();
            this.errorStreamRedirector.interrupt();
        }
        if (this.outputStreamRedirector != null) {
            this.outputStreamRedirector.close();
            this.outputStreamRedirector.interrupt();
        }
    }

    void serverClassPrepared() {
        EventRequestManager erm = this.machine.eventRequestManager();
        List<ClassPrepareRequest> list = erm.classPrepareRequests();
        erm.deleteEventRequests(list);
        try {
            this.serverClass = (ClassType)this.findClassByName(SERVER_CLASSNAME, null);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("can't find class bluej.runtime.ExecServer in debug virtual machine");
        }
        this.serverClassAddBreakpoints();
    }

    private void serverClassAddBreakpoints() {
        EventRequestManager erm = this.machine.eventRequestManager();
        Method startedMethod = this.findMethodByName(this.serverClass, SERVER_STARTED_METHOD_NAME);
        if (startedMethod == null) {
            throw new IllegalStateException("can't find method bluej.runtime.ExecServer.vmStarted");
        }
        Location loc = startedMethod.location();
        BreakpointRequest bpreq = erm.createBreakpointRequest(loc);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty(SERVER_STARTED_METHOD_NAME, "yes");
        bpreq.putProperty("dontResume", "yes");
        bpreq.enable();
        Method suspendMethod = this.findMethodByName(this.serverClass, SERVER_SUSPEND_METHOD_NAME);
        if (suspendMethod == null) {
            throw new IllegalStateException("can't find method bluej.runtime.ExecServer.vmSuspend");
        }
        loc = suspendMethod.location();
        bpreq = erm.createBreakpointRequest(loc);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty(SERVER_SUSPEND_METHOD_NAME, "yes");
        bpreq.putProperty("dontResume", "yes");
        bpreq.enable();
    }

    private boolean setupServerConnection(VirtualMachine vm) {
        if (this.serverClass == null) {
            Debug.reportError("server class not initialised!");
            return false;
        }
        this.workerThread = (ThreadReference)this.getStaticFieldObject(this.serverClass, "workerThread");
        if (this.serverThread == null || this.workerThread == null) {
            Debug.reportError("Cannot find fields on remote VM");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoaderReference newClassLoader(URL[] urls) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(3));
            StringBuffer newcpath = new StringBuffer(200);
            int index = 0;
            while (index < urls.length) {
                newcpath.append(urls[index].toString());
                newcpath.append('\n');
                ++index;
            }
            this.setStaticFieldObject(this.serverClass, "classPath", newcpath.toString());
            this.workerThreadReady = false;
            this.workerThread.resume();
            this.workerThreadReadyWait();
            this.currentLoader = (ClassLoaderReference)this.getStaticFieldObject(this.serverClass, "workerReturn");
            return this.currentLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceType loadClass(String className) throws ClassNotFoundException {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(2));
            this.setStaticFieldObject(this.serverClass, "className", className);
            this.workerThreadReady = false;
            this.workerThread.resume();
            this.workerThreadReadyWait();
            ClassObjectReference robject = (ClassObjectReference)this.getStaticFieldObject(this.serverClass, "workerReturn");
            if (robject == null) {
                throw new ClassNotFoundException(className);
            }
            return robject.reflectedType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceType loadClass(String className, ClassLoaderReference clr) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "classLoader", clr);
            try {
                ReferenceType rt = this.loadClass(className);
                return rt;
            }
            catch (Exception cnfe) {
                return null;
            }
        }
    }

    ReferenceType loadInitClass(String className) throws ClassNotFoundException {
        try {
            this.serverThreadStartWait();
            this.setStaticFieldObject(this.serverClass, "classToRun", className);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(5));
            this.serverThreadStarted = false;
            this.resumeServerThread();
            this.serverThreadStartWait();
            ClassObjectReference rval = (ClassObjectReference)this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null) {
                throw new ClassNotFoundException("Remote class not found: " + className);
            }
            ObjectReference exception = this.getStaticFieldObject(this.serverClass, "exception");
            if (exception != null) {
                this.exceptionEvent(new InvocationException(exception));
            }
            return rval.reflectedType();
        }
        catch (VMDisconnectedException vde) {
            throw new ClassNotFoundException("Remote class not loaded due to VM termination.");
        }
    }

    public void runShellClass(String className) throws ClassNotFoundException {
        try {
            this.exitStatus = 0;
            this.invokeShell(className);
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = 3;
        }
        catch (Exception e) {
            Debug.reportError("starting shell class failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
        }
    }

    public JdiObject instantiateClass(String className) {
        ObjectReference obj = null;
        this.exitStatus = 0;
        try {
            obj = this.invokeConstructor(className);
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = 3;
            return null;
        }
        catch (Exception e) {
            Debug.reportError("starting shell class failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
        }
        if (obj == null) {
            return null;
        }
        return JdiObject.getDebuggerObject(obj);
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    public void vmStartEvent(VMStartEvent vmse) {
        this.serverThreadStarted = false;
    }

    public void vmExitEvent() {
        if (this.owner != null) {
            this.owner.vmExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDisconnectEvent() {
        Object object = this;
        synchronized (object) {
            this.owner.vmDisconnect();
            this.exitStatus = 3;
            if (!this.serverThreadStarted) {
                this.notifyAll();
            }
        }
        if (this.workerThread != null) {
            object = this.workerThread;
            synchronized (object) {
                if (!this.workerThreadReady) {
                    this.workerThread.notifyAll();
                }
            }
        }
        object = vmToReferenceMap;
        synchronized (object) {
            vmToReferenceMap.remove(this.machine);
        }
    }

    public void threadStartEvent(ThreadStartEvent tse) {
        this.owner.threadStart(tse.thread());
    }

    public void threadDeathEvent(ThreadDeathEvent tde) {
        ThreadReference tr = tde.thread();
        this.owner.threadDeath(tr);
    }

    public void exceptionEvent(ExceptionEvent exc) {
        Field msgField;
        ObjectReference remoteException = exc.exception();
        StringReference msgVal = (StringReference)remoteException.getValue(msgField = remoteException.referenceType().fieldByName("detailMessage"));
        String exceptionText = msgVal == null ? null : msgVal.value();
        String excClass = exc.exception().type().name();
        List stack = JdiThread.getStack(exc.thread());
        this.exitStatus = 2;
        this.lastException = new ExceptionDescription(excClass, exceptionText, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value safeInvoke(ObjectReference o, Method m, List args) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            Value v = null;
            try {
                v = o.invokeMethod(this.workerThread, m, args, 1);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
            }
            catch (InvalidTypeException invalidTypeException) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (InvocationException invocationException) {
                // empty catch block
            }
            return v;
        }
    }

    public void exceptionEvent(InvocationException exc) {
        Field msgField;
        LinkedList empty = new LinkedList();
        ObjectReference remoteException = exc.exception();
        StringReference msgVal = (StringReference)remoteException.getValue(msgField = remoteException.referenceType().fieldByName("detailMessage"));
        String exceptionText = msgVal == null ? null : msgVal.value();
        String excClass = exc.exception().type().name();
        ReferenceType remoteType = exc.exception().referenceType();
        List<Method> getStackTraceMethods = remoteType.methodsByName("getStackTrace");
        Method getStackTrace = getStackTraceMethods.get(0);
        ArrayReference stackValue = (ArrayReference)this.safeInvoke(exc.exception(), getStackTrace, empty);
        ObjectReference[] stackt = stackValue.getValues().toArray(new ObjectReference[0]);
        LinkedList<SourceLocation> stack = new LinkedList<SourceLocation>();
        if (stackt.length > 0) {
            ReferenceType StackTraceElementType = (ReferenceType)stackt[0].type();
            Method getClassName = StackTraceElementType.methodsByName("getClassName").get(0);
            Method getFileName = StackTraceElementType.methodsByName("getFileName").get(0);
            Method getLineNum = StackTraceElementType.methodsByName("getLineNumber").get(0);
            Method getMethodName = StackTraceElementType.methodsByName("getMethodName").get(0);
            int i = 0;
            while (i < stackt.length) {
                Value classNameV = this.safeInvoke(stackt[i], getClassName, empty);
                Value fileNameV = this.safeInvoke(stackt[i], getFileName, empty);
                Value methodNameV = this.safeInvoke(stackt[i], getMethodName, empty);
                Value lineNumV = this.safeInvoke(stackt[i], getLineNum, empty);
                String className = ((StringReference)classNameV).value();
                String fileName = ((StringReference)fileNameV).value();
                String methodName = ((StringReference)methodNameV).value();
                int lineNumber = ((IntegerValue)lineNumV).value();
                stack.add(new SourceLocation(className, fileName, methodName, lineNumber));
                ++i;
            }
        }
        this.exitStatus = 2;
        this.lastException = new ExceptionDescription(excClass, exceptionText, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointEvent(LocatableEvent event, boolean breakpoint) {
        String fileName;
        if (event.request().getProperty(SERVER_STARTED_METHOD_NAME) != null) {
            VMReference vMReference = this;
            synchronized (vMReference) {
                this.serverThreadStarted = true;
                this.serverThread = event.thread();
                this.owner.raiseStateChangeEvent(2);
                this.notifyAll();
            }
        }
        if (event.request().getProperty(SERVER_SUSPEND_METHOD_NAME) != null) {
            if (this.workerThread == null) {
                this.workerThread = event.thread();
            }
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReady = true;
                this.workerThread.notify();
            }
        }
        if (this.serverThread.equals(event.thread())) {
            this.owner.raiseStateChangeEvent(4);
        }
        Location location = event.location();
        try {
            fileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            fileName = null;
        }
        if (fileName == null || !fileName.startsWith("__SHELL")) {
            this.owner.breakpoint(event.thread(), breakpoint);
        }
    }

    private Location loadClassesAndFindLine(String className, int line) {
        ReferenceType remoteClass = null;
        try {
            remoteClass = this.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        ArrayList allTypesInFile = new ArrayList();
        this.buildNestedTypes(remoteClass, allTypesInFile);
        Iterator it = allTypesInFile.iterator();
        while (it.hasNext()) {
            ReferenceType r = (ReferenceType)it.next();
            try {
                List<Location> list = r.locationsOfLine(line);
                if (list.size() <= 0) continue;
                return list.get(0);
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNestedTypes(ReferenceType rootType, List l) {
        try {
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReadyWait();
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(5));
                this.setStaticFieldObject(this.serverClass, "className", rootType.name());
                this.workerThreadReady = false;
                this.workerThread.resume();
                this.workerThreadReadyWait();
                ObjectReference or = this.getStaticFieldObject(this.serverClass, "workerReturn");
                ArrayReference inners = (ArrayReference)or;
                Iterator<Value> i = inners.getValues().iterator();
                while (i.hasNext()) {
                    ClassObjectReference cor = (ClassObjectReference)i.next();
                    ReferenceType rt = cor.reflectedType();
                    if (!rt.isPrepared()) continue;
                    l.add(rt);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (VMMismatchException vMMismatchException) {
            // empty catch block
        }
    }

    String setBreakpoint(String className, int line) {
        Location location = this.loadClassesAndFindLine(className, line);
        if (location == null) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        EventRequestManager erm = this.machine.eventRequestManager();
        BreakpointRequest bpreq = erm.createBreakpointRequest(location);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty("dontResume", "yes");
        bpreq.enable();
        return null;
    }

    String clearBreakpoint(String className, int line) {
        Location location = this.loadClassesAndFindLine(className, line);
        if (location == null) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
        EventRequestManager erm = this.machine.eventRequestManager();
        boolean found = false;
        List<BreakpointRequest> list = erm.breakpointRequests();
        int i = 0;
        while (i < list.size()) {
            BreakpointRequest bp = list.get(i);
            if (bp.location().equals(location)) {
                erm.deleteEventRequest(bp);
                found = true;
            }
            ++i;
        }
        if (found) {
            return null;
        }
        return Config.getString("debugger.jdiDebugger.noBreakpointMsg");
    }

    public List getBreakpoints() {
        EventRequestManager erm = this.machine.eventRequestManager();
        LinkedList<Location> breaks = new LinkedList<Location>();
        List<BreakpointRequest> allBreakpoints = erm.breakpointRequests();
        Iterator<BreakpointRequest> it = allBreakpoints.iterator();
        while (it.hasNext()) {
            BreakpointRequest bp = it.next();
            if (bp.location().declaringType().classLoader() != this.currentLoader) continue;
            breaks.add(bp.location());
        }
        return breaks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBreakpoints(List saved) {
        EventRequestManager erm = this.machine.eventRequestManager();
        ArrayList<Location> newSaved = new ArrayList<Location>();
        Iterator savedIterator = saved.iterator();
        while (savedIterator.hasNext()) {
            Location oldLocation = (Location)savedIterator.next();
            Location newLocation = this.loadClassesAndFindLine(oldLocation.declaringType().name(), oldLocation.lineNumber());
            if (newLocation == null) continue;
            newSaved.add(newLocation);
        }
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.machine.suspend();
            this.eventHandler.waitQueueEmpty();
            erm.deleteAllBreakpoints();
            this.serverClassAddBreakpoints();
            Iterator it = newSaved.iterator();
            while (it.hasNext()) {
                Location l = (Location)it.next();
                BreakpointRequest bpreq = erm.createBreakpointRequest(l);
                bpreq.setSuspendPolicy(1);
                bpreq.putProperty("dontResume", "yes");
                bpreq.enable();
            }
            this.machine.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverThreadStartWait() {
        VMReference vMReference = this;
        synchronized (vMReference) {
            try {
                while (!this.serverThreadStarted) {
                    if (this.exitStatus == 3) {
                        throw new VMDisconnectedException();
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void resumeServerThread() {
        this.serverThread.resume();
        this.owner.raiseStateChangeEvent(3);
    }

    private void workerThreadReadyWait() {
        try {
            while (!this.workerThreadReady) {
                if (this.exitStatus == 3) {
                    throw new VMDisconnectedException();
                }
                this.workerThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Value invokeShell(String cl) {
        ObjectReference exception;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", cl);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(0));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(exception));
        }
        return rval;
    }

    private ObjectReference invokeConstructor(String className) {
        ObjectReference exception;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", className);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(6));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(exception));
        }
        return rval;
    }

    public Value invokeTestSetup(String cl) throws InvocationException {
        ObjectReference e;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", cl);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(1));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (e = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(e));
            throw new InvocationException(e);
        }
        return rval;
    }

    public Value invokeRunTest(String cl, String method) throws InvocationException {
        ObjectReference e;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", cl);
        this.setStaticFieldObject(this.serverClass, "methodToRun", method);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(2));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (e = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(e));
            throw new InvocationException(e);
        }
        return rval;
    }

    void disposeWindows() {
        this.serverThreadStartWait();
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(3));
        this.serverThreadStarted = false;
        this.resumeServerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObject(String scopeId, String instanceName, ObjectReference object) {
        try {
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReadyWait();
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(1));
                this.setStaticFieldObject(this.serverClass, "objectName", instanceName);
                this.setStaticFieldValue(this.serverClass, "object", object);
                this.setStaticFieldObject(this.serverClass, "scopeId", scopeId);
                this.workerThreadReady = false;
                this.workerThread.resume();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (VMMismatchException vMMismatchException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeObject(String scopeId, String instanceName) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            try {
                this.workerThreadReadyWait();
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(0));
                this.setStaticFieldObject(this.serverClass, "objectName", instanceName);
                this.setStaticFieldObject(this.serverClass, "scopeId", scopeId);
                this.workerThreadReady = false;
                this.workerThread.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    static boolean isAtMainBreakpoint(ThreadReference tr) {
        try {
            return tr.isAtBreakpoint() && SERVER_CLASSNAME.equals(tr.frame(0).location().declaringType().name());
        }
        catch (IncompatibleThreadStateException e) {
            return false;
        }
    }

    ObjectReference getStaticFieldObject(ClassType cl, String fieldName) {
        Field resultField = cl.fieldByName(fieldName);
        if (resultField == null) {
            throw new IllegalArgumentException("getting field " + fieldName + " resulted in no fields");
        }
        return (ObjectReference)cl.getValue(resultField);
    }

    void setStaticFieldValue(ClassType cl, String fieldName, Value value) {
        Field field = cl.fieldByName(fieldName);
        try {
            cl.setValue(field, value);
        }
        catch (InvalidTypeException invalidTypeException) {
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
    }

    void setStaticFieldObject(ClassType cl, String fieldName, String value) {
        try {
            StringReference s = this.machine.mirrorOf(value);
            s.disableCollection();
            this.setStaticFieldValue(cl, fieldName, s);
            s.enableCollection();
        }
        catch (ObjectCollectedException oce) {
            this.machine.suspend();
            StringReference s = this.machine.mirrorOf(value);
            this.setStaticFieldValue(cl, fieldName, s);
            this.machine.resume();
        }
    }

    private ReferenceType findClassByName(String className, ClassLoaderReference clr) throws ClassNotFoundException {
        List<ReferenceType> list = this.machine.classesByName(className);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            Iterator<ReferenceType> iter = list.iterator();
            while (iter.hasNext()) {
                ReferenceType cl = iter.next();
                if (cl.classLoader() != clr) continue;
                return cl;
            }
        }
        throw new ClassNotFoundException(className);
    }

    public ReferenceType findClassByName(String className) throws ClassNotFoundException {
        return this.findClassByName(className, this.currentLoader);
    }

    Method findMethodByName(ClassType type, String methodName) {
        List<Method> list = type.methodsByName(methodName);
        if (list.size() != 1) {
            throw new IllegalArgumentException("getting method " + methodName + " resulted in " + list.size() + " methods");
        }
        return list.get(0);
    }

    private IOHandlerThread redirectIOStream(Reader reader, Writer writer, boolean buffered) {
        IOHandlerThread thr = new IOHandlerThread(reader, writer, buffered);
        thr.setPriority(9);
        thr.start();
        return thr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VMReference getVmForMachine(VirtualMachine mc) {
        Map map = vmToReferenceMap;
        synchronized (map) {
            return (VMReference)vmToReferenceMap.get(mc);
        }
    }

    private class IOHandlerThread
    extends Thread {
        private Reader reader;
        private Writer writer;
        private boolean buffered;
        private volatile boolean keepRunning;

        IOHandlerThread(Reader reader, Writer writer, boolean buffered) {
            super("BlueJ I/O Handler " + (buffered ? "(buffered)" : "(unbuffered)"));
            this.keepRunning = true;
            this.reader = reader;
            this.writer = writer;
            this.buffered = buffered;
        }

        public void close() {
            this.keepRunning = false;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block4: {
                try {
                    if (!this.buffered) ** GOTO lbl14
                    in = new BufferedReader(this.reader);
                    while (this.keepRunning && (line = in.readLine()) != null) {
                        line = String.valueOf(line) + '\n';
                        if (!this.keepRunning) continue;
                        this.writer.write(line.toCharArray(), 0, line.length());
                        this.writer.flush();
                    }
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        if (!this.keepRunning) continue;
                        this.writer.write(ch);
                        this.writer.flush();
lbl14:
                        // 3 sources

                        ** while (this.keepRunning && (ch = this.reader.read()) != -1)
                    }
lbl15:
                    // 1 sources

                }
                catch (IOException var1_3) {
                    // empty catch block
                }
            }
        }
    }
}

