/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.jdi.VMReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;

class VMEventHandler
extends Thread {
    static final String DONT_RESUME = "dontResume";
    private Object syncObj = new Object();
    private VMReference vm;
    private EventQueue queue;
    private boolean queueEmpty;
    volatile boolean exiting = false;

    VMEventHandler(VMReference vm, VirtualMachine vmm) {
        super("vm-event-handler");
        this.vm = vm;
        this.queue = vmm.eventQueue();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.exiting) {
            try {
                EventSet eventSet = this.queue.remove(1L);
                if (eventSet == null) {
                    Object object = this.syncObj;
                    synchronized (object) {
                        this.queueEmpty = true;
                        this.syncObj.notifyAll();
                    }
                    eventSet = this.queue.remove();
                    object = this.syncObj;
                    synchronized (object) {
                        this.queueEmpty = false;
                    }
                }
                boolean addToSuspendCount = true;
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    Event ev = it.nextEvent();
                    this.handleEvent(ev);
                    if (ev.request() == null || !addToSuspendCount || ev.request().getProperty(DONT_RESUME) == null || !(ev instanceof LocatableEvent)) continue;
                    LocatableEvent le = (LocatableEvent)ev;
                    le.thread().suspend();
                    addToSuspendCount = false;
                }
                eventSet.resume();
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.exiting = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitQueueEmpty() {
        Object object = this.syncObj;
        synchronized (object) {
            try {
                while (!this.queueEmpty) {
                    this.syncObj.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void handleEvent(Event event) {
        if (event instanceof VMStartEvent) {
            this.vm.vmStartEvent((VMStartEvent)event);
        } else if (event instanceof VMDeathEvent) {
            this.vm.vmExitEvent();
        } else if (event instanceof VMDisconnectEvent) {
            this.vm.vmDisconnectEvent();
        } else if (event instanceof ExceptionEvent) {
            this.vm.exceptionEvent((ExceptionEvent)event);
        } else if (event instanceof BreakpointEvent) {
            this.vm.breakpointEvent((LocatableEvent)event, true);
        } else if (event instanceof StepEvent) {
            this.vm.breakpointEvent((LocatableEvent)event, false);
        } else if (event instanceof ThreadStartEvent) {
            this.vm.threadStartEvent((ThreadStartEvent)event);
        } else if (event instanceof ThreadDeathEvent) {
            this.vm.threadDeathEvent((ThreadDeathEvent)event);
        } else if (event instanceof ClassPrepareEvent) {
            this.classPrepareEvent(event);
        }
    }

    private boolean classPrepareEvent(Event event) {
        ClassPrepareEvent cle = (ClassPrepareEvent)event;
        ReferenceType refType = cle.referenceType();
        if (refType.name().equals("bluej.runtime.ExecServer")) {
            this.vm.serverClassPrepared();
        }
        return true;
    }
}

