/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiTestResult;
import bluej.debugger.jdi.JdiTestResultError;
import bluej.debugger.jdi.JdiTestResultFailure;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiThreadNode;
import bluej.debugger.jdi.JdiThreadSet;
import bluej.debugger.jdi.JdiThreadTreeModel;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;

public class JdiDebugger
extends Debugger {
    private static final int loaderPriority = 3;
    private volatile boolean vmRunning = false;
    private boolean autoRestart = true;
    private boolean selfRestart = false;
    private VMReference vmRef;
    private MachineLoaderThread machineLoader;
    private Object serverThreadLock = new Object();
    private JdiThreadSet allThreads;
    private JdiThreadTreeModel treeModel;
    private EventListenerList listenerList = new EventListenerList();
    private File startingDirectory;
    private DebuggerTerminal terminal;
    private Set usedNames;
    private boolean hideSystemThreads;
    private int machineState = 1;
    private BPClassLoader lastProjectClassLoader;
    private ExceptionDescription lastException;
    static /* synthetic */ Class class$0;

    public JdiDebugger(File startingDirectory, DebuggerTerminal terminal) {
        this.startingDirectory = startingDirectory;
        this.terminal = terminal;
        this.allThreads = new JdiThreadSet();
        this.treeModel = new JdiThreadTreeModel(new JdiThreadNode());
        this.usedNames = new TreeSet();
        this.hideSystemThreads = true;
    }

    public synchronized void launch() {
        if (this.vmRunning) {
            throw new IllegalStateException("JdiDebugger.launch() was called but the debugger was already loaded");
        }
        if (this.machineLoader != null && !this.selfRestart) {
            return;
        }
        this.autoRestart = true;
        this.raiseStateChangeEvent(1);
        if (!this.selfRestart) {
            this.machineLoader = new MachineLoaderThread();
        }
        this.selfRestart = false;
        this.machineLoader.setPriority(3);
        this.machineLoader.start();
    }

    public synchronized void close(boolean restart) {
        if (this.vmRunning) {
            this.autoRestart = restart;
            this.selfRestart = restart;
            if (this.selfRestart) {
                this.machineLoader = new MachineLoaderThread();
            }
            this.vmRef.close();
        } else if (!restart) {
            this.autoRestart = false;
            this.selfRestart = false;
            this.machineLoader = null;
        }
    }

    public synchronized void addDebuggerListener(DebuggerListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("bluej.debugger.DebuggerListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public synchronized void removeDebuggerListener(DebuggerListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("bluej.debugger.DebuggerListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String guessNewName(String className) {
        String baseName = JavaNames.getBase(className = className.replace('[', ' ').replace(']', ' ').trim());
        int stringEndIndex = baseName.length() > 8 ? 8 : baseName.length();
        String newName = String.valueOf(Character.toLowerCase(baseName.charAt(0))) + baseName.substring(1, stringEndIndex);
        int num = 1;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            while (this.usedNames.contains(String.valueOf(newName) + num)) {
                ++num;
            }
        }
        return String.valueOf(newName) + num;
    }

    public String guessNewName(DebuggerObject obj) {
        String name = null;
        DebuggerClass cls = obj.getClassRef();
        if (cls.isEnum()) {
            ObjectReference val = obj.getObjectReference();
            name = JdiUtils.getJdiUtils().getValueString(val);
        }
        if (name == null) {
            name = cls.getName();
        }
        return this.guessNewName(name);
    }

    public synchronized void newClassLoader(BPClassLoader bpClassLoader) {
        if (bpClassLoader == null) {
            return;
        }
        this.lastProjectClassLoader = bpClassLoader;
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            this.usedNames.clear();
            try {
                vmr.newClassLoader(bpClassLoader.getURLs());
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public synchronized void newClassLoaderLeavingBreakpoints(BPClassLoader bpClassLoader) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            List savedBreakpoints = vmr.getBreakpoints();
            this.newClassLoader(bpClassLoader);
            this.getVM().restoreBreakpoints(savedBreakpoints);
        } else {
            this.newClassLoader(bpClassLoader);
        }
    }

    public synchronized boolean addObject(String scopeId, String newInstanceName, DebuggerObject dob) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.addObject(scopeId, newInstanceName, ((JdiObject)dob).getObjectReference());
            this.usedNames.add(newInstanceName);
        }
        return true;
    }

    public void removeObject(String scopeId, String instanceName) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.removeObject(scopeId, instanceName);
        }
    }

    public Map getObjects() {
        throw new IllegalStateException("not implemented");
    }

    public int getStatus() {
        return this.machineState;
    }

    public DebuggerObject getStaticValue(String className, String fieldName) throws ClassNotFoundException {
        try {
            VMReference vmr = this.getVMNoWait();
            if (vmr != null) {
                ClassType rt = (ClassType)vmr.findClassByName(className);
                Field f = rt.fieldByName(fieldName);
                if (f == null) {
                    return null;
                }
                ObjectReference ob = vmr.getStaticFieldObject(rt, fieldName);
                JavaType expectedType = JdiReflective.fromField(f, rt);
                if (ob != null) {
                    return JdiObject.getDebuggerObject(ob, expectedType);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return null;
    }

    public int getExitStatus() {
        VMReference vmr = this.getVMNoWait();
        if (vmr == null) {
            return 3;
        }
        this.lastException = vmr.getException();
        return vmr.getExitStatus();
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    public DebuggerThreadTreeModel getThreadTreeModel() {
        return this.treeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map runTestSetUp(String className) {
        ArrayReference arrayRef = null;
        HashMap<String, JdiObject> returnMap = new HashMap<String, JdiObject>();
        VMReference vmr = this.getVM();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeTestSetup(className);
                }
            }
            if (arrayRef != null) {
                ObjectReference testObject = (ObjectReference)arrayRef.getValue(arrayRef.length() - 1);
                JdiObject jdiTestObject = JdiObject.getDebuggerObject(testObject);
                int i = 0;
                while (i < arrayRef.length() - 1) {
                    String fieldName = ((StringReference)arrayRef.getValue(i)).value();
                    Field testField = testObject.referenceType().fieldByName(fieldName);
                    returnMap.put(fieldName, JdiObject.getDebuggerObject((ObjectReference)arrayRef.getValue(i + 1), testField, jdiTestObject));
                    i += 2;
                }
            }
        }
        catch (InvocationException e) {
            return null;
        }
        catch (VMDisconnectedException e) {
            return null;
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerTestResult runTestMethod(String className, String methodName) {
        ArrayReference arrayRef = null;
        try {
            VMReference vmr = this.getVM();
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeRunTest(className, methodName);
                }
            }
            if (arrayRef != null && arrayRef.length() > 5) {
                String failureType = ((StringReference)arrayRef.getValue(0)).value();
                String exMsg = ((StringReference)arrayRef.getValue(1)).value();
                String traceMsg = ((StringReference)arrayRef.getValue(2)).value();
                String failureClass = ((StringReference)arrayRef.getValue(3)).value();
                String failureSource = ((StringReference)arrayRef.getValue(4)).value();
                String failureMethod = ((StringReference)arrayRef.getValue(5)).value();
                int lineNo = Integer.parseInt(((StringReference)arrayRef.getValue(6)).value());
                SourceLocation failPoint = new SourceLocation(failureClass, failureSource, failureMethod, lineNo);
                if (failureType.equals("failure")) {
                    return new JdiTestResultFailure(className, methodName, exMsg, traceMsg, failPoint);
                }
                return new JdiTestResultError(className, methodName, exMsg, traceMsg, failPoint);
            }
        }
        catch (InvocationException ie) {
            return new JdiTestResultError(className, methodName, "Internal invocation error", "", null);
        }
        catch (VMDisconnectedException vmde) {
            return new JdiTestResultError(className, methodName, "VM restarted", "", null);
        }
        return new JdiTestResult(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeWindows() {
        VMReference vmr = this.getVMNoWait();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    vmr.disposeWindows();
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runClassMain(String className) throws ClassNotFoundException {
        VMReference vmr = this.getVM();
        Object object = this.serverThreadLock;
        synchronized (object) {
            if (vmr != null) {
                vmr.runShellClass(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerObject instantiateClass(String className) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerClass getClass(String className) throws ClassNotFoundException {
        ReferenceType classMirror;
        VMReference vmr = this.getVM();
        if (vmr == null) {
            throw new ClassNotFoundException("Virtual machine terminated.");
        }
        Object object = this.serverThreadLock;
        synchronized (object) {
            classMirror = this.machineState != 3 ? vmr.loadInitClass(className) : vmr.loadClass(className);
        }
        return new JdiClass(classMirror);
    }

    private void fireTargetEvent(DebuggerEvent ce) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("bluej.debugger.DebuggerListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((DebuggerListener)listeners[i + 1]).debuggerEvent(ce);
            }
            i -= 2;
        }
    }

    void raiseStateChangeEvent(int newState) {
        if (newState != this.machineState) {
            if (this.machineState == 3 && newState == 1) {
                this.fireTargetEvent(new DebuggerEvent(this, 1, 3, 2));
                this.machineState = 2;
            }
            int oldState = this.machineState;
            this.machineState = newState;
            this.fireTargetEvent(new DebuggerEvent(this, 1, oldState, newState));
        }
    }

    void raiseRemoveStepMarksEvent() {
        this.fireTargetEvent(new DebuggerEvent(this, 2));
    }

    public String toggleBreakpoint(String className, int line, boolean set) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, line);
                }
                return vmr.clearBreakpoint(className, line);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    public void breakpoint(final ThreadReference tr, boolean bp) {
        final JdiThread breakThread = this.allThreads.find(tr);
        this.treeModel.syncExec(new Runnable(){

            public void run() {
                JdiThreadNode jtn = JdiDebugger.this.treeModel.findThreadNode(tr);
                if (jtn == null) {
                    JdiThreadNode root = JdiDebugger.this.treeModel.getThreadRoot();
                    JdiDebugger.this.treeModel.insertNodeInto(new JdiThreadNode(breakThread), root, 0);
                } else {
                    JdiDebugger.this.treeModel.nodeChanged(jtn);
                }
            }
        });
        if (bp) {
            this.fireTargetEvent(new DebuggerEvent(this, 4, breakThread));
        } else {
            this.fireTargetEvent(new DebuggerEvent(this, 3, breakThread));
        }
    }

    void vmExit() {
    }

    synchronized void vmDisconnect() {
        if (this.autoRestart) {
            this.allThreads.clear();
            if (this.vmRunning) {
                if (!this.selfRestart) {
                    this.machineLoader = new MachineLoaderThread();
                }
                this.vmRunning = false;
                this.selfRestart = true;
                this.vmRef.closeIO();
                this.vmRef = null;
                this.launch();
                this.raiseRemoveStepMarksEvent();
                this.raiseStateChangeEvent(1);
                this.usedNames.clear();
                this.treeModel.syncExec(new Runnable(){

                    public void run() {
                        JdiDebugger.this.treeModel.setRoot(new JdiThreadNode());
                        JdiDebugger.this.treeModel.reload();
                    }
                });
            }
        }
    }

    void threadStart(ThreadReference tr) {
        final JdiThread newThread = new JdiThread(this.treeModel, tr);
        this.allThreads.add(newThread);
        this.treeModel.syncExec(new Runnable(){

            public void run() {
                JdiDebugger.this.displayThread(newThread);
            }
        });
    }

    void threadDeath(final ThreadReference tr) {
        this.allThreads.removeThread(tr);
        this.treeModel.syncExec(new Runnable(){

            public void run() {
                JdiThreadNode jtn = JdiDebugger.this.treeModel.findThreadNode(tr);
                if (jtn != null) {
                    JdiDebugger.this.treeModel.removeNodeFromParent(jtn);
                }
            }
        });
    }

    public void hideSystemThreads(boolean hide) {
        if (this.hideSystemThreads == hide) {
            return;
        }
        this.hideSystemThreads = hide;
        this.updateThreadDisplay();
    }

    private void updateThreadDisplay() {
        this.treeModel.setRoot(new JdiThreadNode());
        Iterator it = this.allThreads.iterator();
        while (it.hasNext()) {
            JdiThread currentThread = (JdiThread)it.next();
            this.displayThread(currentThread);
        }
        this.treeModel.reload();
    }

    private void displayThread(JdiThread newThread) {
        if (!this.hideSystemThreads || !newThread.isKnownSystemThread()) {
            JdiThreadNode root = this.treeModel.getThreadRoot();
            this.treeModel.insertNodeInto(new JdiThreadNode(newThread), root, 0);
        }
    }

    private VMReference getVM() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVM();
    }

    private VMReference getVMNoWait() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVMNoWait();
    }

    class MachineLoaderThread
    extends Thread {
        MachineLoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                JdiDebugger.this.vmRef = new VMReference(JdiDebugger.this, JdiDebugger.this.terminal, JdiDebugger.this.startingDirectory);
                object = JdiDebugger.this;
                synchronized (object) {
                    if (JdiDebugger.this.vmRef.getExitStatus() != 3) {
                        if (JdiDebugger.this.autoRestart) {
                            JdiDebugger.this.vmRef.newClassLoader(JdiDebugger.this.lastProjectClassLoader.getURLs());
                            JdiDebugger.this.vmRunning = true;
                            JdiDebugger.this.raiseStateChangeEvent(2);
                        } else {
                            JdiDebugger.this.vmRef.close();
                        }
                    }
                }
            }
            catch (JdiVmCreationException e) {
                JdiDebugger.this.raiseStateChangeEvent(5);
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }

        private synchronized VMReference getVM() {
            while (!JdiDebugger.this.vmRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return JdiDebugger.this.autoRestart ? JdiDebugger.this.vmRef : null;
        }

        private synchronized VMReference getVMNoWait() {
            if (!JdiDebugger.this.vmRunning) {
                return null;
            }
            return JdiDebugger.this.vmRef;
        }
    }
}

