/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.JavaType;
import java.util.Map;

public class JavaPrimitiveType
extends JavaType {
    private static JavaPrimitiveType[] primitiveTypes = new JavaPrimitiveType[JavaType.JT_MAX + 1];
    private static String[] typeNames = new String[]{"void", "java.lang.Object", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static int[][] assignableFrom = new int[JT_MAX + 1][];
    private int myIndex;

    protected JavaPrimitiveType(int index) {
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_VOID] = new int[0];
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_NULL] = new int[0];
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_BOOLEAN] = new int[]{JT_BOOLEAN};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_CHAR] = new int[]{JT_CHAR};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_BYTE] = new int[]{JT_BYTE};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_SHORT] = new int[]{JT_SHORT, JT_BYTE};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_INT] = new int[]{JT_INT, JT_BYTE, JT_SHORT, JT_CHAR};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_LONG] = new int[]{JT_LONG, JT_BYTE, JT_SHORT, JT_CHAR, JT_INT};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_FLOAT] = new int[]{JT_FLOAT, JT_LONG, JT_BYTE, JT_SHORT, JT_CHAR, JT_INT, JT_LONG};
        JavaPrimitiveType.assignableFrom[JavaPrimitiveType.JT_DOUBLE] = new int[]{JT_DOUBLE, JT_LONG, JT_BYTE, JT_SHORT, JT_CHAR, JT_INT, JT_LONG, JT_FLOAT};
        this.myIndex = index;
    }

    private static JavaPrimitiveType getType(int v) {
        if (primitiveTypes[v] == null) {
            JavaPrimitiveType.primitiveTypes[v] = new JavaPrimitiveType(v);
        }
        return primitiveTypes[v];
    }

    public static JavaPrimitiveType getVoid() {
        return JavaPrimitiveType.getType(JT_VOID);
    }

    public static JavaPrimitiveType getNull() {
        return JavaPrimitiveType.getType(JT_NULL);
    }

    public static JavaPrimitiveType getBoolean() {
        return JavaPrimitiveType.getType(JT_BOOLEAN);
    }

    public static JavaPrimitiveType getByte() {
        return JavaPrimitiveType.getType(JT_BYTE);
    }

    public static JavaPrimitiveType getChar() {
        return JavaPrimitiveType.getType(JT_CHAR);
    }

    public static JavaPrimitiveType getShort() {
        return JavaPrimitiveType.getType(JT_SHORT);
    }

    public static JavaPrimitiveType getInt() {
        return JavaPrimitiveType.getType(JT_INT);
    }

    public static JavaPrimitiveType getLong() {
        return JavaPrimitiveType.getType(JT_LONG);
    }

    public static JavaPrimitiveType getFloat() {
        return JavaPrimitiveType.getType(JT_FLOAT);
    }

    public static JavaPrimitiveType getDouble() {
        return JavaPrimitiveType.getType(JT_DOUBLE);
    }

    public String toString() {
        return typeNames[this.myIndex];
    }

    public String arrayComponentName() {
        return "!!ZCBSIJFD".substring(this.myIndex, this.myIndex + 1);
    }

    public boolean isAssignableFrom(JavaType o) {
        int[] assignables = assignableFrom[this.myIndex];
        int i = 0;
        while (i < assignables.length) {
            if (o.typeIs(assignables[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean couldHold(int n) {
        if (this.myIndex >= JT_INT) {
            return true;
        }
        if (this.myIndex == JT_BYTE) {
            return n >= -128 && n <= 127;
        }
        if (this.myIndex == JT_CHAR) {
            return n >= 0 && n <= 65535;
        }
        if (this.myIndex == JT_SHORT) {
            return n >= Short.MIN_VALUE && n <= Short.MAX_VALUE;
        }
        return false;
    }

    public boolean fitsType(int gtype) {
        if (this.myIndex == JT_CHAR) {
            return gtype != JT_BYTE && gtype != JT_SHORT;
        }
        return gtype >= this.myIndex;
    }

    public JavaType getErasedType() {
        return this;
    }

    public boolean isAssignableFromRaw(JavaType t) {
        return this.isAssignableFrom(t);
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isNumeric() {
        return this.myIndex >= JT_LOWEST_NUMERIC;
    }

    public boolean isIntegralType() {
        return this.myIndex >= JT_CHAR && this.myIndex <= JT_LONG;
    }

    public boolean typeIs(int v) {
        return this.myIndex == v;
    }

    public JavaType mapTparsToTypes(Map tparams) {
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof JavaType) {
            JavaType gto = (JavaType)other;
            return gto.typeIs(this.myIndex);
        }
        return false;
    }

    protected final int getMyIndex() {
        return this.myIndex;
    }

    public JavaType opBNot() {
        if (this.myIndex >= JT_CHAR && this.myIndex <= JT_LONG) {
            return this;
        }
        return null;
    }
}

