/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.utility.Debug;
import java.util.ArrayList;
import java.util.Map;

public class GenTypeWildcard
extends GenTypeParameterizable {
    GenTypeSolid upperBound;
    GenTypeSolid lowerBound;

    public GenTypeWildcard(GenTypeSolid upper, GenTypeSolid lower) {
        this.upperBound = upper;
        this.lowerBound = lower;
    }

    public GenTypeWildcard(GenTypeSolid[] uppers, GenTypeSolid[] lowers) {
        if (uppers.length != 0) {
            this.upperBound = IntersectionType.getIntersection(uppers);
        }
        if (lowers.length != 0) {
            this.lowerBound = GenTypeSolid.lub(lowers);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(NameTransform nt) {
        String uboundStr;
        if (this.lowerBound != null) {
            return "? super " + this.lowerBound.toString(nt);
        }
        if (this.upperBound != null && !(uboundStr = this.upperBound.toString()).equals("java.lang.Object")) {
            return "? extends " + this.upperBound.toString(nt);
        }
        return "?";
    }

    public String toTypeArgString(NameTransform nt) {
        return this.toString(nt);
    }

    public String arrayComponentName() {
        return this.getErasedType().arrayComponentName();
    }

    public JavaType mapTparsToTypes(Map tparams) {
        GenTypeParameterizable newUpper = null;
        GenTypeSolid newLower = null;
        if (this.upperBound != null) {
            ArrayList<GenTypeParameterizable> newUppers = new ArrayList<GenTypeParameterizable>();
            GenTypeSolid[] upperBounds = this.upperBound.getUpperBounds();
            int i = 0;
            while (i < upperBounds.length) {
                GenTypeParameterizable newBound = (GenTypeParameterizable)upperBounds[i].mapTparsToTypes(tparams);
                if (newBound instanceof GenTypeWildcard) {
                    GenTypeWildcard newWcBound = (GenTypeWildcard)newBound;
                    newUppers.add(newWcBound.upperBound);
                } else {
                    newUppers.add(newBound);
                }
                ++i;
            }
            GenTypeSolid[] newUppersA = newUppers.toArray(new GenTypeSolid[newUppers.size()]);
            newUpper = IntersectionType.getIntersection(newUppersA);
        }
        if (this.lowerBound != null) {
            GenTypeParameterizable newLowerP = (GenTypeParameterizable)this.lowerBound.mapTparsToTypes(tparams);
            newLower = newLowerP.getLowerBound();
        }
        if (newUpper != null && newUpper.equals(newLower)) {
            return newUpper;
        }
        return new GenTypeWildcard((GenTypeSolid)newUpper, newLower);
    }

    public boolean equals(GenTypeParameterizable other) {
        if (this == other) {
            return true;
        }
        GenTypeSolid otherLower = other.getLowerBound();
        GenTypeSolid otherUpper = other.getUpperBound();
        if (this.upperBound != null && !this.upperBound.equals(otherUpper)) {
            return false;
        }
        if (this.upperBound == null && otherUpper != null) {
            return false;
        }
        if (this.lowerBound != null && !this.lowerBound.equals(otherLower)) {
            return false;
        }
        return this.lowerBound != null || otherLower == null;
    }

    public void getParamsFromTemplate(Map map, GenTypeParameterizable template) {
        Debug.reportError("getParamsFromTemplate called on GenTypeWildcard.");
    }

    public JavaType getErasedType() {
        return this.upperBound.getErasedType();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isAssignableFrom(JavaType t) {
        return false;
    }

    public boolean isAssignableFromRaw(JavaType t) {
        return false;
    }

    public GenTypeSolid[] getUpperBounds() {
        return this.upperBound.getUpperBounds();
    }

    public GenTypeSolid getUpperBound() {
        return this.upperBound;
    }

    public GenTypeSolid getLowerBound() {
        return this.lowerBound;
    }

    public boolean contains(GenTypeParameterizable other) {
        GenTypeSolid otherUpper = other.getUpperBound();
        GenTypeSolid otherLower = other.getLowerBound();
        if (!(this.upperBound == null || otherUpper != null && this.upperBound.isAssignableFrom(otherUpper))) {
            return false;
        }
        return this.lowerBound == null || otherLower != null && otherLower.isAssignableFrom(this.lowerBound);
    }
}

