/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class GenTypeSolid
extends GenTypeParameterizable {
    public abstract String toString(NameTransform var1);

    public String toString() {
        return this.toString(false);
    }

    public boolean isPrimitive() {
        return false;
    }

    public abstract boolean isInterface();

    public abstract void erasedSuperTypes(Set var1);

    public abstract GenTypeClass[] getReferenceSupertypes();

    public abstract void getParamsFromTemplate(Map var1, GenTypeParameterizable var2);

    public GenTypeSolid[] getUpperBounds() {
        return new GenTypeSolid[]{this};
    }

    public GenTypeSolid getUpperBound() {
        return this;
    }

    public GenTypeSolid getLowerBound() {
        return this;
    }

    public static GenTypeSolid lub(GenTypeSolid[] ubounds) {
        Stack btstack = new Stack();
        return GenTypeSolid.lub(ubounds, btstack);
    }

    private static GenTypeSolid lub(GenTypeSolid[] ubounds, Stack lubBt) {
        ArrayList<GenTypeClass> l = new ArrayList<GenTypeClass>();
        Reflective[] mec = GenTypeSolid.minimalErasedCandidateSet(ubounds);
        int i = 0;
        while (i < mec.length) {
            l.add(GenTypeSolid.Candidate(mec[i], ubounds, lubBt));
            ++i;
        }
        GenTypeSolid[] intersecting = l.toArray(new GenTypeSolid[l.size()]);
        return IntersectionType.getIntersection(intersecting);
    }

    private static GenTypeClass Candidate(Reflective t, GenTypeSolid[] ubounds, Stack lubBt) {
        GenTypeClass[] ri = GenTypeSolid.relevantInvocations(t, ubounds);
        return GenTypeSolid.leastContainingInvocation(ri, lubBt);
    }

    private static GenTypeClass leastContainingInvocation(GenTypeClass[] types, Stack lubBt) {
        int i;
        boolean breakRecursion = false;
        Iterator si = lubBt.iterator();
        while (si.hasNext()) {
            GenTypeSolid[] sbounds = (GenTypeSolid[])si.next();
            i = 0;
            while (i < sbounds.length) {
                if (!sbounds[i].equals(types[i])) break;
                ++i;
            }
            boolean bl = breakRecursion = i == sbounds.length;
        }
        lubBt.push(types);
        GenTypeClass rtype = types[0];
        i = 1;
        while (i < types.length) {
            rtype = GenTypeSolid.leastContainingInvocation(rtype, types[i], lubBt, breakRecursion);
            ++i;
        }
        lubBt.pop();
        return rtype;
    }

    private static GenTypeClass leastContainingInvocation(GenTypeClass a, GenTypeClass b, Stack lubBt, boolean breakRecursion) {
        if (!a.getReflective().getName().equals(b.getReflective().getName())) {
            throw new IllegalArgumentException("Class types must be the same.");
        }
        if (a.isRaw() || b.isRaw()) {
            return a.isRaw() ? a : b;
        }
        int arrCount = 0;
        GenTypeClass origA = a;
        while (a.getArrayComponent() != null) {
            a = a.getArrayComponent().asClass();
            b = b.getArrayComponent().asClass();
            if (a == null) {
                return origA;
            }
            ++arrCount;
        }
        ArrayList<GenTypeUnbounded> lc = new ArrayList<GenTypeUnbounded>();
        Iterator i = a.getTypeParamList().iterator();
        Iterator j = b.getTypeParamList().iterator();
        GenTypeClass oa = a.getOuterType();
        GenTypeClass ob = b.getOuterType();
        GenTypeClass oc = null;
        if (oa != null && ob != null) {
            oc = GenTypeSolid.leastContainingInvocation(oa, ob, lubBt, breakRecursion);
        }
        while (i.hasNext()) {
            GenTypeParameterizable atype = (GenTypeParameterizable)i.next();
            GenTypeParameterizable btype = (GenTypeParameterizable)j.next();
            GenTypeParameterizable rtype = !breakRecursion ? GenTypeSolid.leastContainingTypeArgument(atype, btype, lubBt) : new GenTypeUnbounded();
            lc.add((GenTypeUnbounded)rtype);
        }
        GenTypeClass rval = new GenTypeClass(a.getReflective(), lc, oc);
        while (arrCount-- > 0) {
            rval = new GenTypeArray(rval, rval.getReflective().getArrayOf());
        }
        return rval;
    }

    private static GenTypeParameterizable leastContainingTypeArgument(GenTypeParameterizable a, GenTypeParameterizable b, Stack lubBt) {
        GenTypeClass ac = a.asClass();
        GenTypeClass bc = b.asClass();
        if (ac != null && bc != null) {
            if (ac.equals(bc)) {
                return ac;
            }
            return GenTypeSolid.lub(new GenTypeClass[]{ac, bc}, lubBt);
        }
        if (ac != null || bc != null) {
            GenTypeSolid lbound;
            if (ac == null) {
                ac = bc;
                b = a;
            }
            if ((lbound = b.getLowerBound()) != null) {
                return new GenTypeWildcard(null, IntersectionType.getIntersection(lbound, ac));
            }
        }
        GenTypeSolid lboundsa = a.getLowerBound();
        GenTypeSolid lboundsb = b.getLowerBound();
        if (lboundsa != null && lboundsb != null) {
            return new GenTypeWildcard(null, IntersectionType.getIntersection(lboundsa, lboundsb));
        }
        if (lboundsa != null || lboundsb != null) {
            if (a.equals(b)) {
                return a;
            }
            return new GenTypeUnbounded();
        }
        GenTypeSolid[] uboundsa = a.getUpperBounds();
        GenTypeSolid[] uboundsb = b.getUpperBounds();
        GenTypeSolid[] args = new GenTypeClass[uboundsa.length + uboundsb.length];
        System.arraycopy(uboundsa, 0, args, 0, uboundsa.length);
        System.arraycopy(uboundsb, 0, args, uboundsa.length, uboundsb.length);
        return GenTypeSolid.lub(args);
    }

    private static Reflective[] minimalErasedCandidateSet(GenTypeSolid[] types) {
        HashSet rset = new HashSet();
        types[0].erasedSuperTypes(rset);
        int i = 1;
        while (i < types.length) {
            HashSet rset2 = new HashSet();
            types[i].erasedSuperTypes(rset2);
            Iterator j = rset2.iterator();
            while (j.hasNext()) {
                if (rset.contains(j.next())) continue;
                j.remove();
            }
            rset = rset2;
            ++i;
        }
        Iterator i2 = rset.iterator();
        block2: while (i2.hasNext()) {
            Iterator j = rset.iterator();
            Reflective ri = (Reflective)i2.next();
            while (j.hasNext()) {
                Reflective ji = (Reflective)j.next();
                if (ri == ji || !ri.isAssignableFrom(ji)) continue;
                i2.remove();
                continue block2;
            }
        }
        Reflective[] rval = new Reflective[rset.size()];
        rset.toArray(rval);
        return rval;
    }

    private static GenTypeClass[] relevantInvocations(Reflective r, GenTypeSolid[] ubounds) {
        ArrayList<GenTypeClass> rlist = new ArrayList<GenTypeClass>();
        int i = 0;
        while (i < ubounds.length) {
            GenTypeClass[] blist = ubounds[i].getReferenceSupertypes();
            int j = 0;
            while (j < blist.length) {
                rlist.add(blist[j].mapToSuper(r.getName()));
                ++j;
            }
            ++i;
        }
        return rlist.toArray(new GenTypeClass[rlist.size()]);
    }
}

