/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.CompilerThread;
import bluej.compiler.JavacCompiler;
import bluej.compiler.JavacCompilerInternal;
import bluej.compiler.JikesCompiler;
import bluej.compiler.Job;
import bluej.utility.Debug;
import java.io.File;

public class JobQueue {
    private static JobQueue queue = null;
    private CompilerThread thread = null;
    private Compiler compiler = null;

    public static synchronized JobQueue getJobQueue() {
        if (queue == null) {
            queue = new JobQueue();
        }
        return queue;
    }

    private JobQueue() {
        String compilertype = Config.getPropString("bluej.compiler.type");
        if (compilertype.equals("internal")) {
            this.compiler = new JavacCompilerInternal();
        } else if (compilertype.equals("javac")) {
            this.compiler = new JavacCompiler(Config.getJDKExecutablePath("bluej.compiler.executable", "javac"));
        } else if (compilertype.equals("jikes")) {
            this.compiler = new JikesCompiler(Config.getPropString("bluej.compiler.executable", "jikes"));
        } else {
            Debug.message(Config.getString("compiler.invalidcompiler"));
        }
        this.thread = new CompilerThread();
        int priority = Thread.currentThread().getPriority() - 1;
        if (priority < 1) {
            priority = 1;
        }
        this.thread.setPriority(Thread.currentThread().getPriority() - 1);
        this.thread.start();
    }

    public void addJob(File[] sources, CompileObserver observer, BPClassLoader bpClassLoader, File destDir, boolean suppressUnchecked) {
        this.thread.addJob(new Job(sources, this.compiler, observer, bpClassLoader, destDir, suppressUnchecked));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForEmptyQueue() {
        CompilerThread compilerThread = this.thread;
        synchronized (compilerThread) {
            while (true) {
                if (!this.thread.isBusy()) {
                    return;
                }
                try {
                    this.thread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

