/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import java.io.File;

class Job {
    Compiler compiler;
    CompileObserver observer;
    File destDir;
    BPClassLoader bpClassLoader;
    File[] sources;
    boolean internal;

    public Job(File[] sourceFiles, Compiler compiler, CompileObserver observer, BPClassLoader bpClassLoader, File destDir, boolean internal) {
        this.sources = sourceFiles;
        this.compiler = compiler;
        this.observer = observer;
        this.bpClassLoader = bpClassLoader;
        this.destDir = destDir;
        this.internal = internal;
    }

    public void compile() {
        try {
            boolean successful = true;
            if (this.observer != null) {
                this.observer.startCompile(this.sources);
            }
            if (this.destDir != null) {
                this.compiler.setDestDir(this.destDir);
            }
            this.compiler.setProjectClassLoader(this.bpClassLoader);
            successful = this.compiler.compile(this.sources, this.observer, this.internal);
            if (this.observer != null) {
                this.observer.endCompile(this.sources, successful);
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Config.getString("compileException")) + ": " + e);
            e.printStackTrace();
        }
    }
}

