/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.utility.DialogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

class JikesCompiler
extends Compiler {
    String executable;

    public JikesCompiler(String executable) {
        this.executable = executable;
        this.setDebug(true);
        this.setDeprecation(true);
    }

    public boolean compile(File[] sources, CompileObserver watcher, boolean internal) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.executable);
        args.add("-nowarn");
        args.add("+D");
        args.add("-Xstdout");
        if (this.getDestDir() != null) {
            args.add("-d");
            args.add(this.getDestDir());
        }
        if (this.getProjectClassLoader() != null) {
            args.add("-classpath");
            args.add(String.valueOf(this.getProjectClassLoader().getClassPathAsString()) + File.pathSeparator + System.getProperty("sun.boot.class.path"));
        }
        if (this.isDebug()) {
            args.add("-g");
        }
        if (this.isDeprecation()) {
            args.add("-deprecation");
        }
        int i = 0;
        while (i < sources.length) {
            args.add(sources[i].getPath());
            ++i;
        }
        int length = args.size();
        String[] params = new String[length];
        args.toArray(params);
        boolean result = false;
        try {
            result = this.executeCompiler(params, watcher);
        }
        catch (Exception ioe) {
            DialogManager.showErrorWithText(null, "cannot-run-compiler", this.executable);
        }
        return result;
    }

    private boolean executeCompiler(String[] params, CompileObserver watcher) throws IOException, InterruptedException {
        String line;
        int processresult = 0;
        boolean readerror = false;
        Process compiler = Runtime.getRuntime().exec(params);
        BufferedReader d = new BufferedReader(new InputStreamReader(compiler.getInputStream()));
        while ((line = d.readLine()) != null) {
            int second_colon;
            int first_colon = line.indexOf(58, 0);
            if (first_colon == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", line);
                break;
            }
            String filename = line.substring(0, first_colon);
            if (!filename.endsWith(".java")) {
                if ((first_colon = line.indexOf(58, first_colon + 1)) == -1) {
                    DialogManager.showErrorWithText(null, "compiler-error", line);
                    break;
                }
                filename = line.substring(0, first_colon);
            }
            if ((second_colon = line.indexOf(58, first_colon + 1)) == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", line);
                break;
            }
            int lineNo = 0;
            try {
                lineNo = Integer.parseInt(line.substring(first_colon + 1, second_colon));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            line = line.substring(second_colon + 1);
            if (line.indexOf("arning:") != -1) continue;
            readerror = true;
            watcher.errorMessage(filename, lineNo, line);
            break;
        }
        while ((line = d.readLine()) != null) {
        }
        processresult = compiler.waitFor();
        return processresult == 0 && !readerror;
    }
}

