/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.utility.DialogManager;
import java.io.PrintStream;

class JavacErrorStream
extends PrintStream {
    private boolean haserror = false;
    private boolean hasfollowup = false;
    private boolean hasWarnings = false;
    private int ignoreCount = 0;
    private String filename;
    private String message;
    private String warning = "";
    private int lineno;
    private boolean internal;

    public JavacErrorStream(boolean internal) {
        super(System.err);
        this.internal = internal;
    }

    public void reset() {
        this.haserror = false;
        this.hasfollowup = false;
        this.hasWarnings = false;
        this.ignoreCount = 0;
        this.warning = "";
    }

    public boolean hasError() {
        return this.haserror;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNo() {
        return this.lineno;
    }

    public String getMessage() {
        return this.message;
    }

    public String getWarning() {
        return this.warning;
    }

    public void print(String msg) {
        int second_colon;
        if (this.haserror) {
            return;
        }
        if (this.ignoreCount > 0) {
            --this.ignoreCount;
            return;
        }
        if (this.hasfollowup) {
            int colonPoint = 9;
            String label = msg.substring(0, colonPoint);
            String info = msg.substring(colonPoint).trim();
            if (label.equals("found   :")) {
                this.message = String.valueOf(this.message) + " - found " + info;
            } else if (label.equals("required:")) {
                this.message = String.valueOf(this.message) + " but expected " + info;
                this.haserror = true;
            } else if (label.equals("symbol  :")) {
                this.message = String.valueOf(this.message) + " - " + info;
                this.haserror = true;
            } else {
                this.haserror = true;
            }
            return;
        }
        int first_colon = msg.indexOf(58, 0);
        if (first_colon == -1) {
            if (msg.trim().endsWith("warnings") || msg.trim().endsWith("warning")) {
                this.warning = String.valueOf(this.warning) + msg;
                this.hasWarnings = true;
                return;
            }
            DialogManager.showErrorWithText(null, "compiler-error", msg);
            return;
        }
        this.filename = msg.substring(0, first_colon);
        if (this.filename.equals("Note")) {
            if (this.internal) {
                return;
            }
            this.warning = String.valueOf(this.warning) + msg;
            this.hasWarnings = true;
            return;
        }
        if (!this.filename.endsWith(".java")) {
            if ((first_colon = msg.indexOf(58, first_colon + 1)) == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", msg);
                return;
            }
            this.filename = msg.substring(0, first_colon);
        }
        if ((second_colon = msg.indexOf(58, first_colon + 1)) == -1) {
            DialogManager.showErrorWithText(null, "compiler-error", msg);
            return;
        }
        this.lineno = 0;
        try {
            this.lineno = Integer.parseInt(msg.substring(first_colon + 1, second_colon));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.message = msg.substring(second_colon + 1).trim();
        if (this.message.startsWith("warning:")) {
            this.warning = String.valueOf(this.warning) + msg;
            this.ignoreCount = 2;
            if (this.message.startsWith("warning: [unchecked] unchecked cast")) {
                this.ignoreCount = 4;
            }
            if (!this.hasWarnings) {
                this.hasWarnings = true;
            }
            return;
        }
        if (this.message.equals("cannot resolve symbol") || this.message.equals("cannot find symbol") || this.message.equals("incompatible types")) {
            this.hasfollowup = true;
        } else {
            this.haserror = true;
        }
    }

    public void println(String msg) {
        this.print(msg);
    }

    public void write(byte[] buf, int off, int len) {
        this.print(new String(buf, off, len));
    }
}

