/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.CompilerWarningDialog;
import bluej.compiler.JavacErrorStream;
import bluej.utility.Debug;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;

class JavacCompilerInternal
extends Compiler {
    static /* synthetic */ Class class$0;

    public JavacCompilerInternal() {
        this.setDebug(true);
        this.setDeprecation(true);
    }

    public boolean compile(File[] sources, CompileObserver watcher, boolean internal) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCompileOptions());
        int i = 0;
        while (i < sources.length) {
            args.add(sources[i].getPath());
            ++i;
        }
        int length = args.size();
        String[] params = new String[length];
        args.toArray(params);
        Class<?> compiler = null;
        Method compileMethod = null;
        try {
            compiler = Class.forName("com.sun.tools.javac.Main");
            if (compiler == null) {
                return false;
            }
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] p = classArray;
            compileMethod = compiler.getMethod("compile", p);
        }
        catch (ClassNotFoundException e) {
            Debug.message("com.sun.tools.javac.Main compiler is not available");
            return false;
        }
        catch (NoSuchMethodException e) {
            Debug.message("com.sun.tools.javac.Main compile method could not be found");
            return false;
        }
        if (compileMethod == null) {
            return false;
        }
        PrintStream systemErr = System.err;
        JavacErrorStream output = new JavacErrorStream(internal);
        System.setErr(output);
        int result = 1;
        try {
            Object[] arguments = new Object[]{params};
            Object objResult = compileMethod.invoke(compiler.newInstance(), arguments);
            result = (Integer)objResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (output.hasError()) {
            watcher.errorMessage(output.getFilename(), output.getLineNo(), output.getMessage());
        }
        CompilerWarningDialog warningDialog = CompilerWarningDialog.getDialog();
        if (output.hasWarnings()) {
            warningDialog.setWarningMessage(output.getWarning());
        } else {
            warningDialog.reset();
        }
        System.setErr(systemErr);
        return result == 0;
    }
}

