/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;

public final class EventqueueCompileObserver
implements CompileObserver,
Runnable {
    private CompileObserver link;
    private int command;
    private static final int COMMAND_START = 0;
    private static final int COMMAND_ERROR = 1;
    private static final int COMMAND_END = 2;
    private File[] sources;
    private boolean successful;
    private String filename;
    private int lineNo;
    private String message;

    public EventqueueCompileObserver(CompileObserver link) {
        this.link = link;
    }

    private void runOnEventQueue() {
        try {
            EventQueue.invokeAndWait(this);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    public synchronized void startCompile(File[] csources) {
        this.command = 0;
        this.sources = csources;
        this.runOnEventQueue();
    }

    public synchronized void errorMessage(String filename, int lineNo, String message) {
        this.command = 1;
        this.filename = filename;
        this.lineNo = lineNo;
        this.message = message;
        this.runOnEventQueue();
    }

    public synchronized void endCompile(File[] sources, boolean successful) {
        this.command = 2;
        this.sources = sources;
        this.successful = successful;
        this.runOnEventQueue();
    }

    public void run() {
        switch (this.command) {
            case 0: {
                this.link.startCompile(this.sources);
                break;
            }
            case 1: {
                this.link.errorMessage(this.filename, this.lineNo, this.message);
                break;
            }
            case 2: {
                this.link.endCompile(this.sources, this.successful);
            }
        }
    }
}

