/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.utility.MultiLineLabel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CompilerWarningDialog
extends JFrame
implements ActionListener {
    static final String close = Config.getString("close");
    static final String dialogTitle = Config.getString("compiler.warningDialog.title");
    static final String subTitle = Config.getString("compiler.warningDialog.label");
    static final String noWarnings = Config.getString("compiler.warningDialog.noWarnings");
    private MultiLineLabel warningLabel;
    private static CompilerWarningDialog dialog;

    private CompilerWarningDialog() {
        super(dialogTitle);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                CompilerWarningDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 12, 12, 40));
        mainPanel.add(Box.createVerticalStrut(17));
        JLabel subTitleLabel = new JLabel(subTitle);
        mainPanel.add(subTitleLabel);
        mainPanel.add(Box.createVerticalStrut(10));
        this.warningLabel = new MultiLineLabel();
        mainPanel.add(this.warningLabel);
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.5f);
        JButton closeButton = new JButton(close);
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        this.getRootPane().setDefaultButton(closeButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    public static CompilerWarningDialog getDialog() {
        if (dialog == null) {
            dialog = new CompilerWarningDialog();
        }
        return dialog;
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (close.equals(cmd)) {
            this.doClose();
        }
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void setWarningMessage(String warning) {
        this.warningLabel.setText(warning);
        this.pack();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void reset() {
        this.warningLabel.setText(noWarnings);
        this.pack();
    }
}

