/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.compiler.Job;
import bluej.utility.Queue;

class CompilerThread
extends Thread {
    private Queue jobs = new Queue();
    private boolean busy = true;

    public CompilerThread() {
        super(Config.getString("compiler.thread.title"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Job job;
            CompilerThread compilerThread = this;
            synchronized (compilerThread) {
                while ((job = (Job)this.jobs.dequeue()) == null) {
                    this.busy = false;
                    this.notifyAll();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            job.compile();
        }
    }

    public synchronized void addJob(Job job) {
        this.jobs.enqueue(job);
        this.busy = true;
        this.notifyAll();
    }

    public boolean isBusy() {
        return this.busy;
    }
}

