/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.utility.Debug;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;

public final class BPClassLoader
extends URLClassLoader {
    public BPClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public final boolean sameUrls(URL[] compare) {
        URL[] original = this.getURLs();
        if (original == null) {
            return false;
        }
        if (original.length != compare.length) {
            return false;
        }
        int index = 0;
        while (index < original.length) {
            if (!original[index].equals(compare[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public String getClassPathAsString() {
        return BPClassLoader.toClasspathString(this.getClassPathAsFiles());
    }

    public static final String toClasspathString(File[] files) {
        if (files == null || files.length < 1) {
            return "";
        }
        boolean addSeparator = false;
        StringBuffer buf = new StringBuffer();
        int index = 0;
        while (index < files.length) {
            File file = files[index];
            if (file != null) {
                if (addSeparator) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file.toString());
                addSeparator = true;
            }
            ++index;
        }
        return buf.toString();
    }

    public final File[] getClassPathAsFiles() {
        return BPClassLoader.toFiles(super.getURLs());
    }

    public static final File[] toFiles(URL[] urls) {
        if (urls == null || urls.length < 1) {
            return new File[0];
        }
        File[] risul = new File[urls.length];
        int index = 0;
        while (index < urls.length) {
            URL url = urls[index];
            try {
                risul[index] = new File(new URI(url.toString()));
            }
            catch (URISyntaxException use) {
                Debug.reportError("BPClassLoader.toFiles(urls) invalid url=" + url.getPath());
            }
            ++index;
        }
        return risul;
    }

    public String toString() {
        return "BPClassLoader path=" + this.getClassPathAsString();
    }
}

