/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.SyntaxUtilities;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class PythonTokenMarker
extends TokenMarker {
    private static final byte TRIPLEQUOTE1 = 100;
    private static final byte TRIPLEQUOTE2 = 126;
    private static KeywordMap pyKeywords;
    private KeywordMap keywords = PythonTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        int i = offset;
        block16: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (token) {
                    case 0: {
                        switch (c) {
                            case '#': {
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, token);
                                this.addToken(length - i, (byte)1);
                                this.lastOffset = this.lastKeyword = length;
                                break block16;
                            }
                            case '\"': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = SyntaxUtilities.regionMatches(false, line, i1, "\"\"") ? (byte)100 : (byte)4;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '\'': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = SyntaxUtilities.regionMatches(false, line, i1, "''") ? (byte)126 : (byte)13;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_') break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(i1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 13: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, (byte)4);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 100: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (!SyntaxUtilities.regionMatches(false, line, i, "\"\"\"")) break;
                        this.addToken((i += 4) - this.lastOffset, (byte)4);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i;
                        break;
                    }
                    case 126: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (!SyntaxUtilities.regionMatches(false, line, i, "'''")) break;
                        this.addToken((i += 4) - this.lastOffset, (byte)4);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token);
                    }
                }
            }
            ++i;
        }
        switch (token) {
            case 100: 
            case 126: {
                this.addToken(length - this.lastOffset, (byte)4);
                break;
            }
            case 0: {
                this.doKeyword(line, length, '\u0000');
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (pyKeywords == null) {
            pyKeywords = new KeywordMap(false);
            pyKeywords.add("and", (byte)9);
            pyKeywords.add("not", (byte)9);
            pyKeywords.add("or", (byte)9);
            pyKeywords.add("if", (byte)7);
            pyKeywords.add("for", (byte)7);
            pyKeywords.add("assert", (byte)7);
            pyKeywords.add("break", (byte)7);
            pyKeywords.add("continue", (byte)7);
            pyKeywords.add("elif", (byte)7);
            pyKeywords.add("else", (byte)7);
            pyKeywords.add("except", (byte)7);
            pyKeywords.add("exec", (byte)7);
            pyKeywords.add("finally", (byte)7);
            pyKeywords.add("raise", (byte)7);
            pyKeywords.add("return", (byte)7);
            pyKeywords.add("try", (byte)7);
            pyKeywords.add("while", (byte)7);
            pyKeywords.add("def", (byte)8);
            pyKeywords.add("class", (byte)8);
            pyKeywords.add("del", (byte)8);
            pyKeywords.add("from", (byte)8);
            pyKeywords.add("global", (byte)8);
            pyKeywords.add("import", (byte)8);
            pyKeywords.add("in", (byte)8);
            pyKeywords.add("is", (byte)8);
            pyKeywords.add("lambda", (byte)8);
            pyKeywords.add("pass", (byte)8);
            pyKeywords.add("print", (byte)8);
        }
        return pyKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

