/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.SyntaxUtilities;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class PerlTokenMarker
extends TokenMarker {
    public static final byte S_ONE = 100;
    public static final byte S_TWO = 101;
    public static final byte S_END = 102;
    private KeywordMap keywords;
    private byte token;
    private int lastOffset;
    private int lastKeyword;
    private char matchChar;
    private boolean matchCharBracket;
    private boolean matchSpacesAllowed;
    private static KeywordMap perlKeywords;

    public PerlTokenMarker() {
        this(PerlTokenMarker.getKeywords());
    }

    public PerlTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
    }

    public byte markTokensImpl(byte _token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;
        this.token = _token;
        this.lastOffset = offset;
        this.lastKeyword = offset;
        this.matchChar = '\u0000';
        this.matchCharBracket = false;
        this.matchSpacesAllowed = false;
        int length = line.count + offset;
        if (this.token == 4 && lineIndex != 0 && this.lineInfo[lineIndex - 1].obj != null) {
            String str = (String)this.lineInfo[lineIndex - 1].obj;
            if (str != null && str.length() == line.count && SyntaxUtilities.regionMatches(false, line, offset, str)) {
                this.addToken(line.count, this.token);
                return 0;
            }
            this.addToken(line.count, this.token);
            this.lineInfo[lineIndex].obj = str;
            return this.token;
        }
        boolean backslash = false;
        int i = offset;
        block37: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (this.token) {
                    case 0: {
                        switch (c) {
                            case '#': {
                                if (this.doKeyword(line, i, c)) break block0;
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, this.token);
                                this.addToken(length - i, (byte)1);
                                this.lastOffset = this.lastKeyword = length;
                                break block37;
                            }
                            case '=': {
                                backslash = false;
                                if (i == offset) {
                                    this.token = (byte)2;
                                    this.addToken(length - i, this.token);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block37;
                                }
                                this.doKeyword(line, i, c);
                                break;
                            }
                            case '$': 
                            case '%': 
                            case '&': 
                            case '@': {
                                backslash = false;
                                if (this.doKeyword(line, i, c)) break block0;
                                if (length - i <= 1) break block0;
                                if (c == '&' && (array[i1] == '&' || Character.isWhitespace(array[i1]))) {
                                    ++i;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, this.token);
                                this.lastOffset = this.lastKeyword = i;
                                this.token = (byte)8;
                                break;
                            }
                            case '\"': {
                                if (this.doKeyword(line, i, c)) break block0;
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, this.token);
                                this.token = (byte)4;
                                this.lineInfo[lineIndex].obj = null;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '\'': {
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                int oldLastKeyword = this.lastKeyword;
                                if (this.doKeyword(line, i, c) || i != oldLastKeyword) break block0;
                                this.addToken(i - this.lastOffset, this.token);
                                this.token = (byte)13;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '`': {
                                if (this.doKeyword(line, i, c)) break block0;
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, this.token);
                                this.token = (byte)10;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '<': {
                                if (this.doKeyword(line, i, c)) break block0;
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                if (length - i <= 2 || array[i1] != '<' || Character.isWhitespace(array[i + 2])) break block0;
                                this.addToken(i - this.lastOffset, this.token);
                                this.lastOffset = this.lastKeyword = i;
                                this.token = (byte)4;
                                int len = length - (i + 2);
                                if (array[length - 1] == ';') {
                                    --len;
                                }
                                this.lineInfo[lineIndex].obj = this.createReadinString(array, i + 2, len);
                                break;
                            }
                            case ':': {
                                backslash = false;
                                if (this.doKeyword(line, i, c) || this.lastKeyword != 0) break block0;
                                this.addToken(i1 - this.lastOffset, (byte)6);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            case '-': {
                                backslash = false;
                                if (this.doKeyword(line, i, c)) break block0;
                                if (i != this.lastKeyword) break block0;
                                if (length - i <= 1) break block0;
                                switch (array[i1]) {
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'M': 
                                    case 'O': 
                                    case 'R': 
                                    case 'S': 
                                    case 'T': 
                                    case 'W': 
                                    case 'X': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': 
                                    case 'g': 
                                    case 'k': 
                                    case 'l': 
                                    case 'o': 
                                    case 'p': 
                                    case 'r': 
                                    case 's': 
                                    case 't': 
                                    case 'u': 
                                    case 'w': 
                                    case 'x': 
                                    case 'z': {
                                        this.addToken(i - this.lastOffset, this.token);
                                        this.addToken(2, (byte)9);
                                        this.lastOffset = this.lastKeyword = i + 2;
                                        ++i;
                                    }
                                }
                                break;
                            }
                            case '/': 
                            case '?': {
                                if (this.doKeyword(line, i, c)) break block0;
                                if (length - i <= 1) break block0;
                                backslash = false;
                                char ch = array[i1];
                                if (Character.isWhitespace(ch)) break block0;
                                this.matchChar = c;
                                this.matchSpacesAllowed = false;
                                this.addToken(i - this.lastOffset, this.token);
                                this.token = (byte)100;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_') break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 8: {
                        backslash = false;
                        if (Character.isLetterOrDigit(c) || c == '_' || c == '#' || c == '\'' || c == ':' || c == '&') break;
                        if (i != offset && array[i - 1] == '$') {
                            this.addToken(i1 - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        this.addToken(i - this.lastOffset, this.token);
                        this.lastOffset = this.lastKeyword = i--;
                        this.token = 0;
                        break;
                    }
                    case 100: 
                    case 101: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (this.matchChar == '\u0000') {
                            if (Character.isWhitespace(this.matchChar) && !this.matchSpacesAllowed) break;
                            this.matchChar = c;
                            break;
                        }
                        switch (this.matchChar) {
                            case '(': {
                                this.matchChar = (char)41;
                                this.matchCharBracket = true;
                                break;
                            }
                            case '[': {
                                this.matchChar = (char)93;
                                this.matchCharBracket = true;
                                break;
                            }
                            case '{': {
                                this.matchChar = (char)125;
                                this.matchCharBracket = true;
                                break;
                            }
                            case '<': {
                                this.matchChar = (char)62;
                                this.matchCharBracket = true;
                                break;
                            }
                            default: {
                                this.matchCharBracket = false;
                            }
                        }
                        if (c != this.matchChar) break;
                        if (this.token == 101) {
                            this.token = (byte)100;
                            if (!this.matchCharBracket) break;
                            this.matchChar = '\u0000';
                            break;
                        }
                        this.token = (byte)102;
                        this.addToken(i1 - this.lastOffset, (byte)13);
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 102: {
                        backslash = false;
                        if (Character.isLetterOrDigit(c) || c == '_') break;
                        this.doKeyword(line, i, c);
                        break;
                    }
                    case 2: {
                        backslash = false;
                        if (i != offset) break;
                        this.addToken(line.count, this.token);
                        if (length - i > 3 && SyntaxUtilities.regionMatches(false, line, offset, "=cut")) {
                            this.token = 0;
                        }
                        this.lastOffset = this.lastKeyword = length;
                        break block37;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(i1 - this.lastOffset, this.token);
                        this.token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 13: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, (byte)4);
                        this.token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 10: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '`') break;
                        this.addToken(i1 - this.lastOffset, this.token);
                        this.token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + this.token);
                    }
                }
            }
            ++i;
        }
        if (this.token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (this.token) {
            case 8: {
                this.addToken(length - this.lastOffset, this.token);
                this.token = 0;
                break;
            }
            case 13: {
                this.addToken(length - this.lastOffset, (byte)4);
                break;
            }
            case 102: {
                this.addToken(length - this.lastOffset, (byte)13);
                this.token = 0;
                break;
            }
            case 100: 
            case 101: {
                this.addToken(length - this.lastOffset, (byte)11);
                this.token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, this.token);
            }
        }
        return this.token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        if (this.token == 102) {
            this.addToken(i - this.lastOffset, (byte)13);
            this.token = 0;
            this.lastOffset = i;
            this.lastKeyword = i1;
            return false;
        }
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id == 100 || id == 101) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, (byte)13);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.matchChar = Character.isWhitespace(c) ? (char)'\u0000' : c;
            this.matchSpacesAllowed = true;
            this.token = id;
            return true;
        }
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }

    private String createReadinString(char[] array, int start, int len) {
        int idx1 = start;
        int idx2 = start + len - 1;
        while (idx1 <= idx2 && !Character.isLetterOrDigit(array[idx1])) {
            ++idx1;
        }
        while (idx1 <= idx2 && !Character.isLetterOrDigit(array[idx2])) {
            --idx2;
        }
        return new String(array, idx1, idx2 - idx1 + 1);
    }

    private static KeywordMap getKeywords() {
        if (perlKeywords == null) {
            perlKeywords = new KeywordMap(false);
            perlKeywords.add("my", (byte)7);
            perlKeywords.add("local", (byte)7);
            perlKeywords.add("new", (byte)7);
            perlKeywords.add("if", (byte)7);
            perlKeywords.add("until", (byte)7);
            perlKeywords.add("while", (byte)7);
            perlKeywords.add("elsif", (byte)7);
            perlKeywords.add("else", (byte)7);
            perlKeywords.add("eval", (byte)7);
            perlKeywords.add("unless", (byte)7);
            perlKeywords.add("foreach", (byte)7);
            perlKeywords.add("continue", (byte)7);
            perlKeywords.add("exit", (byte)7);
            perlKeywords.add("die", (byte)7);
            perlKeywords.add("last", (byte)7);
            perlKeywords.add("goto", (byte)7);
            perlKeywords.add("next", (byte)7);
            perlKeywords.add("redo", (byte)7);
            perlKeywords.add("goto", (byte)7);
            perlKeywords.add("return", (byte)7);
            perlKeywords.add("do", (byte)7);
            perlKeywords.add("sub", (byte)7);
            perlKeywords.add("use", (byte)7);
            perlKeywords.add("require", (byte)7);
            perlKeywords.add("package", (byte)7);
            perlKeywords.add("BEGIN", (byte)7);
            perlKeywords.add("END", (byte)7);
            perlKeywords.add("eq", (byte)10);
            perlKeywords.add("ne", (byte)10);
            perlKeywords.add("not", (byte)10);
            perlKeywords.add("and", (byte)10);
            perlKeywords.add("or", (byte)10);
            perlKeywords.add("abs", (byte)9);
            perlKeywords.add("accept", (byte)9);
            perlKeywords.add("alarm", (byte)9);
            perlKeywords.add("atan2", (byte)9);
            perlKeywords.add("bind", (byte)9);
            perlKeywords.add("binmode", (byte)9);
            perlKeywords.add("bless", (byte)9);
            perlKeywords.add("caller", (byte)9);
            perlKeywords.add("chdir", (byte)9);
            perlKeywords.add("chmod", (byte)9);
            perlKeywords.add("chomp", (byte)9);
            perlKeywords.add("chr", (byte)9);
            perlKeywords.add("chroot", (byte)9);
            perlKeywords.add("chown", (byte)9);
            perlKeywords.add("closedir", (byte)9);
            perlKeywords.add("close", (byte)9);
            perlKeywords.add("connect", (byte)9);
            perlKeywords.add("cos", (byte)9);
            perlKeywords.add("crypt", (byte)9);
            perlKeywords.add("dbmclose", (byte)9);
            perlKeywords.add("dbmopen", (byte)9);
            perlKeywords.add("defined", (byte)9);
            perlKeywords.add("delete", (byte)9);
            perlKeywords.add("die", (byte)9);
            perlKeywords.add("dump", (byte)9);
            perlKeywords.add("each", (byte)9);
            perlKeywords.add("endgrent", (byte)9);
            perlKeywords.add("endhostent", (byte)9);
            perlKeywords.add("endnetent", (byte)9);
            perlKeywords.add("endprotoent", (byte)9);
            perlKeywords.add("endpwent", (byte)9);
            perlKeywords.add("endservent", (byte)9);
            perlKeywords.add("eof", (byte)9);
            perlKeywords.add("exec", (byte)9);
            perlKeywords.add("exists", (byte)9);
            perlKeywords.add("exp", (byte)9);
            perlKeywords.add("fctnl", (byte)9);
            perlKeywords.add("fileno", (byte)9);
            perlKeywords.add("flock", (byte)9);
            perlKeywords.add("fork", (byte)9);
            perlKeywords.add("format", (byte)9);
            perlKeywords.add("formline", (byte)9);
            perlKeywords.add("getc", (byte)9);
            perlKeywords.add("getgrent", (byte)9);
            perlKeywords.add("getgrgid", (byte)9);
            perlKeywords.add("getgrnam", (byte)9);
            perlKeywords.add("gethostbyaddr", (byte)9);
            perlKeywords.add("gethostbyname", (byte)9);
            perlKeywords.add("gethostent", (byte)9);
            perlKeywords.add("getlogin", (byte)9);
            perlKeywords.add("getnetbyaddr", (byte)9);
            perlKeywords.add("getnetbyname", (byte)9);
            perlKeywords.add("getnetent", (byte)9);
            perlKeywords.add("getpeername", (byte)9);
            perlKeywords.add("getpgrp", (byte)9);
            perlKeywords.add("getppid", (byte)9);
            perlKeywords.add("getpriority", (byte)9);
            perlKeywords.add("getprotobyname", (byte)9);
            perlKeywords.add("getprotobynumber", (byte)9);
            perlKeywords.add("getprotoent", (byte)9);
            perlKeywords.add("getpwent", (byte)9);
            perlKeywords.add("getpwnam", (byte)9);
            perlKeywords.add("getpwuid", (byte)9);
            perlKeywords.add("getservbyname", (byte)9);
            perlKeywords.add("getservbyport", (byte)9);
            perlKeywords.add("getservent", (byte)9);
            perlKeywords.add("getsockname", (byte)9);
            perlKeywords.add("getsockopt", (byte)9);
            perlKeywords.add("glob", (byte)9);
            perlKeywords.add("gmtime", (byte)9);
            perlKeywords.add("grep", (byte)9);
            perlKeywords.add("hex", (byte)9);
            perlKeywords.add("import", (byte)9);
            perlKeywords.add("index", (byte)9);
            perlKeywords.add("int", (byte)9);
            perlKeywords.add("ioctl", (byte)9);
            perlKeywords.add("join", (byte)9);
            perlKeywords.add("keys", (byte)9);
            perlKeywords.add("kill", (byte)9);
            perlKeywords.add("lcfirst", (byte)9);
            perlKeywords.add("lc", (byte)9);
            perlKeywords.add("length", (byte)9);
            perlKeywords.add("link", (byte)9);
            perlKeywords.add("listen", (byte)9);
            perlKeywords.add("log", (byte)9);
            perlKeywords.add("localtime", (byte)9);
            perlKeywords.add("lstat", (byte)9);
            perlKeywords.add("map", (byte)9);
            perlKeywords.add("mkdir", (byte)9);
            perlKeywords.add("msgctl", (byte)9);
            perlKeywords.add("msgget", (byte)9);
            perlKeywords.add("msgrcv", (byte)9);
            perlKeywords.add("no", (byte)9);
            perlKeywords.add("oct", (byte)9);
            perlKeywords.add("opendir", (byte)9);
            perlKeywords.add("open", (byte)9);
            perlKeywords.add("ord", (byte)9);
            perlKeywords.add("pack", (byte)9);
            perlKeywords.add("pipe", (byte)9);
            perlKeywords.add("pop", (byte)9);
            perlKeywords.add("pos", (byte)9);
            perlKeywords.add("printf", (byte)9);
            perlKeywords.add("print", (byte)9);
            perlKeywords.add("push", (byte)9);
            perlKeywords.add("quotemeta", (byte)9);
            perlKeywords.add("rand", (byte)9);
            perlKeywords.add("readdir", (byte)9);
            perlKeywords.add("read", (byte)9);
            perlKeywords.add("readlink", (byte)9);
            perlKeywords.add("recv", (byte)9);
            perlKeywords.add("ref", (byte)9);
            perlKeywords.add("rename", (byte)9);
            perlKeywords.add("reset", (byte)9);
            perlKeywords.add("reverse", (byte)9);
            perlKeywords.add("rewinddir", (byte)9);
            perlKeywords.add("rindex", (byte)9);
            perlKeywords.add("rmdir", (byte)9);
            perlKeywords.add("scalar", (byte)9);
            perlKeywords.add("seekdir", (byte)9);
            perlKeywords.add("seek", (byte)9);
            perlKeywords.add("select", (byte)9);
            perlKeywords.add("semctl", (byte)9);
            perlKeywords.add("semget", (byte)9);
            perlKeywords.add("semop", (byte)9);
            perlKeywords.add("send", (byte)9);
            perlKeywords.add("setgrent", (byte)9);
            perlKeywords.add("sethostent", (byte)9);
            perlKeywords.add("setnetent", (byte)9);
            perlKeywords.add("setpgrp", (byte)9);
            perlKeywords.add("setpriority", (byte)9);
            perlKeywords.add("setprotoent", (byte)9);
            perlKeywords.add("setpwent", (byte)9);
            perlKeywords.add("setsockopt", (byte)9);
            perlKeywords.add("shift", (byte)9);
            perlKeywords.add("shmctl", (byte)9);
            perlKeywords.add("shmget", (byte)9);
            perlKeywords.add("shmread", (byte)9);
            perlKeywords.add("shmwrite", (byte)9);
            perlKeywords.add("shutdown", (byte)9);
            perlKeywords.add("sin", (byte)9);
            perlKeywords.add("sleep", (byte)9);
            perlKeywords.add("socket", (byte)9);
            perlKeywords.add("socketpair", (byte)9);
            perlKeywords.add("sort", (byte)9);
            perlKeywords.add("splice", (byte)9);
            perlKeywords.add("split", (byte)9);
            perlKeywords.add("sprintf", (byte)9);
            perlKeywords.add("sqrt", (byte)9);
            perlKeywords.add("srand", (byte)9);
            perlKeywords.add("stat", (byte)9);
            perlKeywords.add("study", (byte)9);
            perlKeywords.add("substr", (byte)9);
            perlKeywords.add("symlink", (byte)9);
            perlKeywords.add("syscall", (byte)9);
            perlKeywords.add("sysopen", (byte)9);
            perlKeywords.add("sysread", (byte)9);
            perlKeywords.add("syswrite", (byte)9);
            perlKeywords.add("telldir", (byte)9);
            perlKeywords.add("tell", (byte)9);
            perlKeywords.add("tie", (byte)9);
            perlKeywords.add("tied", (byte)9);
            perlKeywords.add("time", (byte)9);
            perlKeywords.add("times", (byte)9);
            perlKeywords.add("truncate", (byte)9);
            perlKeywords.add("uc", (byte)9);
            perlKeywords.add("ucfirst", (byte)9);
            perlKeywords.add("umask", (byte)9);
            perlKeywords.add("undef", (byte)9);
            perlKeywords.add("unlink", (byte)9);
            perlKeywords.add("unpack", (byte)9);
            perlKeywords.add("unshift", (byte)9);
            perlKeywords.add("untie", (byte)9);
            perlKeywords.add("utime", (byte)9);
            perlKeywords.add("values", (byte)9);
            perlKeywords.add("vec", (byte)9);
            perlKeywords.add("wait", (byte)9);
            perlKeywords.add("waitpid", (byte)9);
            perlKeywords.add("wantarray", (byte)9);
            perlKeywords.add("warn", (byte)9);
            perlKeywords.add("write", (byte)9);
            perlKeywords.add("m", (byte)100);
            perlKeywords.add("q", (byte)100);
            perlKeywords.add("qq", (byte)100);
            perlKeywords.add("qw", (byte)100);
            perlKeywords.add("qx", (byte)100);
            perlKeywords.add("s", (byte)101);
            perlKeywords.add("tr", (byte)101);
            perlKeywords.add("y", (byte)101);
        }
        return perlKeywords;
    }
}

